/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v600;

import com.swiftmq.jms.XACompletionListener;
import com.swiftmq.jms.XAResourceExtended;
import com.swiftmq.jms.XidImpl;
import com.swiftmq.jms.smqp.v600.XAResCommitReply;
import com.swiftmq.jms.smqp.v600.XAResCommitRequest;
import com.swiftmq.jms.smqp.v600.XAResEndReply;
import com.swiftmq.jms.smqp.v600.XAResEndRequest;
import com.swiftmq.jms.smqp.v600.XAResGetTxTimeoutReply;
import com.swiftmq.jms.smqp.v600.XAResGetTxTimeoutRequest;
import com.swiftmq.jms.smqp.v600.XAResPrepareReply;
import com.swiftmq.jms.smqp.v600.XAResPrepareRequest;
import com.swiftmq.jms.smqp.v600.XAResRecoverReply;
import com.swiftmq.jms.smqp.v600.XAResRecoverRequest;
import com.swiftmq.jms.smqp.v600.XAResRollbackReply;
import com.swiftmq.jms.smqp.v600.XAResRollbackRequest;
import com.swiftmq.jms.smqp.v600.XAResSetTxTimeoutReply;
import com.swiftmq.jms.smqp.v600.XAResSetTxTimeoutRequest;
import com.swiftmq.jms.smqp.v600.XAResStartReply;
import com.swiftmq.jms.smqp.v600.XAResStartRequest;
import com.swiftmq.jms.v600.XARecoverRegistry;
import com.swiftmq.jms.v600.XASessionImpl;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.ValidationException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResourceExtended,
RequestRetryValidator {
    private static final SimpleDateFormat format = new SimpleDateFormat("yyMMdd:HH:mm:ss.SSS");
    XASessionImpl session = null;
    Map xidMapping = new HashMap();
    XACompletionListener completionListener = null;
    int nRecoverCalls = 0;
    PrintWriter logWriter = null;
    int lastEndRequestConnectionId = -1;

    XAResourceImpl(XASessionImpl session) {
        this.session = session;
        session.getSessionImpl().setAutoAssign(false);
        session.getSessionImpl().setXaMode(true);
    }

    @Override
    public void setNeverSameRM(boolean neverSameRM) {
    }

    private boolean endRequestInDoubt() {
        boolean rc = false;
        int connectionId = this.session.getSessionImpl().getMyConnection().getConnectionId();
        if (this.lastEndRequestConnectionId == -1 || connectionId == -1) {
            rc = false;
        } else {
            boolean bl = rc = this.lastEndRequestConnectionId < connectionId;
        }
        if (this.logWriter != null) {
            this.log(this.toString() + "/endRequestInDoubt, rc=" + rc + ", lastEndRequestConnectionId" + this.lastEndRequestConnectionId + ", connectionId=" + connectionId);
        }
        return rc;
    }

    @Override
    public void validate(Request request) throws ValidationException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/validate, request=" + request + " ...");
        }
        request.setDispatchId(this.session.getDispatchId());
        request.setConnectionId(this.session.getSessionImpl().getMyConnection().getConnectionId());
        if (request instanceof XAResStartRequest) {
            XAResStartRequest r = (XAResStartRequest)request;
            r.setRetry(true);
            List l = XARecoverRegistry.getInstance().getRequestList(r.getXid());
            r.setRecoverRequestList(l);
        } else if (request instanceof XAResEndRequest) {
            XAResEndRequest r = (XAResEndRequest)request;
            r.setRetry(true);
            List l = XARecoverRegistry.getInstance().getRequestList(r.getXid());
            r.setRecoverRequestList(l);
        } else if (request instanceof XAResPrepareRequest) {
            XAResPrepareRequest r = (XAResPrepareRequest)request;
            r.setRetry(true);
            List l = XARecoverRegistry.getInstance().getRequestList(r.getXid());
            r.setRecoverRequestList(l);
        } else if (request instanceof XAResCommitRequest) {
            XAResCommitRequest r = (XAResCommitRequest)request;
            r.setRetry(true);
            List l = XARecoverRegistry.getInstance().getRequestList(r.getXid());
            r.setRecoverRequestList(l);
        } else if (request instanceof XAResRollbackRequest) {
            XAResRollbackRequest r = (XAResRollbackRequest)request;
            r.setRetry(true);
            List l = XARecoverRegistry.getInstance().getRequestList(r.getXid());
            r.setRecoverRequestList(l);
        }
        if (this.logWriter != null) {
            this.log(this.toString() + "/validate, request=" + request + " done");
        }
    }

    private XidImpl toSwiftMQXid(Xid xid) {
        XidImpl rXid = null;
        if (xid instanceof XidImpl) {
            rXid = (XidImpl)xid;
        } else {
            rXid = (XidImpl)this.xidMapping.get(xid);
            if (rXid == null) {
                rXid = new XidImpl(xid);
                this.xidMapping.put(xid, rXid);
            }
        }
        if (this.logWriter != null) {
            this.log(this.toString() + "/toSwiftMQXid, xid=" + xid + ", rXid=" + rXid);
        }
        return rXid;
    }

    private Xid[] toArray(List xidList) {
        if (this.logWriter != null) {
            this.log(this.toString() + "/toArray, xidList=" + xidList);
        }
        if (xidList == null || xidList.size() == 0) {
            return new Xid[0];
        }
        Xid[] xids = new Xid[xidList.size()];
        for (int i = 0; i < xidList.size(); ++i) {
            xids[i] = (Xid)xidList.get(i);
        }
        return xids;
    }

    private boolean isFlagSet(int flags, int flag) {
        return (flags & flag) == flag;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    protected void log(String msg) {
        try {
            this.logWriter.println(format.format(new Date()) + "/" + msg);
            this.logWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void setCompletionListener(XACompletionListener completionListener) {
        this.completionListener = completionListener;
    }

    @Override
    public String getRouterName() {
        return this.session.getSessionImpl().myConnection.metaData.getRouterName();
    }

    @Override
    public synchronized boolean setTransactionTimeout(int seconds) throws XAException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/setTransactionTimeout, seconds=" + seconds);
        }
        XAResSetTxTimeoutReply reply = null;
        try {
            reply = (XAResSetTxTimeoutReply)this.session.request(new XAResSetTxTimeoutRequest(this, this.session.getDispatchId(), seconds * 1000));
            if (!reply.isOk()) {
                throw reply.getException();
            }
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        return true;
    }

    @Override
    public synchronized int getTransactionTimeout() throws XAException {
        XAResGetTxTimeoutReply reply = null;
        try {
            reply = (XAResGetTxTimeoutReply)this.session.request(new XAResGetTxTimeoutRequest(this, this.session.getDispatchId()));
            if (!reply.isOk()) {
                throw reply.getException();
            }
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        int secs = (int)(reply.getTxTimeout() / 1000L);
        if (this.logWriter != null) {
            this.log(this.toString() + "/getTransactionTimeout, secs=" + secs);
        }
        return secs;
    }

    @Override
    public boolean isSameRM(XAResource resource) throws XAException {
        boolean b = false;
        if (resource instanceof XAResourceExtended) {
            XAResourceExtended that = (XAResourceExtended)resource;
            b = that.getRouterName().equals(this.getRouterName());
        }
        if (this.logWriter != null) {
            this.log(this.toString() + "/isSameRM, resource=" + resource + ", returns=" + b);
        }
        return b;
    }

    @Override
    public synchronized Xid[] recover(int flag) throws XAException {
        if (this.isFlagSet(flag, 0x1000000)) {
            if (this.logWriter != null) {
                this.log(this.toString() + "/TMSTARTRSCAN, flag=" + flag + ", nRecoverCalls=" + this.nRecoverCalls);
            }
            this.nRecoverCalls = 0;
        } else if (this.logWriter != null) {
            this.log(this.toString() + "/TMONOFLAGS, flag=" + flag + ", nRecoverCalls=" + this.nRecoverCalls);
        }
        if (this.nRecoverCalls > 0) {
            return new Xid[0];
        }
        ++this.nRecoverCalls;
        XAResRecoverReply reply = null;
        try {
            reply = (XAResRecoverReply)this.session.request(new XAResRecoverRequest(this, this.session.getDispatchId(), flag));
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        if (reply.isOk()) {
            return this.toArray(reply.getXids());
        }
        XAException ex = new XAException(reply.getException().getMessage());
        ex.errorCode = reply.getErrorCode();
        throw ex;
    }

    @Override
    public synchronized void start(Xid xid, int flags) throws XAException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/start, xid=" + xid + ", flags=" + flags);
        }
        XidImpl sxid = this.toSwiftMQXid(xid);
        XAResStartReply reply = null;
        int connectionId = this.session.getSessionImpl().getMyConnection().getConnectionId();
        XAResStartRequest request = new XAResStartRequest(this, this.session.getDispatchId(), sxid, flags, false, null);
        request.setConnectionId(connectionId);
        try {
            reply = (XAResStartReply)this.session.request(request);
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        if (!reply.isOk()) {
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        XARecoverRegistry.getInstance().addRequest(sxid, request);
        try {
            this.session.session.assignLastMessage();
        }
        catch (Exception e) {
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        if (this.completionListener != null) {
            this.completionListener.transactionStarted(sxid, this.session);
        }
    }

    @Override
    public synchronized void end(Xid xid, int flags) throws XAException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/end, xid=" + xid + ", flags=" + flags);
        }
        XidImpl sxid = this.toSwiftMQXid(xid);
        XAResEndReply reply = null;
        XAResEndRequest request = null;
        try {
            int connectionId = this.session.getSessionImpl().getMyConnection().getConnectionId();
            List content = this.session.getAndClearCurrentTransaction();
            if (content != null && content.size() == 0) {
                content = null;
            }
            request = new XAResEndRequest(this, this.session.getDispatchId(), sxid, flags, false, content, XARecoverRegistry.getInstance().getRequestList(sxid));
            request.setConnectionId(connectionId);
            this.lastEndRequestConnectionId = connectionId;
            reply = (XAResEndReply)this.session.request(request);
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        if (!reply.isOk()) {
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        request.setRecoverRequestList(null);
        XARecoverRegistry.getInstance().addRequest(sxid, request);
        if (this.completionListener != null) {
            this.completionListener.transactionEnded(sxid);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/forget, xid=" + xid);
        }
    }

    @Override
    public synchronized int prepare(Xid xid) throws XAException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/prepare, xid=" + xid);
        }
        XidImpl sxid = this.toSwiftMQXid(xid);
        XAResPrepareReply reply = null;
        try {
            int connectionId = this.session.getSessionImpl().getMyConnection().getConnectionId();
            XAResPrepareRequest request = new XAResPrepareRequest(this, this.session.getDispatchId(), sxid, false, this.endRequestInDoubt() ? XARecoverRegistry.getInstance().getRequestList(sxid) : null);
            request.setConnectionId(connectionId);
            reply = (XAResPrepareReply)this.session.request(request);
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        if (!reply.isOk()) {
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        XARecoverRegistry.getInstance().clear(sxid);
        return 0;
    }

    @Override
    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/commit, xid=" + xid + ", onePhase=" + onePhase);
        }
        XidImpl sxid = this.toSwiftMQXid(xid);
        this.xidMapping.remove(xid);
        XAResCommitReply reply = null;
        try {
            int connectionId = this.session.getSessionImpl().getMyConnection().getConnectionId();
            XAResCommitRequest req = new XAResCommitRequest(this, this.session.getDispatchId(), sxid, onePhase, false, onePhase && this.endRequestInDoubt() ? XARecoverRegistry.getInstance().getRequestList(sxid) : null);
            req.setConnectionId(connectionId);
            reply = (XAResCommitReply)this.session.request(req);
        }
        catch (Exception e) {
            if (this.completionListener != null) {
                this.completionListener.transactionCommitted(sxid);
            }
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        if (!reply.isOk()) {
            if (this.completionListener != null) {
                this.completionListener.transactionCommitted(sxid);
            }
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        try {
            this.session.getSessionImpl().afterCommit();
        }
        catch (JMSException e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        if (reply.getDelay() > 0L) {
            try {
                Thread.sleep(reply.getDelay());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.completionListener != null) {
            this.completionListener.transactionCommitted(sxid);
        }
        XARecoverRegistry.getInstance().clear(sxid);
    }

    @Override
    public synchronized void rollback(Xid xid) throws XAException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/rollback, xid=" + xid);
        }
        XidImpl sxid = this.toSwiftMQXid(xid);
        this.xidMapping.remove(xid);
        XAResRollbackReply reply = null;
        try {
            int connectionId = this.session.getSessionImpl().getMyConnection().getConnectionId();
            this.session.getSessionImpl().startRecoverConsumers();
            this.session.getAndClearCurrentTransaction();
            List recoveryList = null;
            if (this.endRequestInDoubt()) {
                recoveryList = XARecoverRegistry.getInstance().getRequestList(sxid);
            }
            XAResRollbackRequest request = new XAResRollbackRequest(this, this.session.getDispatchId(), sxid, false, recoveryList, this.session.getSessionImpl().getRecoveryEpoche());
            request.setConnectionId(connectionId);
            reply = (XAResRollbackReply)this.session.request(request);
        }
        catch (Exception e) {
            if (this.completionListener != null) {
                this.completionListener.transactionAborted(sxid);
            }
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        if (reply.isOk()) {
            this.session.getSessionImpl().endRecoverConsumers();
            try {
                this.session.getSessionImpl().closeDelayedProducers();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            if (this.completionListener != null) {
                this.completionListener.transactionAborted(sxid);
            }
        } else {
            if (this.completionListener != null) {
                this.completionListener.transactionAborted(sxid);
            }
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        XARecoverRegistry.getInstance().clear(sxid);
    }
}

