/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v610;

import com.swiftmq.jms.ExceptionConverter;
import com.swiftmq.jms.TopicImpl;
import com.swiftmq.jms.smqp.v610.CreateDurableReply;
import com.swiftmq.jms.smqp.v610.CreateDurableRequest;
import com.swiftmq.jms.smqp.v610.CreateSessionReply;
import com.swiftmq.jms.smqp.v610.CreateSessionRequest;
import com.swiftmq.jms.smqp.v610.CreateSubscriberReply;
import com.swiftmq.jms.smqp.v610.CreateSubscriberRequest;
import com.swiftmq.jms.v610.ConnectionConsumerImpl;
import com.swiftmq.jms.v610.ConnectionImpl;
import com.swiftmq.jms.v610.Recreatable;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRegistry;
import com.swiftmq.util.SwiftUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;

public class TopicConnectionConsumerImpl
extends ConnectionConsumerImpl
implements Recreatable {
    String queueName = null;
    boolean isDurable = false;
    TopicImpl topic = null;
    String messageSelector = null;
    String durableName = null;

    public TopicConnectionConsumerImpl(ConnectionImpl myConnection, int dispatchId, RequestRegistry requestRegistry, ServerSessionPool serverSessionPool, int maxMessages) {
        super(myConnection, dispatchId, requestRegistry, serverSessionPool, maxMessages);
    }

    @Override
    public Request getRecreateRequest() {
        return null;
    }

    @Override
    public void setRecreateReply(Reply reply) {
    }

    @Override
    public List getRecreatables() {
        ArrayList<Recreatable> list = new ArrayList<Recreatable>();
        list.add(new SessionRecreator());
        list.add(new ConsumerRecreator());
        return list;
    }

    void createSubscriber(TopicImpl topic, String messageSelector) throws JMSException {
        this.topic = topic;
        this.messageSelector = messageSelector;
        this.isDurable = false;
        Reply reply = null;
        try {
            reply = this.requestRegistry.request(new CreateSubscriberRequest(this, this.dispatchId, topic, messageSelector, false, false));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        this.queueName = ((CreateSubscriberReply)reply).getTmpQueueName();
        this.fillCache();
    }

    void createDurableSubscriber(TopicImpl topic, String messageSelector, String durableName) throws JMSException {
        this.topic = topic;
        this.messageSelector = messageSelector;
        this.durableName = durableName;
        this.isDurable = true;
        try {
            SwiftUtilities.verifyDurableName(durableName);
        }
        catch (Exception e) {
            throw new JMSException(e.getMessage());
        }
        Reply reply = null;
        try {
            reply = this.requestRegistry.request(new CreateDurableRequest(this, this.dispatchId, topic, messageSelector, false, durableName));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        this.queueName = ((CreateDurableReply)reply).getQueueName();
        this.fillCache();
    }

    @Override
    protected String getQueueName() {
        return this.queueName;
    }

    private class ConsumerRecreator
    implements Recreatable {
        private ConsumerRecreator() {
        }

        @Override
        public Request getRecreateRequest() {
            if (TopicConnectionConsumerImpl.this.isDurable) {
                return new CreateDurableRequest(TopicConnectionConsumerImpl.this, TopicConnectionConsumerImpl.this.dispatchId, TopicConnectionConsumerImpl.this.topic, TopicConnectionConsumerImpl.this.messageSelector, false, TopicConnectionConsumerImpl.this.durableName);
            }
            return new CreateSubscriberRequest(TopicConnectionConsumerImpl.this, TopicConnectionConsumerImpl.this.dispatchId, TopicConnectionConsumerImpl.this.topic, TopicConnectionConsumerImpl.this.messageSelector, false, false);
        }

        @Override
        public void setRecreateReply(Reply reply) {
        }

        @Override
        public List getRecreatables() {
            return null;
        }
    }

    private class SessionRecreator
    implements Recreatable {
        private SessionRecreator() {
        }

        @Override
        public Request getRecreateRequest() {
            return new CreateSessionRequest(TopicConnectionConsumerImpl.this, 0, false, 0, 1, 0);
        }

        @Override
        public void setRecreateReply(Reply reply) {
            CreateSessionReply r = (CreateSessionReply)reply;
            TopicConnectionConsumerImpl.this.dispatchId = r.getSessionDispatchId();
        }

        @Override
        public List getRecreatables() {
            return null;
        }
    }
}

