/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v630;

import com.swiftmq.client.thread.PoolManager;
import com.swiftmq.jms.ExceptionConverter;
import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.smqp.v630.AsyncMessageDeliveryRequest;
import com.swiftmq.jms.smqp.v630.CloseSessionRequest;
import com.swiftmq.jms.smqp.v630.StartConsumerRequest;
import com.swiftmq.jms.v630.ConnectionImpl;
import com.swiftmq.jms.v630.Recreatable;
import com.swiftmq.jms.v630.SessionImpl;
import com.swiftmq.jms.v630.XASessionImpl;
import com.swiftmq.swiftlet.queue.MessageEntry;
import com.swiftmq.swiftlet.threadpool.AsyncTask;
import com.swiftmq.swiftlet.threadpool.ThreadPool;
import com.swiftmq.tools.queue.SingleProcessorQueue;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRegistry;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestService;
import com.swiftmq.tools.requestreply.ValidationException;
import com.swiftmq.tools.tracking.MessageTracker;
import com.swiftmq.tools.util.IdGenerator;
import java.util.HashSet;
import java.util.Set;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;

public abstract class ConnectionConsumerImpl
implements ConnectionConsumer,
RequestService,
Recreatable,
RequestRetryValidator {
    public static final String DISPATCH_TOKEN = "sys$jms.client.session.connectionconsumer.queuetask";
    private static final long CC_SS_DELAY = Long.parseLong(System.getProperty("swiftmq.cc.ss.delay", "100"));
    String uniqueConsumerId = IdGenerator.getInstance().nextId('/');
    ConnectionImpl myConnection = null;
    int dispatchId = 0;
    int myDispatchId = 0;
    RequestRegistry requestRegistry = null;
    ThreadPool sessionPool = null;
    DeliveryQueue deliveryQueue = null;
    QueueTask queueTask = null;
    ServerSessionPool serverSessionPool;
    int maxMessages = 0;
    ServerSession currentServerSession = null;
    SessionImpl currentSession = null;
    int nCurrent = 0;
    boolean closed = false;
    volatile boolean resetInProgress = false;
    Set messagesInProgress = new HashSet();

    public ConnectionConsumerImpl(ConnectionImpl myConnection, int dispatchId, RequestRegistry requestRegistry, ServerSessionPool serverSessionPool, int maxMessages) {
        this.myConnection = myConnection;
        this.dispatchId = dispatchId;
        this.requestRegistry = requestRegistry;
        this.serverSessionPool = serverSessionPool;
        this.maxMessages = maxMessages;
        this.sessionPool = PoolManager.getInstance().getSessionPool();
        this.queueTask = new QueueTask();
        this.deliveryQueue = new DeliveryQueue();
    }

    private static String getMessageId(MessageImpl msg) {
        String s = null;
        try {
            s = msg.getJMSMessageID();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return s;
    }

    public void setResetInProgress(boolean resetInProgress) {
        this.resetInProgress = resetInProgress;
        if (resetInProgress) {
            this.deliveryQueue.stopQueue();
            this.deliveryQueue.clear();
            this.deliveryQueue.setCurrentCallInvalid(true);
        } else {
            this.deliveryQueue.clear();
            this.deliveryQueue.startQueue();
            this.fillCache();
        }
    }

    @Override
    public void validate(Request request) throws ValidationException {
        request.setDispatchId(this.dispatchId);
    }

    void startConsumer() {
        this.deliveryQueue.startQueue();
    }

    void stopConsumer() {
        this.deliveryQueue.stopQueue();
    }

    void fillCache() {
        this.requestRegistry.request(new StartConsumerRequest(this, this.dispatchId, 0, this.myDispatchId, 0, this.myConnection.getSmqpConsumerCacheSize()));
    }

    protected abstract String getQueueName();

    public void setMyDispatchId(int myDispatchId) {
        this.myDispatchId = myDispatchId;
    }

    int getMsgNo(AsyncMessageDeliveryRequest request) {
        int n = 0;
        try {
            n = request.getMessageEntry().getMessage().getIntProperty("no");
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        return n;
    }

    @Override
    public void serviceRequest(Request request) {
        if (MessageTracker.enabled) {
            MessageTracker.getInstance().track(((AsyncMessageDeliveryRequest)request).getMessageEntry().getMessage(), new String[]{this.myConnection.toString(), this.toString()}, "serviceRequest");
        }
        this.deliveryQueue.enqueue(request);
    }

    public boolean isDuplicate(MessageImpl msg) {
        if (!this.myConnection.isDuplicateMessageDetection()) {
            return false;
        }
        msg.setDuplicateId(SessionImpl.buildId(this.uniqueConsumerId, msg));
        return this.myConnection.isDuplicate(msg.getDuplicateId());
    }

    public void removeFromDuplicateLog(MessageImpl msg) {
        if (MessageTracker.enabled) {
            MessageTracker.getInstance().track(msg, new String[]{this.myConnection.toString(), this.toString()}, "removeFromDuplicateLog");
        }
        this.myConnection.removeFromDuplicateLog(msg.getDuplicateId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markInProgress(MessageImpl msg) {
        if (!this.myConnection.isDuplicateMessageDetection()) {
            return;
        }
        String messageId = ConnectionConsumerImpl.getMessageId(msg);
        Set set = this.messagesInProgress;
        synchronized (set) {
            if (messageId != null) {
                this.messagesInProgress.add(messageId);
                if (MessageTracker.enabled) {
                    MessageTracker.getInstance().track(msg, new String[]{this.myConnection.toString(), this.toString()}, "markInProgress, size=" + this.messagesInProgress.size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmarkInProgress(MessageImpl msg) {
        if (!this.myConnection.isDuplicateMessageDetection()) {
            return;
        }
        String messageId = ConnectionConsumerImpl.getMessageId(msg);
        Set set = this.messagesInProgress;
        synchronized (set) {
            if (messageId != null) {
                this.messagesInProgress.remove(messageId);
                if (MessageTracker.enabled) {
                    MessageTracker.getInstance().track(msg, new String[]{this.myConnection.toString(), this.toString()}, "unmarkInProgress, size=" + this.messagesInProgress.size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInProgress(MessageImpl msg) {
        if (!this.myConnection.isDuplicateMessageDetection()) {
            return;
        }
        String messageId = ConnectionConsumerImpl.getMessageId(msg);
        boolean inProgress = false;
        do {
            Set set = this.messagesInProgress;
            synchronized (set) {
                inProgress = this.messagesInProgress.contains(messageId);
                if (MessageTracker.enabled) {
                    MessageTracker.getInstance().track(msg, new String[]{this.myConnection.toString(), this.toString()}, "isInProgress = " + inProgress);
                }
            }
            if (!inProgress) continue;
            try {
                Thread.sleep(CC_SS_DELAY);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (inProgress && !this.resetInProgress && !this.deliveryQueue.isCurrentCallInvalid());
    }

    public void processRequest(AsyncMessageDeliveryRequest request, boolean hasNext) {
        if (this.resetInProgress || this.deliveryQueue.isCurrentCallInvalid()) {
            if (MessageTracker.enabled) {
                MessageTracker.getInstance().track(request.getMessageEntry().getMessage(), new String[]{this.myConnection.toString(), this.toString()}, "processRequest, resetInProgress || currentCallInvalid, return");
            }
            return;
        }
        if (request.getConnectionId() != this.myConnection.getConnectionId()) {
            if (MessageTracker.enabled) {
                MessageTracker.getInstance().track(request.getMessageEntry().getMessage(), new String[]{this.myConnection.toString(), this.toString()}, "processRequest, invalid connectionId (" + request.getConnectionId() + " vs " + this.myConnection.getConnectionId() + ")");
            }
            return;
        }
        try {
            if (this.currentServerSession == null) {
                this.currentServerSession = this.serverSessionPool.getServerSession();
                this.currentSession = this.currentServerSession.getSession() instanceof XASessionImpl ? ((XASessionImpl)this.currentServerSession.getSession()).session : (SessionImpl)this.currentServerSession.getSession();
                this.nCurrent = 0;
                if (!this.currentSession.isShadowConsumerCreated()) {
                    this.currentSession.createShadowConsumer(this.getQueueName());
                }
                this.currentSession.setConnectionConsumer(this);
                if (this.resetInProgress || this.deliveryQueue.isCurrentCallInvalid()) {
                    if (MessageTracker.enabled) {
                        MessageTracker.getInstance().track(request.getMessageEntry().getMessage(), new String[]{this.myConnection.toString(), this.toString()}, "processRequest, resetInProgress || currentCallInvalid, return (2)");
                    }
                    return;
                }
            }
            if (MessageTracker.enabled) {
                MessageTracker.getInstance().track(request.getMessageEntry().getMessage(), new String[]{this.myConnection.toString(), this.toString()}, "processRequest, " + request.getConnectionId() + " / " + this.myConnection.getConnectionId());
            }
            MessageEntry me = request.getMessageEntry();
            this.checkInProgress(me.getMessage());
            if (this.resetInProgress || this.deliveryQueue.isCurrentCallInvalid()) {
                if (MessageTracker.enabled) {
                    MessageTracker.getInstance().track(request.getMessageEntry().getMessage(), new String[]{this.myConnection.toString(), this.toString()}, "processRequest, resetInProgress || currentCallInvalid, return (3)");
                }
                return;
            }
            me.setConnectionId(request.getConnectionId());
            this.currentSession.addMessageChunk(me);
            ++this.nCurrent;
            if (this.nCurrent == this.maxMessages || !hasNext) {
                this.currentServerSession.start();
                this.currentServerSession = null;
                this.currentSession = null;
                this.nCurrent = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (request.isRequiresRestart()) {
            this.fillCache();
        }
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.serverSessionPool;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws JMSException {
        if (this.closed) {
            return;
        }
        Reply reply = null;
        try {
            reply = this.requestRegistry.request(new CloseSessionRequest(this, 0, this.dispatchId));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        this.deliveryQueue.stopQueue();
        this.deliveryQueue.close();
        this.myConnection.removeRequestService(this.myDispatchId);
        this.myConnection.removeConnectionConsumer(this);
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
    }

    void cancel() {
        this.closed = true;
        this.deliveryQueue.stopQueue();
        this.deliveryQueue.close();
    }

    private class QueueTask
    implements AsyncTask {
        private QueueTask() {
        }

        @Override
        public boolean isValid() {
            return !ConnectionConsumerImpl.this.closed;
        }

        @Override
        public String getDispatchToken() {
            return ConnectionConsumerImpl.DISPATCH_TOKEN;
        }

        @Override
        public String getDescription() {
            return ConnectionConsumerImpl.this.myConnection.myHostname + "/ConnectionConsumer/QueueTask";
        }

        @Override
        public void run() {
            if (!ConnectionConsumerImpl.this.closed && ConnectionConsumerImpl.this.deliveryQueue.dequeue()) {
                ConnectionConsumerImpl.this.sessionPool.dispatchTask(this);
            }
        }

        @Override
        public void stop() {
        }
    }

    private class DeliveryQueue
    extends SingleProcessorQueue {
        boolean currentCallInvalid;

        public DeliveryQueue() {
            super(ConnectionConsumerImpl.this.myConnection.smqpConsumerCacheSize);
            this.currentCallInvalid = false;
        }

        public boolean isCurrentCallInvalid() {
            return this.currentCallInvalid;
        }

        public void setCurrentCallInvalid(boolean currentCallInvalid) {
            this.currentCallInvalid = currentCallInvalid;
        }

        @Override
        protected void startProcessor() {
            if (!ConnectionConsumerImpl.this.closed) {
                ConnectionConsumerImpl.this.sessionPool.dispatchTask(ConnectionConsumerImpl.this.queueTask);
            }
        }

        private boolean valid() {
            return !ConnectionConsumerImpl.this.resetInProgress && this.isStarted();
        }

        @Override
        protected void process(Object[] bulk, int n) {
            if (this.currentCallInvalid) {
                this.currentCallInvalid = false;
            }
            for (int i = 0; i < n; ++i) {
                ConnectionConsumerImpl.this.processRequest((AsyncMessageDeliveryRequest)bulk[i], i + 1 < n);
                if (this.valid() && !this.currentCallInvalid) continue;
                return;
            }
        }
    }
}

