/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v630;

import com.swiftmq.util.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;

public class ConnectionMetaDataImpl
implements ConnectionMetaData,
Enumeration {
    static final String[] jmsxEnum = new String[]{"JMSXDeliveryCount", "JMSXGroupID", "JMSXGroupSeq", "JMSXUserID"};
    int enumPos = 0;
    String jmsVersion = null;
    int jmsMajorVersion = 0;
    int jmsMinorVersion = 0;
    String jmsProviderName = null;
    String jmsProviderVersion = null;
    int jmsProviderMajorVersion = 0;
    int jmsProviderMinorVersion = 0;
    String routerName = null;

    public ConnectionMetaDataImpl(String jmsVersion, int jmsMajorVersion, int jmsMinorVersion, String jmsProviderName, String jmsProviderVersion, int jmsProviderMajorVersion, int jmsProviderMinorVersion, String routerName) {
        this.jmsVersion = jmsVersion;
        this.jmsMajorVersion = jmsMajorVersion;
        this.jmsMinorVersion = jmsMinorVersion;
        this.jmsProviderName = jmsProviderName;
        this.jmsProviderVersion = jmsProviderVersion;
        this.jmsProviderMajorVersion = jmsProviderMajorVersion;
        this.jmsProviderMinorVersion = jmsProviderMinorVersion;
        this.routerName = routerName;
    }

    public ConnectionMetaDataImpl(String routerName) {
        this("1.1", 1, 1, "SwiftMQ", Version.getKernelVersion(), Version.getSwiftmqMajorVersion(), Version.getSwiftmqMinorVersion(), routerName);
    }

    public ConnectionMetaDataImpl() {
    }

    public void writeContent(DataOutput out) throws IOException {
        if (this.jmsVersion == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(this.jmsVersion);
        }
        out.writeInt(this.jmsMajorVersion);
        out.writeInt(this.jmsMinorVersion);
        if (this.jmsProviderName == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(this.jmsProviderName);
        }
        if (this.jmsProviderVersion == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(this.jmsProviderVersion);
        }
        out.writeInt(this.jmsProviderMajorVersion);
        out.writeInt(this.jmsProviderMinorVersion);
        if (this.routerName == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(this.routerName);
        }
    }

    public void readContent(DataInput in) throws IOException {
        byte set = in.readByte();
        this.jmsVersion = set == 0 ? null : in.readUTF();
        this.jmsMajorVersion = in.readInt();
        this.jmsMinorVersion = in.readInt();
        set = in.readByte();
        this.jmsProviderName = set == 0 ? null : in.readUTF();
        set = in.readByte();
        this.jmsProviderVersion = set == 0 ? null : in.readUTF();
        this.jmsProviderMajorVersion = in.readInt();
        this.jmsProviderMinorVersion = in.readInt();
        set = in.readByte();
        this.routerName = set == 0 ? null : in.readUTF();
    }

    public String getJMSVersion() throws JMSException {
        return this.jmsVersion;
    }

    public int getJMSMajorVersion() throws JMSException {
        return this.jmsMajorVersion;
    }

    public int getJMSMinorVersion() throws JMSException {
        return this.jmsMinorVersion;
    }

    public String getJMSProviderName() throws JMSException {
        return this.jmsProviderName;
    }

    public String getProviderVersion() throws JMSException {
        return this.jmsProviderVersion;
    }

    public int getProviderMajorVersion() throws JMSException {
        return this.jmsProviderMajorVersion;
    }

    public int getProviderMinorVersion() throws JMSException {
        return this.jmsProviderMinorVersion;
    }

    public String getRouterName() {
        return this.routerName;
    }

    public Enumeration getJMSXPropertyNames() throws JMSException {
        this.enumPos = 0;
        return this;
    }

    @Override
    public boolean hasMoreElements() {
        return this.enumPos < jmsxEnum.length;
    }

    public Object nextElement() throws NoSuchElementException {
        if (this.enumPos >= jmsxEnum.length) {
            throw new NoSuchElementException("no more elements found");
        }
        return jmsxEnum[this.enumPos++];
    }

    public String toString() {
        return "[ConnectionMetaDataImpl JMSVersion=" + this.jmsVersion + " JMSMajorVersion=" + this.jmsMajorVersion + " JMSMinorVersion=" + this.jmsMinorVersion + " JMSProviderName=" + this.jmsProviderName + " JMSProviderVersion=" + this.jmsProviderVersion + " JMSProviderMajorVersion=" + this.jmsProviderMajorVersion + " JMSProviderMinorVersion=" + this.jmsProviderMinorVersion + " routerName=" + this.routerName + "]";
    }
}

