/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v630;

import com.swiftmq.jms.ExceptionConverter;
import com.swiftmq.jms.QueueImpl;
import com.swiftmq.jms.smqp.v630.CloseBrowserRequest;
import com.swiftmq.jms.smqp.v630.CreateBrowserReply;
import com.swiftmq.jms.smqp.v630.CreateBrowserRequest;
import com.swiftmq.jms.smqp.v630.FetchBrowserMessageReply;
import com.swiftmq.jms.smqp.v630.FetchBrowserMessageRequest;
import com.swiftmq.jms.v630.Recreatable;
import com.swiftmq.jms.v630.SessionImpl;
import com.swiftmq.swiftlet.queue.MessageIndex;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRegistry;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.ValidationException;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class QueueBrowserImpl
implements QueueBrowser,
Enumeration,
Recreatable,
RequestRetryValidator {
    boolean closed = false;
    Queue queue = null;
    String messageSelector = null;
    int dispatchId = -1;
    int browserDispatchId = -1;
    RequestRegistry requestRegistry = null;
    Message lastMessage = null;
    MessageIndex lastMessageIndex = null;
    SessionImpl mySession = null;
    boolean resetRequired = false;

    public QueueBrowserImpl(SessionImpl mySession, Queue queue, String messageSelector, int dispatchId, int browserDispatchId, RequestRegistry requestRegistry) {
        this.mySession = mySession;
        this.queue = queue;
        this.messageSelector = messageSelector;
        this.dispatchId = dispatchId;
        this.browserDispatchId = browserDispatchId;
        this.requestRegistry = requestRegistry;
    }

    @Override
    public Request getRecreateRequest() {
        return new CreateBrowserRequest(this.mySession, this.mySession.dispatchId, (QueueImpl)this.queue, this.messageSelector);
    }

    @Override
    public void setRecreateReply(Reply reply) {
        CreateBrowserReply r = (CreateBrowserReply)reply;
        this.dispatchId = this.mySession.dispatchId;
        this.browserDispatchId = r.getQueueBrowserId();
    }

    @Override
    public List getRecreatables() {
        return null;
    }

    @Override
    public void validate(Request request) throws ValidationException {
        request.setDispatchId(this.dispatchId);
        if (request instanceof CloseBrowserRequest) {
            CloseBrowserRequest r = (CloseBrowserRequest)request;
            r.setQueueBrowserId(this.browserDispatchId);
        } else if (request instanceof FetchBrowserMessageRequest) {
            FetchBrowserMessageRequest r = (FetchBrowserMessageRequest)request;
            r.setQueueBrowserId(this.browserDispatchId);
        }
    }

    protected void verifyState() throws JMSException {
        if (this.closed) {
            throw new JMSException("Queue browser is closed");
        }
        this.mySession.verifyState();
    }

    public Queue getQueue() throws JMSException {
        this.verifyState();
        return this.queue;
    }

    public String getMessageSelector() throws JMSException {
        this.verifyState();
        return this.messageSelector;
    }

    public Enumeration getEnumeration() throws JMSException {
        this.verifyState();
        this.resetRequired = true;
        this.lastMessage = null;
        return this;
    }

    public void close() throws JMSException {
        this.verifyState();
        this.closed = true;
        Reply reply = null;
        try {
            reply = this.requestRegistry.request(new CloseBrowserRequest(this, this.dispatchId, this.browserDispatchId));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        this.mySession.removeQueueBrowserImpl(this);
    }

    @Override
    public boolean hasMoreElements() {
        if (this.closed) {
            return false;
        }
        if (this.lastMessage == null) {
            Reply reply = null;
            try {
                reply = (FetchBrowserMessageReply)this.requestRegistry.request(new FetchBrowserMessageRequest(this, this.dispatchId, this.browserDispatchId, this.resetRequired, this.lastMessageIndex));
                this.resetRequired = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (reply.isOk() && ((FetchBrowserMessageReply)reply).getMessageEntry() != null) {
                this.lastMessage = ((FetchBrowserMessageReply)reply).getMessageEntry().getMessage();
                this.lastMessageIndex = ((FetchBrowserMessageReply)reply).getMessageEntry().getMessageIndex();
            }
        }
        return this.lastMessage != null;
    }

    public Object nextElement() throws NoSuchElementException {
        if (this.closed || this.lastMessage == null) {
            throw new NoSuchElementException();
        }
        Message msg = this.lastMessage;
        this.lastMessage = null;
        return msg;
    }
}

