/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v630;

import com.swiftmq.jms.ExceptionConverter;
import com.swiftmq.jms.QueueImpl;
import com.swiftmq.jms.smqp.v630.CreateConsumerRequest;
import com.swiftmq.jms.smqp.v630.CreateSessionReply;
import com.swiftmq.jms.smqp.v630.CreateSessionRequest;
import com.swiftmq.jms.v630.ConnectionConsumerImpl;
import com.swiftmq.jms.v630.ConnectionImpl;
import com.swiftmq.jms.v630.Recreatable;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.ServerSessionPool;

public class QueueConnectionConsumerImpl
extends ConnectionConsumerImpl
implements Recreatable {
    String queueName = null;
    Queue queue = null;
    String messageSelector = null;

    public QueueConnectionConsumerImpl(ConnectionImpl myConnection, int dispatchId, RequestRegistry requestRegistry, ServerSessionPool serverSessionPool, int maxMessages) {
        super(myConnection, dispatchId, requestRegistry, serverSessionPool, maxMessages);
    }

    @Override
    public Request getRecreateRequest() {
        return null;
    }

    @Override
    public void setRecreateReply(Reply reply) {
    }

    @Override
    public List getRecreatables() {
        ArrayList<Recreatable> list = new ArrayList<Recreatable>();
        list.add(new SessionRecreator());
        list.add(new ConsumerRecreator());
        return list;
    }

    void createConsumer(QueueImpl queue, String messageSelector) throws JMSException {
        if (queue == null) {
            throw new NullPointerException("createConsumer, queue is null!");
        }
        this.queueName = queue.getQueueName();
        this.queue = queue;
        this.messageSelector = messageSelector;
        Reply reply = null;
        try {
            reply = this.requestRegistry.request(new CreateConsumerRequest(this, this.dispatchId, queue, messageSelector));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        this.fillCache();
    }

    @Override
    protected String getQueueName() {
        return this.queueName;
    }

    private class ConsumerRecreator
    implements Recreatable {
        private ConsumerRecreator() {
        }

        @Override
        public Request getRecreateRequest() {
            return new CreateConsumerRequest(QueueConnectionConsumerImpl.this, QueueConnectionConsumerImpl.this.dispatchId, (QueueImpl)QueueConnectionConsumerImpl.this.queue, QueueConnectionConsumerImpl.this.messageSelector);
        }

        @Override
        public void setRecreateReply(Reply reply) {
        }

        @Override
        public List getRecreatables() {
            return null;
        }
    }

    private class SessionRecreator
    implements Recreatable {
        private SessionRecreator() {
        }

        @Override
        public Request getRecreateRequest() {
            return new CreateSessionRequest(QueueConnectionConsumerImpl.this, 0, false, 0, 0, 0);
        }

        @Override
        public void setRecreateReply(Reply reply) {
            CreateSessionReply r = (CreateSessionReply)reply;
            QueueConnectionConsumerImpl.this.dispatchId = r.getSessionDispatchId();
        }

        @Override
        public List getRecreatables() {
            return null;
        }
    }
}

