/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jndi;

import com.swiftmq.jndi.ReconnectContext;
import com.swiftmq.jndi.v400.ContextImpl;
import com.swiftmq.jndi.v400.JNDIInfo;
import com.swiftmq.jndi.v400.URLParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class InitialContextFactoryImpl
implements InitialContextFactory,
Serializable {
    public static final String RECONNECT = "swiftmq.jndi.reconnect";
    public static final String RECONNECT_DEBUG = "swiftmq.jndi.reconnect.debug";
    public static final String MAX_RETRIES = "swiftmq.jndi.reconnect.max.retries";
    public static final String RETRY_DELAY = "swiftmq.jndi.reconnect.retry.delay";

    public Context getInitialContext(Hashtable env) throws NamingException {
        String s = (String)env.get(RECONNECT);
        if (s != null && Boolean.valueOf(s).booleanValue()) {
            int maxRetries = 5;
            long retryDelay = 2000L;
            s = (String)env.get(MAX_RETRIES);
            if (s != null) {
                maxRetries = Integer.parseInt(s);
            }
            if ((s = (String)env.get(RETRY_DELAY)) != null) {
                retryDelay = Long.parseLong(s);
            }
            ArrayList envList = new ArrayList();
            Hashtable ht = new Hashtable();
            ht.put("java.naming.provider.url", env.get("java.naming.provider.url"));
            ht.put("java.naming.factory.initial", env.get("java.naming.factory.initial"));
            envList.add(ht);
            int i = 2;
            boolean found = true;
            while (found) {
                s = (String)env.get("java.naming.provider.url_" + i);
                if (s == null) {
                    found = false;
                    continue;
                }
                ht = new Hashtable();
                ht.put("java.naming.provider.url", s);
                ht.put("java.naming.factory.initial", env.get("java.naming.factory.initial"));
                envList.add(ht);
                ++i;
            }
            ReconnectContext rc = new ReconnectContext(envList, maxRetries, retryDelay);
            s = (String)env.get(RECONNECT_DEBUG);
            rc.setDebug(s != null && Boolean.valueOf(s) != false);
            return rc;
        }
        JNDIInfo jndiInfo = URLParser.parseURL((String)env.get("java.naming.provider.url"));
        if (jndiInfo.isReconnect()) {
            ArrayList envList = new ArrayList();
            Hashtable<String, String> env1 = new Hashtable<String, String>();
            env1.put("java.naming.provider.url", jndiInfo.getProviderURL(jndiInfo.getHostname(), jndiInfo.getPort()));
            env1.put("java.naming.factory.initial", (String)env.get("java.naming.factory.initial"));
            envList.add(env1);
            if (jndiInfo.getHostname2() != null) {
                Hashtable<String, String> env2 = new Hashtable<String, String>();
                env2.put("java.naming.provider.url", jndiInfo.getProviderURL(jndiInfo.getHostname2(), jndiInfo.getPort2()));
                env2.put("java.naming.factory.initial", (String)env.get("java.naming.factory.initial"));
                envList.add(env2);
            }
            ReconnectContext rc = new ReconnectContext(envList, jndiInfo.getMaxRetries(), jndiInfo.getReconnectDelay());
            rc.setDebug(jndiInfo.isDebug());
            return rc;
        }
        return new ContextImpl(env);
    }
}

