/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jndi;

import com.swiftmq.jms.SwiftMQConnectionFactory;
import com.swiftmq.jndi.InitialContextFactoryImpl;
import com.swiftmq.jndi.StopRetryException;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class ReconnectContext
implements Context {
    List envList = null;
    int maxRetries = 0;
    long retryDelay = 0L;
    Context current = null;
    int currentPos = -1;
    boolean closed = false;
    boolean debug = false;
    String connectURL = null;

    public ReconnectContext(List envList, int maxRetries, long retryDelay) {
        this.envList = envList;
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
        new SwiftMQConnectionFactory();
        if (this.debug) {
            System.out.println(new Date() + " " + this.toString() + "/created: envList=" + envList + ", maxRetries=" + maxRetries + ", retryDelay=" + retryDelay);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() throws CommunicationException {
        if (this.debug) {
            System.out.println(new Date() + " " + this.toString() + "/reconnect, current=" + this.current);
        }
        int retries = this.maxRetries;
        do {
            if (this.debug) {
                System.out.println(new Date() + " " + this.toString() + "/reconnect, current=" + this.current + ", retries=" + retries);
            }
            if (retries < this.maxRetries && this.retryDelay > 0L) {
                try {
                    if (this.debug) {
                        System.out.println(new Date() + " " + this.toString() + "/reconnect, current=" + this.current + ", waiting " + this.retryDelay);
                    }
                    ReconnectContext reconnectContext = this;
                    synchronized (reconnectContext) {
                        this.wait(this.retryDelay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.debug) {
                    System.out.println(new Date() + " " + this.toString() + "/reconnect, current=" + this.current + ", continue...");
                }
                if (this.closed) {
                    return;
                }
            }
            if (this.current != null) {
                try {
                    if (this.debug) {
                        System.out.println(new Date() + " " + this.toString() + "/reconnect, current=" + this.current + ", closing old one");
                    }
                    this.current.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.current = null;
            }
            if (this.currentPos == this.envList.size() - 1) {
                this.currentPos = -1;
            }
            ++this.currentPos;
            try {
                if (this.debug) {
                    System.out.println(new Date() + " " + this.toString() + "/reconnect, current=" + this.current + ", trying: " + this.envList.get(this.currentPos));
                }
                this.current = new InitialContextFactoryImpl().getInitialContext((Hashtable)this.envList.get(this.currentPos));
                if (this.current != null) {
                    this.connectURL = (String)((Hashtable)this.envList.get(this.currentPos)).get("java.naming.provider.url");
                }
                if (!this.debug) continue;
                System.out.println(new Date() + " " + this.toString() + "/reconnect, connectURL=" + this.connectURL);
            }
            catch (Exception e) {
                if (!(e instanceof StopRetryException)) continue;
                throw new CommunicationException(e.getMessage());
            }
        } while (--retries > 0 && this.current == null);
        if (this.current == null) {
            throw new CommunicationException("Unable to connect, maximum retries (" + this.maxRetries + ") reached, giving up!");
        }
        if (this.debug) {
            System.out.println(new Date() + " " + this.toString() + "/reconnect done, current=" + this.current);
        }
    }

    private Object runWrapped(Delegation delegation, Object[] parameters) throws NamingException {
        if (this.debug) {
            System.out.println(new Date() + " " + this.toString() + "/runWrapped, current=" + this.current);
        }
        Object obj = null;
        do {
            if (this.current == null) {
                this.reconnect();
            }
            if (this.current == null) continue;
            try {
                if (this.debug) {
                    System.out.println(new Date() + " " + this.toString() + "/runWrapped, execute...");
                }
                obj = delegation.execute(parameters);
                if (!this.debug) continue;
                System.out.println(new Date() + " " + this.toString() + "/runWrapped, execute done, result=" + obj);
            }
            catch (CommunicationException e) {
                if (this.debug) {
                    System.out.println(new Date() + " " + this.toString() + "/runWrapped, CommunicationException=" + e);
                }
                this.current = null;
            }
            catch (NamingException e1) {
                if (!this.debug) continue;
                System.out.println(new Date() + " " + this.toString() + "/runWrapped, NamingException=" + e1);
            }
        } while (!this.closed && this.current == null);
        if (this.debug) {
            System.out.println(new Date() + " " + this.toString() + "/runWrapped, returning=" + obj);
        }
        return obj;
    }

    public synchronized String getConnectURL() {
        return this.connectURL;
    }

    @Override
    public synchronized Object lookup(Name name) throws NamingException {
        return this.lookup(name.get(0));
    }

    @Override
    public synchronized Object lookup(String name) throws NamingException {
        return this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.lookup((String)parameter[0]);
            }
        }, new Object[]{name});
    }

    @Override
    public synchronized void bind(Name name, Object obj) throws NamingException {
        this.bind(name.get(0), obj);
    }

    @Override
    public synchronized void bind(String name, Object obj) throws NamingException {
        this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                ReconnectContext.this.current.bind((String)parameter[0], parameter[1]);
                return null;
            }
        }, new Object[]{name, obj});
    }

    @Override
    public synchronized void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.get(0), obj);
    }

    @Override
    public synchronized void rebind(String name, Object obj) throws NamingException {
        this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                ReconnectContext.this.current.rebind((String)parameter[0], parameter[1]);
                return null;
            }
        }, new Object[]{name, obj});
    }

    @Override
    public synchronized void unbind(Name name) throws NamingException {
        this.unbind(name.get(0));
    }

    @Override
    public synchronized void unbind(String name) throws NamingException {
        this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                ReconnectContext.this.current.unbind((String)parameter[0]);
                return null;
            }
        }, new Object[]{name});
    }

    @Override
    public synchronized void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.get(0), newName.get(0));
    }

    @Override
    public synchronized void rename(String oldName, String newName) throws NamingException {
        this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                ReconnectContext.this.current.rename((String)parameter[0], (String)parameter[1]);
                return null;
            }
        }, new Object[]{oldName, newName});
    }

    public synchronized NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.get(0));
    }

    public synchronized NamingEnumeration list(String name) throws NamingException {
        return (NamingEnumeration)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.list((String)parameter[0]);
            }
        }, new Object[]{name});
    }

    public synchronized NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.get(0));
    }

    public synchronized NamingEnumeration listBindings(String name) throws NamingException {
        return (NamingEnumeration)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.listBindings((String)parameter[0]);
            }
        }, new Object[]{name});
    }

    @Override
    public synchronized void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.get(0));
    }

    @Override
    public synchronized void destroySubcontext(String name) throws NamingException {
        this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                ReconnectContext.this.current.destroySubcontext((String)parameter[0]);
                return null;
            }
        }, new Object[]{name});
    }

    @Override
    public synchronized Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.get(0));
    }

    @Override
    public synchronized Context createSubcontext(String name) throws NamingException {
        return (Context)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.createSubcontext((String)parameter[0]);
            }
        }, new Object[]{name});
    }

    @Override
    public synchronized Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.get(0));
    }

    @Override
    public synchronized Object lookupLink(String name) throws NamingException {
        return this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.lookupLink((String)parameter[0]);
            }
        }, new Object[]{name});
    }

    @Override
    public synchronized NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.get(0));
    }

    @Override
    public synchronized NameParser getNameParser(String name) throws NamingException {
        return (NameParser)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.getNameParser((String)parameter[0]);
            }
        }, new Object[]{name});
    }

    @Override
    public synchronized Name composeName(Name name, Name prefix) throws NamingException {
        return (Name)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.composeName((Name)parameter[0], (Name)parameter[1]);
            }
        }, new Object[]{name, prefix});
    }

    @Override
    public synchronized String composeName(String name, String prefix) throws NamingException {
        return (String)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.composeName((String)parameter[0], (String)parameter[1]);
            }
        }, new Object[]{name, prefix});
    }

    @Override
    public synchronized Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.addToEnvironment((String)parameter[0], (String)parameter[1]);
            }
        }, new Object[]{propName, propVal});
    }

    @Override
    public synchronized Object removeFromEnvironment(String propName) throws NamingException {
        return this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.removeFromEnvironment((String)parameter[0]);
            }
        }, new Object[]{propName});
    }

    public synchronized Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.getEnvironment();
            }
        }, null);
    }

    @Override
    public synchronized String getNameInNamespace() throws NamingException {
        return (String)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.getNameInNamespace();
            }
        }, null);
    }

    @Override
    public synchronized void close() throws NamingException {
        this.closed = true;
        if (this.current != null) {
            this.current.close();
        }
        this.current = null;
        this.notify();
    }

    public String toString() {
        return "[ReconnectContext, closed=" + this.closed + "]";
    }

    private static interface Delegation {
        public Object execute(Object[] var1) throws NamingException;
    }
}

