/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jndi.protocol.v400;

import com.swiftmq.jms.DestinationFactory;
import com.swiftmq.jms.QueueImpl;
import com.swiftmq.jndi.protocol.v400.JNDIRequest;
import com.swiftmq.jndi.protocol.v400.JNDIRequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RebindRequest
implements JNDIRequest {
    String name;
    QueueImpl queue;

    public RebindRequest(String name, QueueImpl queue) {
        this.name = name;
        this.queue = queue;
    }

    public RebindRequest() {
    }

    @Override
    public int getDumpId() {
        return 2;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        DestinationFactory.dumpDestination(this.queue, out);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.queue = (QueueImpl)DestinationFactory.createDestination(in);
    }

    public String getName() {
        return this.name;
    }

    public QueueImpl getQueue() {
        return this.queue;
    }

    @Override
    public void accept(JNDIRequestVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "[RebindRequest, name=" + this.name + ", queue=" + this.queue + "]";
    }
}

