/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jndi.v400;

import com.swiftmq.client.Versions;
import com.swiftmq.jms.BytesMessageImpl;
import com.swiftmq.jms.InvalidVersionException;
import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.ObjectMessageImpl;
import com.swiftmq.jms.QueueImpl;
import com.swiftmq.jms.SwiftMQConnectionFactory;
import com.swiftmq.jms.SwiftMQMessageConsumer;
import com.swiftmq.jms.TemporaryQueueImpl;
import com.swiftmq.jms.TemporaryTopicImpl;
import com.swiftmq.jndi.StopRetryException;
import com.swiftmq.jndi.protocol.v400.BindRequest;
import com.swiftmq.jndi.protocol.v400.JNDIRequest;
import com.swiftmq.jndi.protocol.v400.LookupRequest;
import com.swiftmq.jndi.protocol.v400.RebindRequest;
import com.swiftmq.jndi.protocol.v400.UnbindRequest;
import com.swiftmq.jndi.v400.JNDIInfo;
import com.swiftmq.jndi.v400.URLParser;
import com.swiftmq.tools.dump.Dumpalizer;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import com.swiftmq.tools.versioning.Versionable;
import com.swiftmq.tools.versioning.Versioned;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class ContextImpl
implements Context,
Serializable {
    Hashtable env = null;
    JNDIInfo jndiInfo = null;
    Connection connection = null;
    Session session = null;
    MessageProducer producer = null;
    boolean closed = true;

    public ContextImpl(Hashtable env) throws NamingException {
        this.env = env;
        String url = (String)env.get("java.naming.provider.url");
        if (url == null) {
            throw new NamingException("missing JNDI environment property: Context.PROVIDER_URL (java.naming.provider.url)");
        }
        this.jndiInfo = URLParser.parseURL(url);
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.jndiInfo.isIntraVM()) {
            try {
                props.put("intravm", "true");
            }
            catch (Exception e) {
                throw new NamingException("unable to connect, exception = " + e);
            }
        }
        String factoryClass = this.jndiInfo.getFactory();
        try {
            Class.forName(factoryClass);
        }
        catch (Exception e) {
            throw new NamingException("socket factory not found: " + factoryClass);
        }
        try {
            props.put("socketfactory", factoryClass);
            props.put("hostname", this.jndiInfo.getHostname());
            props.put("port", String.valueOf(this.jndiInfo.getPort()));
            props.put("keepaliveinterval", String.valueOf(this.jndiInfo.getKeepalive()));
        }
        catch (Exception e) {
            throw new NamingException("unable to connect, exception = " + e);
        }
        try {
            ConnectionFactory cf = SwiftMQConnectionFactory.create(props);
            this.connection = cf.createConnection(this.jndiInfo.getUsername(), this.jndiInfo.getPassword());
            this.session = this.connection.createSession(false, 0);
            this.producer = this.session.createProducer(null);
            this.connection.start();
            this.closed = false;
        }
        catch (Exception e) {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.closed = true;
            if (e instanceof JMSSecurityException || e instanceof InvalidVersionException) {
                throw new StopRetryException(e.getMessage());
            }
            throw new NamingException("unable to connect, exception = " + e);
        }
    }

    @Override
    public Object addToEnvironment(String name, Object value) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    private Versioned createVersioned(int version, JNDIRequest request) throws Exception {
        DataByteArrayOutputStream dos = new DataByteArrayOutputStream();
        Dumpalizer.dump(dos, request);
        return new Versioned(version, dos.getBuffer(), dos.getCount());
    }

    private BytesMessageImpl createMessage(Versionable versionable, Destination replyTo) throws Exception {
        BytesMessageImpl msg = new BytesMessageImpl();
        versionable.transferToMessage(msg);
        if (replyTo != null) {
            msg.setJMSReplyTo(replyTo);
        }
        return msg;
    }

    @Override
    public synchronized void bind(String name, Object obj) throws NamingException {
        if (this.closed) {
            throw new NamingException("context is closed!");
        }
        if (!(obj instanceof TemporaryTopicImpl) && !(obj instanceof TemporaryQueueImpl)) {
            throw new OperationNotSupportedException("bind is only supported for TemporaryQueues/TemporaryTopics!");
        }
        try {
            TemporaryTopic tt = this.session.createTemporaryTopic();
            MessageConsumer consumer = this.session.createConsumer((Destination)tt);
            Versionable versionable = new Versionable();
            versionable.addVersioned(400, this.createVersioned(400, new BindRequest(name, (QueueImpl)obj)), "com.swiftmq.jndi.protocol.v400.JNDIRequestFactory");
            BytesMessageImpl request = this.createMessage(versionable, (Destination)tt);
            this.producer.send((Destination)this.session.createTopic("swiftmq.jndi"), (Message)request, 1, 9, 0L);
            TextMessage reply = (TextMessage)consumer.receive();
            String text = reply.getText();
            consumer.close();
            tt.delete();
            if (text != null) {
                throw new Exception(text);
            }
        }
        catch (Exception e) {
            throw new NamingException("exception occurred during bind: " + e);
        }
    }

    @Override
    public void bind(Name p0, Object p1) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public synchronized void close() throws NamingException {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
    }

    @Override
    public String composeName(String p0, String p1) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public Name composeName(Name p0, Name p1) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public Context createSubcontext(String p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public Context createSubcontext(Name p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public void destroySubcontext(String p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public void destroySubcontext(Name p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public NameParser getNameParser(String p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public NameParser getNameParser(Name p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    public NamingEnumeration list(String p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    public NamingEnumeration list(Name p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    public NamingEnumeration listBindings(String p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    public NamingEnumeration listBindings(Name p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    private Destination getLookupDestination(Session session) throws JMSException {
        if (Versions.JMS_CURRENT < 630) {
            return session.createTopic("swiftmq.jndi");
        }
        return session.createQueue("sys$jndi");
    }

    @Override
    public synchronized Object lookup(String name) throws NamingException {
        if (this.closed) {
            throw new NamingException("context is closed!");
        }
        if (name == null) {
            throw new OperationNotSupportedException("context cloning is not supported!");
        }
        boolean connectionClosed = false;
        Object obj = null;
        try {
            TemporaryQueue tq = this.session.createTemporaryQueue();
            MessageConsumer consumer = this.session.createConsumer((Destination)tq);
            Versionable versionable = new Versionable();
            versionable.addVersioned(400, this.createVersioned(400, new LookupRequest(name)), "com.swiftmq.jndi.protocol.v400.JNDIRequestFactory");
            BytesMessageImpl request = this.createMessage(versionable, (Destination)tq);
            this.producer.send(this.getLookupDestination(this.session), (Message)request, 1, 9, 0L);
            MessageImpl reply = null;
            reply = this.jndiInfo.getTimeout() == 0L ? (MessageImpl)consumer.receive() : (MessageImpl)consumer.receive(this.jndiInfo.getTimeout());
            if (reply != null) {
                if (reply instanceof ObjectMessageImpl) {
                    obj = ((ObjectMessageImpl)reply).getObject();
                } else {
                    BytesMessageImpl msg = (BytesMessageImpl)reply;
                    Versionable vreply = Versionable.toVersionable(msg);
                    vreply.selectVersions(Versions.cutAfterIndex(Versions.getSelectedIndex(Versions.JMS_CURRENT, Versions.JMS), Versions.JMS));
                    obj = vreply.createVersionedObject();
                }
            }
            if (!((SwiftMQMessageConsumer)consumer).isClosed()) {
                consumer.close();
                tq.delete();
            } else {
                connectionClosed = true;
            }
        }
        catch (Exception e) {
            throw new CommunicationException("exception occurred during lookup: " + e);
        }
        if (connectionClosed) {
            throw new CommunicationException("Connection lost!");
        }
        if (obj == null) {
            throw new NameNotFoundException("Name '" + name + "' not found (timeout occured)!");
        }
        return obj;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.get(0));
    }

    @Override
    public Object lookupLink(String p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public Object lookupLink(Name p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public synchronized void rebind(String name, Object obj) throws NamingException {
        if (this.closed) {
            throw new NamingException("context is closed!");
        }
        if (!(obj instanceof TemporaryTopicImpl) && !(obj instanceof TemporaryQueueImpl)) {
            throw new OperationNotSupportedException("rebind is only supported for TemporaryQueues/TemporaryTopics!");
        }
        try {
            TemporaryTopic tt = this.session.createTemporaryTopic();
            MessageConsumer consumer = this.session.createConsumer((Destination)tt);
            Versionable versionable = new Versionable();
            versionable.addVersioned(400, this.createVersioned(400, new RebindRequest(name, (QueueImpl)obj)), "com.swiftmq.jndi.protocol.v400.JNDIRequestFactory");
            BytesMessageImpl request = this.createMessage(versionable, (Destination)tt);
            this.producer.send((Destination)this.session.createTopic("swiftmq.jndi"), (Message)request, 1, 9, 0L);
            TextMessage reply = (TextMessage)consumer.receive();
            String text = reply.getText();
            consumer.close();
            tt.delete();
            if (text != null) {
                throw new Exception(text);
            }
        }
        catch (Exception e) {
            throw new NamingException("exception occurred during rebind: " + e);
        }
    }

    @Override
    public void rebind(Name p0, Object p1) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public Object removeFromEnvironment(String p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public void rename(String p0, String p1) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public void rename(Name p0, Name p1) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public synchronized void unbind(String name) throws NamingException {
        if (this.closed) {
            throw new NamingException("context is closed!");
        }
        try {
            Versionable versionable = new Versionable();
            versionable.addVersioned(400, this.createVersioned(400, new UnbindRequest(name)), "com.swiftmq.jndi.protocol.v400.JNDIRequestFactory");
            BytesMessageImpl request = this.createMessage(versionable, null);
            this.producer.send((Destination)this.session.createTopic("swiftmq.jndi"), (Message)request, 1, 9, 0L);
        }
        catch (Exception e) {
            throw new NamingException("exception occurred during unbind: " + e);
        }
    }

    @Override
    public void unbind(Name p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

