/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jndi.v400;

import com.swiftmq.jndi.v400.JNDIInfo;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.naming.NamingException;

public class URLParser
implements Serializable {
    private static final String DEFAULT_FACTORY = "com.swiftmq.net.PlainSocketFactory";
    private static final String INTRAVM = "intravm";
    private static final long DEFAULT_TIMEOUT = 0L;
    private static final long DEFAULT_KEEPALIVE = 60000L;

    private static String[] getPars(String url) {
        StringTokenizer t = new StringTokenizer(url, ";");
        String[] pars = new String[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            pars[i++] = t.nextToken();
        }
        return pars;
    }

    private static String getName(String par) throws NamingException {
        int idx = par.indexOf(61);
        if (idx == -1) {
            throw new NamingException("missing '=', parameter = " + par);
        }
        return par.substring(0, idx).trim();
    }

    private static String getValue(String par) throws NamingException {
        int idx = par.indexOf(61);
        if (idx == -1) {
            throw new NamingException("missing '=', parameter = " + par);
        }
        return par.substring(idx + 1).trim();
    }

    public static JNDIInfo parseURL(String ref) throws NamingException {
        JNDIInfo jndiInfo = null;
        if (!ref.startsWith("smqp://")) {
            throw new NamingException("invalid URL: protocol != smqp, URL=" + ref);
        }
        String s = ref.substring(7);
        String username = null;
        String password = null;
        if (s.indexOf(64) != -1) {
            String up = s.substring(0, s.indexOf(64));
            if (up.indexOf(58) != -1) {
                username = up.substring(0, up.indexOf(58));
                password = up.substring(username.length() + 1);
            } else {
                username = up;
            }
            s = s.substring(s.indexOf(64) + 1);
        }
        String factory = DEFAULT_FACTORY;
        long timeout = 0L;
        long keepalive = 60000L;
        String hostname = null;
        String sport = null;
        int port = 0;
        boolean reconnect = false;
        long retrydelay = 0L;
        int maxretries = 0;
        String host2 = null;
        int port2 = 0;
        boolean debug = false;
        boolean hasParameters = false;
        if (s.indexOf(58) != -1) {
            hostname = s.substring(0, s.indexOf(58));
            sport = (s = s.substring(s.indexOf(58) + 1)).indexOf(47) == -1 ? s : s.substring(0, s.indexOf(47));
            try {
                port = Integer.parseInt(sport);
            }
            catch (NumberFormatException nfe) {
                throw new NamingException("invalid port number (" + sport + "), URL=" + ref);
            }
        } else {
            hostname = s.indexOf(47) == -1 ? s : s.substring(0, s.indexOf(47));
            if (!hostname.toLowerCase().equals(INTRAVM)) {
                throw new NamingException("Expected 'intravm' but got '" + hostname + "'");
            }
        }
        if (s.indexOf(47) != -1) {
            String[] pars = URLParser.getPars(s.substring(s.indexOf(47) + 1));
            hasParameters = pars.length > 0;
            for (int i = 0; i < pars.length; ++i) {
                String name = URLParser.getName(pars[i]);
                String value = URLParser.getValue(pars[i]);
                if (name.equals("type")) {
                    factory = value;
                    continue;
                }
                if (name.equals("timeout")) {
                    try {
                        timeout = Long.parseLong(value);
                        if (timeout >= 0L) continue;
                        throw new NamingException("timeout < 0: " + pars[i]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new NamingException("invalid long value: " + pars[i]);
                    }
                }
                if (name.equals("keepalive")) {
                    try {
                        keepalive = Long.parseLong(value);
                        if (keepalive >= 0L) continue;
                        throw new NamingException("keepalive < 0: " + pars[i]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new NamingException("invalid long value: " + pars[i]);
                    }
                }
                if (name.equals("reconnect")) {
                    reconnect = Boolean.valueOf(value);
                    continue;
                }
                if (name.equals("retrydelay")) {
                    try {
                        retrydelay = Long.parseLong(value);
                        if (retrydelay >= 0L) continue;
                        throw new NamingException("retrydelay < 0: " + pars[i]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new NamingException("invalid long value: " + pars[i]);
                    }
                }
                if (name.equals("maxretries")) {
                    try {
                        maxretries = Integer.parseInt(value);
                        if (maxretries >= 0) continue;
                        throw new NamingException("maxretries < 0: " + pars[i]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new NamingException("invalid long value: " + pars[i]);
                    }
                }
                if (name.equals("host2")) {
                    host2 = value == null ? hostname : value;
                    continue;
                }
                if (name.equals("port2")) {
                    try {
                        port2 = Integer.parseInt(value);
                        if (port2 >= 0) continue;
                        throw new NamingException("port2 < 0: " + pars[i]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new NamingException("invalid long value: " + pars[i]);
                    }
                }
                if (name.equals("debug")) {
                    debug = Boolean.valueOf(value);
                    continue;
                }
                throw new NamingException("invalid parameter: " + pars[i]);
            }
        }
        jndiInfo = new JNDIInfo(username, password, hostname, port, factory, timeout, keepalive, hostname.equals(INTRAVM), reconnect, retrydelay, maxretries, host2, port2, debug, hasParameters);
        return jndiInfo;
    }
}

