/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt;

import com.swiftmq.mgmt.CommandExecutor;
import com.swiftmq.mgmt.Entity;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.util.SwiftUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Command
implements Dumpable {
    boolean guiEnabled;
    boolean guiForChild;
    String name;
    String[] tokens;
    String pattern;
    String description;
    boolean enabled;
    Entity parent;
    transient CommandExecutor commandExecutor;

    public Command(String name, String pattern, String description, boolean enabled, CommandExecutor commandExecutor) {
        this(name, pattern, description, enabled, commandExecutor, false, false);
    }

    public Command(String name, String pattern, String description, boolean enabled, CommandExecutor commandExecutor, boolean guiEnabled, boolean guiForChild) {
        this.name = name;
        this.pattern = pattern;
        this.description = description;
        this.enabled = enabled;
        this.commandExecutor = commandExecutor;
        this.guiEnabled = guiEnabled;
        this.guiForChild = guiForChild;
        this.tokens = SwiftUtilities.tokenize(name, " ");
    }

    Command() {
    }

    @Override
    public int getDumpId() {
        return 7;
    }

    private void writeDump(DataOutput out, String s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(s);
        }
    }

    private String readDump(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            return in.readUTF();
        }
        return null;
    }

    @Override
    public synchronized void writeContent(DataOutput out) throws IOException {
        this.writeDump(out, this.name);
        this.writeDump(out, this.pattern);
        this.writeDump(out, this.description);
        out.writeBoolean(this.enabled);
        out.writeBoolean(this.guiEnabled);
        out.writeBoolean(this.guiForChild);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.name = this.readDump(in);
        this.pattern = this.readDump(in);
        this.description = this.readDump(in);
        this.enabled = in.readBoolean();
        this.guiEnabled = in.readBoolean();
        this.guiForChild = in.readBoolean();
        this.tokens = SwiftUtilities.tokenize(this.name, " ");
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getName() {
        return this.name;
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Entity getParent() {
        return this.parent;
    }

    protected void setParent(Entity parent) {
        this.parent = parent;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public boolean isGuiEnabled() {
        return this.guiEnabled;
    }

    public void setGuiEnabled(boolean guiEnabled) {
        this.guiEnabled = guiEnabled;
    }

    public boolean isGuiForChild() {
        return this.guiForChild;
    }

    public void setGuiForChild(boolean guiForChild) {
        this.guiForChild = guiForChild;
    }

    public boolean equals(String[] cmd) {
        if (this.tokens.length > cmd.length) {
            return false;
        }
        for (int i = 0; i < this.tokens.length; ++i) {
            if (this.tokens[i].equals(cmd[i])) continue;
            return false;
        }
        return true;
    }

    private String quote(String s) {
        return "\"" + s + "\"";
    }

    public String toJson() {
        StringBuffer s = new StringBuffer();
        s.append("{");
        s.append(this.quote("name")).append(": ");
        s.append(this.quote(this.name)).append(", ");
        s.append(this.quote("description")).append(": ");
        s.append(this.quote(this.description)).append(", ");
        s.append(this.quote("guiForChild")).append(": ");
        s.append(this.guiForChild);
        s.append("}");
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[Command, name=");
        s.append(this.name);
        s.append(", pattern=");
        s.append(this.pattern);
        s.append(", description=");
        s.append(this.description);
        s.append(", enabled=");
        s.append(this.enabled);
        s.append("]");
        return s.toString();
    }
}

