/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt;

import com.swiftmq.mgmt.Authenticator;
import com.swiftmq.mgmt.AuthenticatorHolder;
import com.swiftmq.mgmt.Command;
import com.swiftmq.mgmt.CommandExecutor;
import com.swiftmq.mgmt.Entity;
import com.swiftmq.mgmt.MgmtFactory;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.tools.dump.Dumpalizer;
import com.swiftmq.util.SwiftUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class CommandRegistry
implements Dumpable {
    String contextName = null;
    Entity myEntity = null;
    ArrayList commands = new ArrayList();
    transient CommandExecutor defaultCommand = null;

    public CommandRegistry(String name, Entity myEntity) {
        this.contextName = name;
        this.myEntity = myEntity;
        CommandExecutor helpExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] command) {
                String[] r;
                Authenticator authenticator = AuthenticatorHolder.threadLocal.get();
                ArrayList<String> al = new ArrayList<String>();
                al.add("Result:");
                al.add("Commands from " + CommandRegistry.this.contextName);
                al.add("");
                for (int i = 0; i < CommandRegistry.this.commands.size(); ++i) {
                    Command c = (Command)CommandRegistry.this.commands.get(i);
                    if (!c.isEnabled() || c.getName().equals("help") || authenticator != null && !authenticator.isCommandGranted(entity, c.getName())) continue;
                    al.addAll(CommandRegistry.this.createHelpEntry(c.getPattern(), c.getDescription()));
                }
                if (CommandRegistry.this.defaultCommand != null && (r = CommandRegistry.this.defaultCommand.execute(context, entity, command)) != null) {
                    al.add("");
                    for (int i = 0; i < r.length; ++i) {
                        al.add(r[i]);
                    }
                }
                String[] rArr = al.toArray(new String[al.size()]);
                return rArr;
            }
        };
        Command cmd = new Command("help", "help", "List all available commands", true, helpExecutor);
        this.addCommand(cmd);
    }

    CommandRegistry() {
    }

    private List createHelpEntry(String pattern, String description) {
        ArrayList<String> list = new ArrayList<String>();
        String prefix = SwiftUtilities.fillToLength(" ", 33);
        if (pattern.length() > 33) {
            list.add(pattern);
        } else {
            prefix = SwiftUtilities.fillToLength(pattern, 33);
        }
        StringTokenizer t = new StringTokenizer(description, "\n");
        while (t.hasMoreTokens()) {
            list.add(prefix + t.nextToken());
            if (pattern.length() <= 33) continue;
            prefix = SwiftUtilities.fillToLength(" ", 33);
        }
        return list;
    }

    @Override
    public int getDumpId() {
        return 6;
    }

    private void writeDump(DataOutput out, String s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(s);
        }
    }

    private String readDump(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            return in.readUTF();
        }
        return null;
    }

    @Override
    public synchronized void writeContent(DataOutput out) throws IOException {
        this.writeDump(out, this.contextName);
        if (this.myEntity != null) {
            out.writeByte(1);
            Dumpalizer.dump(out, this.myEntity);
        } else {
            out.writeByte(0);
        }
        out.writeInt(this.commands.size());
        for (int i = 0; i < this.commands.size(); ++i) {
            Dumpalizer.dump(out, (Command)this.commands.get(i));
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        MgmtFactory factory = new MgmtFactory();
        this.contextName = this.readDump(in);
        if (in.readByte() == 1) {
            this.myEntity = (Entity)Dumpalizer.construct(in, factory);
        }
        this.commands = new ArrayList();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.commands.add(Dumpalizer.construct(in, factory));
        }
    }

    public void setName(String name) {
        this.contextName = name;
    }

    public void setDefaultCommand(CommandExecutor defaultCommand) {
        this.defaultCommand = defaultCommand;
    }

    public ArrayList getCommands() {
        return this.commands;
    }

    public void addCommand(Command command) {
        if (!this.commands.contains(command)) {
            this.commands.add(command);
        }
    }

    public void removeCommand(Command command) {
        this.commands.remove(command);
    }

    public Command findCommand(String[] cmd) {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command c = (Command)this.commands.get(i);
            if (!c.equals(cmd)) continue;
            return c;
        }
        return null;
    }

    private boolean isCommonCommand(String cmd) {
        return cmd.equals("help") || cmd.equals("lc") || cmd.equals("cc") || cmd.equals("authenticate");
    }

    public String[] executeCommand(String[] context, String[] commandString) {
        Authenticator authenticator = AuthenticatorHolder.threadLocal.get();
        if (authenticator != null && !this.isCommonCommand(commandString[0]) && !authenticator.isCommandGranted(this.myEntity, commandString[0])) {
            return new String[]{"Error:", "Command execution is not granted!"};
        }
        Command c = this.findCommand(commandString);
        if (c != null && c.isEnabled()) {
            return c.getCommandExecutor().execute(context, this.myEntity, commandString);
        }
        if (this.defaultCommand != null) {
            return this.defaultCommand.execute(context, this.myEntity, commandString);
        }
        return new String[]{"Error:", "Unknown command"};
    }
}

