/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt;

import com.swiftmq.mgmt.Entity;
import com.swiftmq.mgmt.MetaData;
import com.swiftmq.mgmt.MgmtFactory;
import com.swiftmq.mgmt.Property;
import com.swiftmq.tools.dump.Dumpalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Configuration
extends Entity {
    public static final String ENV_ENTITY = ".env";
    public static final String META_ENTITY = ".metadata";
    MetaData meta = null;
    boolean extension = false;

    public Configuration(MetaData metaData) {
        super(metaData.getName(), metaData.getDisplayName(), metaData.getDescription(), null);
        try {
            this.addEntity(Configuration.createMetaEntity(metaData));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.meta = metaData;
    }

    public Configuration() {
    }

    public static Entity createMetaEntity(MetaData metaData) {
        Entity entity = new Entity(META_ENTITY, "Swiftlet Meta Data", "Describes this Swiftlet", null);
        try {
            Property prop = new Property("name");
            prop.setType(String.class);
            prop.setDisplayName("Name");
            prop.setDescription("Swiftlet Name");
            prop.setValue(metaData.getName());
            prop.setReadOnly(true);
            prop.setStorable(false);
            entity.addProperty(prop.getName(), prop);
            prop = new Property("displayname");
            prop.setType(String.class);
            prop.setDisplayName("Display Name");
            prop.setDescription("Display Name of this Swiftlet");
            prop.setValue(metaData.getDisplayName());
            prop.setReadOnly(true);
            prop.setStorable(false);
            entity.addProperty(prop.getName(), prop);
            prop = new Property("description");
            prop.setType(String.class);
            prop.setDisplayName("Description");
            prop.setDescription("Description of this Swiftlet");
            prop.setValue(metaData.getDescription());
            prop.setReadOnly(true);
            prop.setStorable(false);
            entity.addProperty(prop.getName(), prop);
            prop = new Property("vendor");
            prop.setType(String.class);
            prop.setDisplayName("Vendor");
            prop.setDescription("Vendor of this Swiftlet");
            prop.setValue(metaData.getVendor());
            prop.setReadOnly(true);
            prop.setStorable(false);
            entity.addProperty(prop.getName(), prop);
            prop = new Property("version");
            prop.setType(String.class);
            prop.setDisplayName("Version");
            prop.setDescription("Version of this Swiftlet");
            prop.setValue(metaData.getVersion());
            prop.setReadOnly(true);
            prop.setStorable(false);
            entity.addProperty(prop.getName(), prop);
            prop = new Property("class");
            prop.setType(String.class);
            prop.setDisplayName("Class");
            prop.setDescription("Class Name of this Swiftlet");
            prop.setValue(metaData.getClassName());
            prop.setReadOnly(true);
            prop.setStorable(false);
            entity.addProperty(prop.getName(), prop);
            entity.createCommands();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entity;
    }

    @Override
    public int getDumpId() {
        return 3;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.meta != null) {
            out.writeByte(1);
            Dumpalizer.dump(out, this.meta);
        } else {
            out.writeByte(0);
        }
        out.writeBoolean(this.extension);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        byte set = in.readByte();
        if (set == 1) {
            this.meta = (MetaData)Dumpalizer.construct(in, new MgmtFactory());
        }
        this.extension = in.readBoolean();
    }

    public MetaData createMetaData(Entity entity) {
        String name = null;
        String className = null;
        String displayName = null;
        String vendor = null;
        String version = null;
        String description = null;
        try {
            name = (String)entity.getProperty("name").getValue();
            className = (String)entity.getProperty("class").getValue();
            displayName = (String)entity.getProperty("displayname").getValue();
            vendor = (String)entity.getProperty("vendor").getValue();
            version = (String)entity.getProperty("version").getValue();
            description = (String)entity.getProperty("description").getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        MetaData meta = new MetaData(displayName, vendor, version, description);
        meta.setName(name);
        meta.setClassName(className);
        return meta;
    }

    public MetaData getMetaData() {
        return this.meta;
    }

    public void setMetaData(MetaData metaData) {
        try {
            this.addEntity(Configuration.createMetaEntity(metaData));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isExtension() {
        return this.extension;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }
}

