/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt;

import com.swiftmq.mgmt.Command;
import com.swiftmq.mgmt.CommandExecutor;
import com.swiftmq.mgmt.CommandRegistry;
import com.swiftmq.mgmt.EntityAddException;
import com.swiftmq.mgmt.EntityAddListener;
import com.swiftmq.mgmt.EntityList;
import com.swiftmq.mgmt.EntityRemoveException;
import com.swiftmq.mgmt.EntityRemoveListener;
import com.swiftmq.mgmt.EntityWatchListener;
import com.swiftmq.mgmt.MgmtFactory;
import com.swiftmq.mgmt.Property;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.tools.dump.DumpableFactory;
import com.swiftmq.tools.dump.Dumpalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;

public class Entity
implements Dumpable {
    public static final String SET_COMMAND = "set";
    protected DumpableFactory factory = new MgmtFactory();
    String name = null;
    String displayName = null;
    String description = null;
    boolean dynamic = false;
    transient Object userObject = null;
    transient Object dynamicObject = null;
    String[] dynamicPropNames = null;
    CommandRegistry commandRegistry = null;
    Entity parent = null;
    Map properties = null;
    String state = null;
    byte[] imageArray = null;
    transient ImageIcon imageIcon = null;
    transient String iconFilename = null;
    Map entities = null;
    transient EntityAddListener entityAddListener;
    transient EntityRemoveListener entityRemoveListener;
    transient ArrayList watchListeners = null;
    transient boolean upgrade = false;
    volatile String[] _ctx = null;
    volatile String[] _dctx = null;

    public Entity(String name, String displayName, String description, String state) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.state = state;
        this.entities = new ClonableMap();
        this.properties = new ClonableMap();
    }

    protected Entity() {
        this(null, null, null, null);
    }

    @Override
    public int getDumpId() {
        return 0;
    }

    protected boolean isSetParent() {
        return true;
    }

    protected void writeDump(DataOutput out, String s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(s);
        }
    }

    protected String readDump(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            return in.readUTF();
        }
        return null;
    }

    protected void writeDump(DataOutput out, String[] s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(s.length);
            for (int i = 0; i < s.length; ++i) {
                out.writeUTF(s[i]);
            }
        }
    }

    protected String[] readDumpStringArray(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            String[] s = new String[in.readInt()];
            for (int i = 0; i < s.length; ++i) {
                s[i] = in.readUTF();
            }
            return s;
        }
        return null;
    }

    protected void writeDump(DataOutput out, byte[] s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(s.length);
            out.write(s);
        }
    }

    protected byte[] readDumpByteArray(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            byte[] s = new byte[in.readInt()];
            in.readFully(s);
            return s;
        }
        return null;
    }

    protected void writeDump(DataOutput out, Dumpable d) throws IOException {
        if (d == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            Dumpalizer.dump(out, d);
        }
    }

    protected Dumpable readDumpDumpable(DataInput in, DumpableFactory factory) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            return Dumpalizer.construct(in, factory);
        }
        return null;
    }

    protected void writeDump(DataOutput out, Map map) throws IOException {
        if (map == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(map.size());
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Dumpalizer.dump(out, (Dumpable)iter.next().getValue());
            }
        }
    }

    protected ClonableMap readDumpDumpablePropMap(DataInput in, DumpableFactory factory) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            ClonableMap map = new ClonableMap();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                Property prop = (Property)Dumpalizer.construct(in, factory);
                prop.setParent(this);
                map.put(prop.getName(), prop);
            }
            return map;
        }
        return null;
    }

    protected ClonableMap readDumpDumpableEntityMap(DataInput in, DumpableFactory factory) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            ClonableMap map = new ClonableMap();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                Entity entity = (Entity)Dumpalizer.construct(in, factory);
                if (this.isSetParent()) {
                    entity.setParent(this);
                }
                map.put(entity.getName(), entity);
            }
            return map;
        }
        return null;
    }

    @Override
    public synchronized void writeContent(DataOutput out) throws IOException {
        this.writeDump(out, this.name);
        this.writeDump(out, this.displayName);
        this.writeDump(out, this.description);
        this.writeDump(out, this.state);
        out.writeBoolean(this.dynamic);
        this.writeDump(out, this.dynamicPropNames);
        this.writeDump(out, this.commandRegistry);
        this.writeDump(out, this.imageArray);
        this.writeDump(out, this.properties);
        this.writeDump(out, this.entities);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.name = this.readDump(in);
        this.displayName = this.readDump(in);
        this.description = this.readDump(in);
        this.state = this.readDump(in);
        this.dynamic = in.readBoolean();
        this.dynamicPropNames = this.readDumpStringArray(in);
        this.commandRegistry = (CommandRegistry)this.readDumpDumpable(in, this.factory);
        this.imageArray = this.readDumpByteArray(in);
        this.properties = this.readDumpDumpablePropMap(in, this.factory);
        this.entities = this.readDumpDumpableEntityMap(in, this.factory);
    }

    public void setImageArray(byte[] array) {
        this.imageArray = array;
    }

    String getIconFilename() {
        return this.iconFilename;
    }

    void setIconFilename(String iconFilename) {
        this.iconFilename = iconFilename;
    }

    public ImageIcon getIcon() {
        if (this.imageArray == null) {
            return null;
        }
        if (this.imageIcon == null) {
            this.imageIcon = new ImageIcon(this.imageArray);
        }
        return this.imageIcon;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean b) {
        this.dynamic = b;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Object getDynamicObject() {
        return this.dynamicObject;
    }

    public void setDynamicObject(Object dynamicObject) {
        this.dynamicObject = dynamicObject;
    }

    public String[] getDynamicPropNames() {
        return this.dynamicPropNames;
    }

    public void setDynamicPropNames(String[] dynamicPropNames) {
        this.dynamicPropNames = dynamicPropNames;
    }

    public String[] getContext() {
        if (this._ctx != null) {
            return this._ctx;
        }
        ArrayList<String> al = new ArrayList<String>();
        for (Entity actEntity = this; actEntity != null; actEntity = actEntity.getParent()) {
            al.add(actEntity.getName());
        }
        String[] ctx = new String[al.size()];
        int j = 0;
        for (int i = al.size() - 1; i >= 0; --i) {
            ctx[j++] = (String)al.get(i);
        }
        this._ctx = ctx;
        return this._ctx;
    }

    public String[] getDisplayContext() {
        if (this._dctx != null) {
            return this._dctx;
        }
        ArrayList<String> al = new ArrayList<String>();
        for (Entity actEntity = this; actEntity != null; actEntity = actEntity.getParent()) {
            al.add(actEntity.getDisplayName());
        }
        String[] ctx = new String[al.size()];
        int j = 0;
        for (int i = al.size() - 1; i >= 0; --i) {
            ctx[j++] = (String)al.get(i);
        }
        this._dctx = ctx;
        return this._dctx;
    }

    public void createCommands() {
        this.commandRegistry = new CommandRegistry("Context '" + this.name + "'", null);
        CommandExecutor setExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length < 2 || cmd.length > 3) {
                    return new String[]{"Error:", "Invalid command, please try 'set <prop> [<value>]'"};
                }
                String[] result = null;
                Property p = Entity.this.getProperty(cmd[1]);
                if (p == null) {
                    result = new String[]{"Error:", "Unknown Property: " + cmd[1]};
                } else if (p.isReadOnly()) {
                    result = new String[]{"Error:", "Property is read-only."};
                } else {
                    try {
                        if (cmd.length == 2) {
                            p.setValue(null);
                        } else {
                            p.setValue(Property.convertToType(p.getType(), cmd[2]));
                        }
                        if (p.isRebootRequired()) {
                            result = new String[]{"Information:", "To activate this Property Change, a Reboot of this Router is required."};
                        }
                    }
                    catch (Exception e) {
                        result = new String[]{"Error:", e.getMessage()};
                    }
                }
                return result;
            }
        };
        Command setCommand = new Command(SET_COMMAND, "set <prop> [<value>]", "Set Property <prop> to Value <value> or null", true, setExecutor);
        this.commandRegistry.addCommand(setCommand);
        CommandExecutor describeExecutor = new CommandExecutor(){

            private String check(Object o) {
                return o == null ? "<not set>" : o.toString();
            }

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length != 2) {
                    return new String[]{"Error:", "Invalid command, please try 'describe <prop>'"};
                }
                String[] result = null;
                Property p = Entity.this.getProperty(cmd[1]);
                result = p == null ? new String[]{"Error:", "Unknown Property: " + cmd[1]} : new String[]{"Result:", "Property Name  : " + p.getName(), "Display Name   : " + this.check(p.getDisplayName()), "Description    : " + this.check(p.getDescription()), "Type           : " + p.getType(), "Min. Value     : " + this.check(p.getMinValue()), "Max. Value     : " + this.check(p.getMaxValue()), "Default Value  : " + this.check(p.getDefaultValue()), "Poss. Values   : " + this.check(p.getPossibleValues()), "Actual Value   : " + this.check(p.getValue()), "Mandatory     : " + p.isMandatory(), "Read Only      : " + p.isReadOnly(), "Reboot Required: " + p.isRebootRequired()};
                return result;
            }
        };
        Command describeCommand = new Command("describe", "describe <prop>", "Show full Description of Property <prop>", true, describeExecutor);
        this.commandRegistry.addCommand(describeCommand);
        Iterator iter = this.entities.entrySet().iterator();
        while (iter.hasNext()) {
            Entity entity = (Entity)iter.next().getValue();
            entity.createCommands();
        }
    }

    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized void addCommand(String name, Command command) {
        command.setParent(this);
        this.commandRegistry.addCommand(command);
    }

    public synchronized void removeCommand(String name) {
        Command cmd = this.commandRegistry.findCommand(new String[]{name});
        if (cmd != null) {
            this.commandRegistry.removeCommand(cmd);
        }
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public synchronized void addProperty(String name, Property property) {
        property.setParent(this);
        this.properties.put(name, property);
    }

    public synchronized void removeProperty(String name) {
        this.properties.remove(name);
    }

    public synchronized Property getProperty(String name) {
        return (Property)this.properties.get(name);
    }

    public synchronized Map getProperties() {
        return ((ClonableMap)this.properties).createCopy();
    }

    public synchronized void addEntity(Entity entity) throws EntityAddException {
        if (this.entityAddListener != null) {
            this.entityAddListener.onEntityAdd(this, entity);
        }
        entity.setParent(this);
        this.entities.put(entity.getName(), entity);
        this.notifyEntityWatchListeners(true, entity);
    }

    public synchronized void removeEntity(Entity entity) throws EntityRemoveException {
        if (entity == null) {
            return;
        }
        if (this.entityRemoveListener != null) {
            this.entityRemoveListener.onEntityRemove(this, entity);
        }
        this.entities.remove(entity.getName());
        entity.setParent(null);
        this.notifyEntityWatchListeners(false, entity);
    }

    public synchronized void removeEntities() {
        this.entities.clear();
    }

    public synchronized void removeDynamicEntity(Object dynamicObject) {
        Iterator iter = this.entities.entrySet().iterator();
        while (iter.hasNext()) {
            Entity entity = (Entity)iter.next().getValue();
            if (entity.getDynamicObject() != dynamicObject) continue;
            entity.setDynamicObject(null);
            entity.setParent(null);
            iter.remove();
            this.notifyEntityWatchListeners(false, entity);
            break;
        }
    }

    public synchronized Entity getEntity(String name) {
        return (Entity)this.entities.get(name);
    }

    public synchronized String[] getEntityNames() {
        if (this.entities.size() == 0) {
            return null;
        }
        String[] rArr = new String[this.entities.size()];
        int i = 0;
        Iterator iter = this.entities.keySet().iterator();
        while (iter.hasNext()) {
            rArr[i++] = (String)iter.next();
        }
        return rArr;
    }

    public synchronized Map getEntities() {
        return ((ClonableMap)this.entities).createCopy();
    }

    public Entity getParent() {
        return this.parent;
    }

    protected void setParent(Entity parent) {
        this.parent = parent;
    }

    public EntityAddListener getEntityAddListener() {
        return this.entityAddListener;
    }

    public void setEntityAddListener(EntityAddListener entityAddListener) {
        this.entityAddListener = entityAddListener;
    }

    public EntityRemoveListener getEntityRemoveListener() {
        return this.entityRemoveListener;
    }

    public void setEntityRemoveListener(EntityRemoveListener entityRemoveListener) {
        this.entityRemoveListener = entityRemoveListener;
    }

    public synchronized void addEntityWatchListener(EntityWatchListener l) {
        if (this.watchListeners == null) {
            this.watchListeners = new ArrayList();
        }
        this.watchListeners.add(l);
    }

    public synchronized void removeEntityWatchListener(EntityWatchListener l) {
        if (this.watchListeners != null) {
            this.watchListeners.remove(l);
        }
    }

    protected void notifyEntityWatchListeners(boolean entityAdded, Entity entity) {
        if (this.watchListeners == null) {
            return;
        }
        for (int i = 0; i < this.watchListeners.size(); ++i) {
            EntityWatchListener l = (EntityWatchListener)this.watchListeners.get(i);
            if (entityAdded) {
                l.entityAdded(this, entity);
                continue;
            }
            l.entityRemoved(this, entity);
        }
    }

    public Entity createCopy() {
        Entity entity = new Entity(this.name, this.displayName, this.description, this.state);
        entity.dynamic = this.dynamic;
        entity.dynamicPropNames = this.dynamicPropNames;
        entity.commandRegistry = this.commandRegistry;
        entity.properties = new ClonableMap();
        Iterator iter = this.properties.entrySet().iterator();
        while (iter.hasNext()) {
            Property p = (Property)iter.next().getValue();
            Property copy = p.createCopy();
            copy.setParent(entity);
            entity.properties.put(copy.getName(), copy);
        }
        return entity;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(boolean upgrade) {
        this.upgrade = upgrade;
    }

    protected String quote(String s) {
        return "\"" + s + "\"";
    }

    protected boolean commandIncluded(Command command, String[] exclude) {
        return IntStream.range(0, exclude.length).noneMatch(i -> exclude[i].equals(command.getName()));
    }

    public String toJson() {
        boolean first;
        StringBuffer s = new StringBuffer();
        s.append("{");
        s.append(this.quote("nodetype")).append(": ");
        s.append(this.quote("entity")).append(", ");
        s.append(this.quote("name")).append(": ");
        s.append(this.quote(this.name)).append(", ");
        s.append(this.quote("displayName")).append(": ");
        s.append(this.quote(this.displayName)).append(", ");
        s.append(this.quote("description")).append(": ");
        s.append(this.quote(this.description)).append(", ");
        s.append(this.quote("hasChilds")).append(": ");
        s.append(this.entities != null && this.entities.size() > 0);
        if (this.properties != null) {
            s.append(", ");
            s.append(this.quote("properties")).append(": ");
            s.append("[");
            first = true;
            for (Map.Entry o : this.properties.entrySet()) {
                if (!first) {
                    s.append(", ");
                }
                first = false;
                Property p = (Property)o.getValue();
                s.append(p.toJson());
            }
            s.append("]");
        }
        if (this.entities != null) {
            s.append(", ");
            s.append(this.quote("entities")).append(": ");
            s.append("[");
            first = true;
            for (Map.Entry o : this.entities.entrySet()) {
                if (!first) {
                    s.append(", ");
                }
                first = false;
                Entity e = (Entity)o.getValue();
                s.append("{");
                s.append(this.quote("nodetype")).append(": ");
                if (e instanceof EntityList) {
                    s.append(this.quote("entitylist")).append(", ");
                } else {
                    s.append(this.quote("entity")).append(", ");
                }
                s.append(this.quote("name")).append(": ");
                s.append(this.quote(e.getName())).append(", ");
                s.append(this.quote("displayName")).append(": ");
                s.append(this.quote(e.getDisplayName())).append(", ");
                s.append(this.quote("description")).append(": ");
                s.append(this.quote(e.getDescription())).append(", ");
                s.append(this.quote("hasChilds")).append(": ");
                if (e instanceof EntityList) {
                    s.append(true);
                } else {
                    s.append(e.getEntities() != null && e.getEntities().size() > 0);
                }
                s.append("}");
            }
            s.append("]");
        }
        if (this.commandRegistry != null && this.commandRegistry.getCommands() != null) {
            s.append(", ");
            s.append(this.quote("commands")).append(": ");
            s.append("[");
            ArrayList cmds = this.commandRegistry.getCommands();
            boolean first2 = true;
            for (int i = 0; i < cmds.size(); ++i) {
                Command command = (Command)cmds.get(i);
                if (!this.commandIncluded(command, new String[]{"help", SET_COMMAND, "describe"})) continue;
                if (!first2) {
                    s.append(", ");
                }
                first2 = false;
                s.append(((Command)cmds.get(i)).toJson());
            }
            s.append("]");
        }
        s.append("}");
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("\n[Entity, name=");
        s.append(this.name);
        s.append(", displayName=");
        s.append(this.displayName);
        s.append(", description=");
        s.append(this.description);
        s.append(", state=");
        s.append(this.state);
        s.append(", properties=");
        s.append(this.properties);
        s.append(", entities=");
        s.append(this.entities);
        s.append("]");
        return s.toString();
    }

    protected class ClonableMap
    extends TreeMap {
        protected ClonableMap() {
        }

        public ClonableMap createCopy() {
            return (ClonableMap)this.clone();
        }
    }
}

