/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt;

import com.swiftmq.mgmt.Command;
import com.swiftmq.mgmt.CommandExecutor;
import com.swiftmq.mgmt.CommandRegistry;
import com.swiftmq.mgmt.Entity;
import com.swiftmq.mgmt.EntityAddListener;
import com.swiftmq.mgmt.EntityRemoveListener;
import com.swiftmq.mgmt.MgmtFactory;
import com.swiftmq.mgmt.Property;
import com.swiftmq.tools.sql.LikeComparator;
import com.swiftmq.tools.util.ObjectCloner;
import com.swiftmq.util.SwiftUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class EntityList
extends Entity {
    public static final String NEW_COMMAND = "new";
    public static final String DEL_COMMAND = "delete";
    static final DecimalFormat formatter = new DecimalFormat("###,##0.00", new DecimalFormatSymbols(Locale.US));
    Entity template;
    Command newCommand = null;
    Command delCommand = null;
    boolean rebootOnNew = false;
    boolean rebootOnDel = false;
    boolean autoCreateNewDel = false;

    public EntityList(String name, String displayName, String description, String state, Entity template, boolean rebootOnNew, boolean rebootOnDel) {
        super(name, displayName, description, state);
        this.template = template;
        this.rebootOnNew = rebootOnNew;
        this.rebootOnDel = rebootOnDel;
    }

    public EntityList(String name, String displayName, String description, String state, Entity template) {
        this(name, displayName, description, state, template, false, false);
    }

    public EntityList(String name, String displayName, String description, String state, Entity template, boolean autoCreateNewDel) {
        this(name, displayName, description, state, template, false, false);
        this.autoCreateNewDel = autoCreateNewDel;
    }

    protected EntityList() {
    }

    @Override
    public int getDumpId() {
        return 1;
    }

    @Override
    public synchronized void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        this.writeDump(out, this.template);
        this.writeDump(out, this.newCommand);
        this.writeDump(out, this.delCommand);
        out.writeBoolean(this.rebootOnNew);
        out.writeBoolean(this.rebootOnDel);
        out.writeBoolean(this.autoCreateNewDel);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.template = (Entity)this.readDumpDumpable(in, this.factory);
        this.newCommand = (Command)this.readDumpDumpable(in, this.factory);
        this.delCommand = (Command)this.readDumpDumpable(in, this.factory);
        this.rebootOnNew = in.readBoolean();
        this.rebootOnDel = in.readBoolean();
        this.autoCreateNewDel = in.readBoolean();
    }

    public Entity createEntity() {
        Entity entity = null;
        try {
            entity = (Entity)ObjectCloner.copy(this.template, this.factory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entity;
    }

    private String check(Object o) {
        return o == null ? "<not set>" : o.toString();
    }

    private String[] dirTemplate(Entity entity) {
        ArrayList<String> al = new ArrayList<String>();
        al.add("Result:");
        al.add("Template:    " + entity.getDisplayName());
        al.add("Description: " + entity.getDescription());
        al.add("");
        Map m = entity.getProperties();
        if (m.size() == 0) {
            al.add("Template contains no Properties.");
        } else {
            al.add("Properties for this Template:");
            Iterator iter = m.keySet().iterator();
            while (iter.hasNext()) {
                al.add("");
                String name = (String)iter.next();
                Property p = entity.getProperty(name);
                al.add("Property Name  : " + p.getName());
                al.add("Display Name   : " + this.check(p.getDisplayName()));
                al.add("Description    : " + this.check(p.getDescription()));
                al.add("Type           : " + p.getType());
                al.add("Min. Value     : " + this.check(p.getMinValue()));
                al.add("Max. Value     : " + this.check(p.getMaxValue()));
                al.add("Default Value  : " + this.check(p.getDefaultValue()));
                al.add("Poss. Values   : " + this.check(p.getPossibleValues()));
                al.add("Mandatory     : " + p.isMandatory());
                al.add("Read Only      : " + p.isReadOnly());
                al.add("Reboot Required: " + p.isRebootRequired());
            }
        }
        al.add("");
        m = entity.getEntities();
        if (m.size() == 0) {
            al.add("Template contains no Sub-Entities.");
        } else {
            al.add("Sub-Entities of this Template:");
            al.add("------------------------------");
            for (String name : m.keySet()) {
                al.add(name);
            }
        }
        return al.toArray(new String[al.size()]);
    }

    private void sumProp(Map sumMap, Property p) {
        Number val;
        if (p.getValue() == null) {
            return;
        }
        if (p.getType() == Integer.class) {
            val = (Integer)sumMap.get(p.getName());
            val = val == null ? (Integer)p.getValue() : new Integer((Integer)val + (Integer)p.getValue());
            sumMap.put(p.getName(), val);
        } else if (p.getType() == Long.class) {
            val = (Long)sumMap.get(p.getName());
            val = val == null ? (Long)p.getValue() : new Long((Long)val + (Long)p.getValue());
            sumMap.put(p.getName(), val);
        }
        if (p.getType() == Double.class) {
            val = (Double)sumMap.get(p.getName());
            val = val == null ? (Double)p.getValue() : new Double((Double)val + (Double)p.getValue());
            sumMap.put(p.getName(), val);
        } else if (p.getType() == String.class) {
            double pVal = Double.parseDouble((String)p.getValue());
            Double val2 = (Double)sumMap.get(p.getName());
            val2 = val2 == null ? new Double(pVal) : new Double(val2 + pVal);
            sumMap.put(p.getName(), val2);
        }
    }

    private String[] sumProps(String[] propNames) {
        Entity tpl = this.getTemplate();
        Map m = tpl.getProperties();
        if (m.size() == 0) {
            return new String[]{"Error:", "This entity list doesn't contain any property"};
        }
        for (int i = 0; i < propNames.length; ++i) {
            Property p = (Property)m.get(propNames[i]);
            if (p == null) {
                return new String[]{"Error:", "Property '" + propNames[i] + "' not found"};
            }
            if (p.getType() == Integer.class || p.getType() == Double.class || p.getType() == Long.class || p.getType() == String.class) continue;
            return new String[]{"Error:", "Property '" + propNames[i] + "' has wrong type"};
        }
        ArrayList<String> al = new ArrayList<String>();
        al.add("Result:");
        m = this.getEntities();
        if (m.size() == 0) {
            al.add("Entity list is empty.");
        } else {
            HashMap sumMap = new HashMap();
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Entity e = (Entity)iter.next().getValue();
                for (int i = 0; i < propNames.length; ++i) {
                    this.sumProp(sumMap, e.getProperty(propNames[i]));
                }
            }
            al.add("count: " + m.size());
            for (int i = 0; i < propNames.length; ++i) {
                Object val = sumMap.get(propNames[i]);
                if (val == null) continue;
                al.add(propNames[i] + ": " + (val instanceof Double ? formatter.format((Double)val) : val));
            }
        }
        return al.toArray(new String[al.size()]);
    }

    @Override
    public void createCommands() {
        this.commandRegistry = new CommandRegistry("Context '" + this.name + "'", null);
        CommandExecutor tplExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length != 2) {
                    return new String[]{"Error:", "Invalid command, please try 'show template'"};
                }
                String[] result = EntityList.this.dirTemplate(EntityList.this.getTemplate());
                return result;
            }
        };
        Command tplCommand = new Command("show template", "show template", "Show the Template for new Entities", true, tplExecutor);
        this.commandRegistry.addCommand(tplCommand);
        CommandExecutor sumExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                String[] stringArray;
                if (cmd.length > 1) {
                    stringArray = EntityList.this.sumProps(SwiftUtilities.cutFirst(cmd));
                } else {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "Result:";
                    stringArray = stringArray2;
                    stringArray2[1] = "count: " + EntityList.this.getEntities().size();
                }
                String[] result = stringArray;
                return result;
            }
        };
        Command sumCommand = new Command("sum", "sum [<prop1> <prop2> ...]", "Computes the sum of property values", true, sumExecutor);
        this.commandRegistry.addCommand(sumCommand);
        CommandExecutor newExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length < 2 || cmd.length % 2 != 0) {
                    return new String[]{"Error:", "Invalid command, please try 'new <name> [<prop> <value> ...]'"};
                }
                String[] result = null;
                if (EntityList.this.getEntity(cmd[1]) != null) {
                    return new String[]{"Error:", "Entity '" + cmd[1] + "' is already defined."};
                }
                try {
                    Entity newEntity = (Entity)ObjectCloner.copy(EntityList.this.template, new MgmtFactory());
                    newEntity.setName(cmd[1]);
                    newEntity.createCommands();
                    for (int i = 2; i < cmd.length; i += 2) {
                        Property p = newEntity.getProperty(cmd[i]);
                        if (p == null) {
                            return new String[]{"Error:", "Unknown Property: " + cmd[i]};
                        }
                        try {
                            p.setValue(Property.convertToType(p.getType(), cmd[i + 1]));
                            continue;
                        }
                        catch (Exception e) {
                            return new String[]{"Error:", "Property '" + cmd[i] + "' Value '" + cmd[i + 1] + "': " + e.getMessage()};
                        }
                    }
                    Map m = newEntity.getProperties();
                    Iterator iter = m.entrySet().iterator();
                    while (iter.hasNext()) {
                        Property p = (Property)iter.next().getValue();
                        if (!p.isMandatory() || p.getValue() != null) continue;
                        return new String[]{"Error:", "Mandatory Property '" + p.getName() + "' must be set."};
                    }
                    EntityList.this.addEntity(newEntity);
                    if (EntityList.this.rebootOnNew) {
                        result = new String[]{"Information:", "To activate this Change, a Reboot of this Router is required."};
                    }
                }
                catch (Exception e) {
                    result = new String[]{"Error:", e.getMessage()};
                }
                return result;
            }
        };
        String s = "Create a new Entity";
        this.newCommand = new Command(NEW_COMMAND, "new <name> [<prop> <value> ...]", s, true, newExecutor, true, false);
        if ((this.rebootOnNew || this.autoCreateNewDel) && !this.isDynamic()) {
            this.commandRegistry.addCommand(this.newCommand);
        }
        CommandExecutor delExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length < 2 || cmd.length > 3) {
                    return new String[]{"Error:", "Invalid command, please try 'delete  <name|predicate> [-p]'"};
                }
                boolean isPredicate = false;
                if (cmd.length == 3) {
                    if (cmd[2].equals("-p")) {
                        isPredicate = true;
                    } else {
                        return new String[]{"Error:", "Invalid command, please try 'delete  <name|predicate> [-p]'"};
                    }
                }
                String[] result = null;
                if (isPredicate) {
                    String[] names = EntityList.this.getEntityNames();
                    if (names != null && names.length > 0) {
                        String predicate = cmd[1];
                        try {
                            for (int i = 0; i < names.length; ++i) {
                                if (!LikeComparator.compare(names[i], predicate, '\\')) continue;
                                EntityList.this.removeEntity(EntityList.this.getEntity(names[i]));
                            }
                            if (EntityList.this.rebootOnDel) {
                                result = new String[]{"Information:", "To activate this Change, a Reboot of this Router is required."};
                            }
                        }
                        catch (Exception ex) {
                            result = new String[]{"Error:", ex.getMessage()};
                        }
                    }
                } else {
                    Entity e = EntityList.this.getEntity(cmd[1]);
                    if (e == null) {
                        return new String[]{"Error:", "Unknown Entity: " + cmd[1]};
                    }
                    try {
                        EntityList.this.removeEntity(e);
                        if (EntityList.this.rebootOnDel) {
                            result = new String[]{"Information:", "To activate this Change, a Reboot of this Router is required."};
                        }
                    }
                    catch (Exception ex) {
                        result = new String[]{"Error:", ex.getMessage()};
                    }
                }
                return result;
            }
        };
        this.delCommand = new Command(DEL_COMMAND, "delete <name|predicate> [-p]", "Delete Entity", true, delExecutor, true, true);
        if ((this.rebootOnNew || this.autoCreateNewDel) && !this.isDynamic()) {
            this.commandRegistry.addCommand(this.delCommand);
        }
        Iterator iter = this.entities.entrySet().iterator();
        while (iter.hasNext()) {
            Entity entity = (Entity)iter.next().getValue();
            entity.createCommands();
        }
    }

    public Entity getTemplate() {
        return this.template;
    }

    @Override
    public void setEntityAddListener(EntityAddListener entityAddListener) {
        if (entityAddListener == null) {
            this.commandRegistry.removeCommand(this.newCommand);
        } else {
            this.commandRegistry.addCommand(this.newCommand);
        }
        super.setEntityAddListener(entityAddListener);
    }

    @Override
    public void setEntityRemoveListener(EntityRemoveListener entityRemoveListener) {
        if (entityRemoveListener == null) {
            this.commandRegistry.removeCommand(this.delCommand);
        } else {
            this.commandRegistry.addCommand(this.delCommand);
        }
        super.setEntityRemoveListener(entityRemoveListener);
    }

    @Override
    public String toJson() {
        StringBuffer s = new StringBuffer();
        s.append("{");
        s.append(this.quote("nodetype")).append(": ");
        s.append(this.quote("entitylist")).append(", ");
        s.append(this.quote("name")).append(": ");
        s.append(this.quote(this.name)).append(", ");
        s.append(this.quote("displayName")).append(": ");
        s.append(this.quote(this.displayName)).append(", ");
        s.append(this.quote("description")).append(": ");
        s.append(this.quote(this.description)).append(", ");
        s.append(this.quote("hasChilds")).append(": ");
        s.append(true).append(", ");
        s.append(this.quote("template")).append(": ");
        s.append(this.template.toJson());
        if (this.commandRegistry != null && this.commandRegistry.getCommands() != null) {
            s.append(", ");
            s.append(this.quote("commands")).append(": ");
            s.append("[");
            ArrayList cmds = this.commandRegistry.getCommands();
            boolean first = true;
            for (int i = 0; i < cmds.size(); ++i) {
                Command command = (Command)cmds.get(i);
                if (!this.commandIncluded(command, new String[]{"help", "sum", "show template"})) continue;
                if (!first) {
                    s.append(", ");
                }
                first = false;
                s.append(((Command)cmds.get(i)).toJson());
            }
            s.append("]");
        }
        s.append("}");
        return s.toString();
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("\n[EntityList, entity=");
        s.append(super.toString());
        s.append(", template=");
        s.append(this.template);
        s.append("]");
        return s.toString();
    }
}

