/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt;

import com.swiftmq.mgmt.XMLUtilities;
import java.io.FileInputStream;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class PreConfigurator {
    private static String OP = "_op";
    Document routerconfig;
    Document changes;

    public PreConfigurator(Document routerconfig, Document changes) {
        this.routerconfig = routerconfig;
        this.changes = changes;
    }

    public static void main(String[] args) {
        try {
            Document routerConfig = XMLUtilities.createDocument(new FileInputStream(args[0]));
            Document changes = XMLUtilities.createDocument(new FileInputStream(args[1]));
            String outputFile = args[2];
            Document result = new PreConfigurator(routerConfig, changes).applyChanges();
            XMLUtilities.writeDocument(result, outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getOp(Element element) throws Exception {
        if (element.attribute(OP) == null) {
            return null;
        }
        return element.attribute(OP).getValue();
    }

    private boolean hasName(String name, Element element) {
        Iterator iter = element.attributeIterator();
        while (iter.hasNext()) {
            Attribute attribute = (Attribute)iter.next();
            if (!attribute.getName().equals("name") || !attribute.getValue().equals(name)) continue;
            return true;
        }
        return false;
    }

    private Element findElement(Element searchFor, Element searchIn) {
        Attribute nameAttr = searchFor.attribute("name");
        Iterator iter = searchIn.elementIterator();
        while (iter.hasNext()) {
            Element child = (Element)iter.next();
            if (!(nameAttr != null ? this.hasName(nameAttr.getValue(), child) : child.getName().equals(searchFor.getName()))) continue;
            return child;
        }
        return null;
    }

    private void clearElements(Element root) {
        Iterator iter = root.elementIterator();
        while (iter.hasNext()) {
            Element child = (Element)iter.next();
            child.detach();
        }
    }

    private void processElement(Element changeEle, Element configEle, boolean isParent) throws Exception {
        if (!isParent) {
            this.processAttributes(changeEle, configEle);
        }
        boolean goDeeper = true;
        String op = this.getOp(changeEle);
        if (op != null) {
            Element copy = changeEle.createCopy();
            switch (op) {
                case "clear": {
                    if (isParent) break;
                    this.clearElements(configEle);
                    break;
                }
                case "add": {
                    copy.remove(copy.attribute(OP));
                    if (!isParent) {
                        configEle.getParent().add(copy);
                    } else {
                        configEle.add(copy);
                    }
                    goDeeper = false;
                    break;
                }
                case "remove": {
                    if (!isParent) {
                        configEle.detach();
                    }
                    goDeeper = false;
                    break;
                }
                case "replace": {
                    if (!isParent) {
                        Element parent = configEle.getParent();
                        configEle.detach();
                        copy.remove(copy.attribute(OP));
                        parent.add(copy);
                    }
                    goDeeper = false;
                }
            }
        }
        if (goDeeper) {
            Iterator iter = changeEle.elementIterator();
            while (iter.hasNext()) {
                Element changeChild = (Element)iter.next();
                Element configChild = this.findElement(changeChild, configEle);
                if (configChild != null) {
                    this.processElement(changeChild, configChild, false);
                    continue;
                }
                this.processElement(changeChild, configEle, true);
            }
        }
    }

    private void processAttributes(Element changeEle, Element configEle) throws Exception {
        Iterator iter = changeEle.attributeIterator();
        while (iter.hasNext()) {
            Attribute attribute = (Attribute)iter.next();
            if (attribute.getName().equals(OP)) continue;
            Attribute configAttribute = configEle.attribute(attribute.getName());
            if (configAttribute == null) {
                configEle.addAttribute(attribute.getName(), attribute.getValue());
                continue;
            }
            configAttribute.setValue(attribute.getValue());
        }
    }

    public Document applyChanges() throws Exception {
        this.processAttributes(this.changes.getRootElement(), this.routerconfig.getRootElement());
        Iterator iter = this.changes.getRootElement().elementIterator();
        while (iter.hasNext()) {
            Element changeElement = (Element)iter.next();
            if (!changeElement.getName().equals("swiftlet") && !changeElement.getName().equals("ha-router")) {
                throw new Exception("Next element after 'router' must be a 'ha-router' or a 'swiftlet' element!");
            }
            if (changeElement.getName().equals("swiftlet")) {
                Attribute name = changeElement.attribute("name");
                if (name == null) {
                    throw new Exception("Missing 'name' attribute in 'swiftlet' element!");
                }
                Element configSwiftlet = XMLUtilities.getSwiftletElement(name.getValue(), this.routerconfig.getRootElement());
                if (configSwiftlet == null) {
                    throw new Exception("Swiftlet with name '" + name.getValue() + "' not found!");
                }
                this.processElement(changeElement, configSwiftlet, false);
                continue;
            }
            this.processElement(changeElement, this.routerconfig.getRootElement().element("ha-router"), false);
        }
        return this.routerconfig;
    }
}

