/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt;

import com.swiftmq.mgmt.Entity;
import com.swiftmq.mgmt.InvalidTypeException;
import com.swiftmq.mgmt.InvalidValueException;
import com.swiftmq.mgmt.PropertyChangeException;
import com.swiftmq.mgmt.PropertyChangeListener;
import com.swiftmq.mgmt.PropertyWatchListener;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.util.SwiftUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class Property
implements Dumpable {
    String name = null;
    Entity parent = null;
    String displayName = null;
    String description = null;
    Class type = null;
    boolean readOnly = false;
    boolean mandatory = false;
    boolean rebootRequired = false;
    boolean storable = true;
    Object value = null;
    Comparable minValue = null;
    Comparable maxValue = null;
    Object defaultValue = null;
    ArrayList possibleValues = null;
    ArrayList possibleValueDescriptions = null;
    transient PropertyChangeListener propertyChangeListener;
    transient ArrayList watchListeners = null;

    public Property(String name) {
        this.name = name;
    }

    Property() {
    }

    public static Object convertToType(Class type, String v) throws InvalidTypeException {
        Object r = null;
        try {
            if (type == String.class) {
                r = v;
            } else if (type == Boolean.class) {
                r = Boolean.valueOf(v);
            } else if (type == Double.class) {
                r = Double.valueOf(v);
            } else if (type == Integer.class) {
                r = Integer.valueOf(v);
            } else if (type == Long.class) {
                r = Long.valueOf(v);
            } else if (type == Float.class) {
                r = Float.valueOf(v);
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidTypeException("invalid type for value; does not match " + type);
        }
        return r;
    }

    @Override
    public int getDumpId() {
        return 2;
    }

    private void writeDump(DataOutput out, String s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(s);
        }
    }

    private String readDump(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            return in.readUTF();
        }
        return null;
    }

    private void writeList(DataOutput out, ArrayList vl, Class type) throws IOException {
        if (vl == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(vl.size());
            for (int i = 0; i < vl.size(); ++i) {
                this.writeValue(out, vl.get(i), type);
            }
        }
    }

    private ArrayList readDump(DataInput in, Class type) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            int size = in.readInt();
            ArrayList<Object> vl = new ArrayList<Object>();
            for (int i = 0; i < size; ++i) {
                vl.add(this.readValue(in, type));
            }
            return vl;
        }
        return null;
    }

    private void writeList(DataOutput out, ArrayList vl) throws IOException {
        if (vl == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(vl.size());
            for (int i = 0; i < vl.size(); ++i) {
                out.writeUTF((String)vl.get(i));
            }
        }
    }

    private ArrayList readList(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            int size = in.readInt();
            ArrayList<String> vl = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                vl.add(in.readUTF());
            }
            return vl;
        }
        return null;
    }

    private void writeValue(DataOutput out, Object v, Class type) throws IOException {
        if (v == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            if (type == String.class) {
                out.writeUTF((String)v);
            } else if (type == Boolean.class) {
                out.writeBoolean(Boolean.valueOf(v.toString()));
            } else if (type == Double.class) {
                out.writeDouble(Double.valueOf(v.toString()));
            } else if (type == Integer.class) {
                out.writeInt(Integer.valueOf(v.toString()));
            } else if (type == Long.class) {
                out.writeLong(Long.valueOf(v.toString()));
            } else if (type == Float.class) {
                out.writeFloat(Float.valueOf(v.toString()).floatValue());
            }
        }
    }

    private Object readValue(DataInput in, Class type) throws IOException {
        Object v = null;
        byte set = in.readByte();
        if (set == 1) {
            if (type == String.class) {
                v = in.readUTF();
            } else if (type == Boolean.class) {
                v = new Boolean(in.readBoolean());
            } else if (type == Double.class) {
                v = new Double(in.readDouble());
            } else if (type == Integer.class) {
                v = new Integer(in.readInt());
            } else if (type == Long.class) {
                v = new Long(in.readLong());
            } else if (type == Float.class) {
                v = new Float(in.readFloat());
            }
        }
        return v;
    }

    @Override
    public synchronized void writeContent(DataOutput out) throws IOException {
        this.writeDump(out, this.name);
        this.writeDump(out, this.displayName);
        this.writeDump(out, this.description);
        this.writeDump(out, this.type.getName());
        out.writeBoolean(this.readOnly);
        out.writeBoolean(this.mandatory);
        out.writeBoolean(this.rebootRequired);
        out.writeBoolean(this.storable);
        this.writeValue(out, this.value, this.type);
        this.writeValue(out, this.minValue, this.type);
        this.writeValue(out, this.maxValue, this.type);
        this.writeValue(out, this.defaultValue, this.type);
        this.writeList(out, this.possibleValues, this.type);
        this.writeList(out, this.possibleValueDescriptions);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        try {
            this.name = this.readDump(in);
            this.displayName = this.readDump(in);
            this.description = this.readDump(in);
            this.type = Class.forName(this.readDump(in));
            this.readOnly = in.readBoolean();
            this.mandatory = in.readBoolean();
            this.rebootRequired = in.readBoolean();
            this.storable = in.readBoolean();
            this.value = this.readValue(in, this.type);
            this.minValue = (Comparable)this.readValue(in, this.type);
            this.maxValue = (Comparable)this.readValue(in, this.type);
            this.defaultValue = this.readValue(in, this.type);
            this.possibleValues = this.readDump(in, this.type);
            this.possibleValueDescriptions = this.readList(in);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private boolean isInPossibleList(Object v) {
        if (this.possibleValues == null) {
            return true;
        }
        if (v == null) {
            return false;
        }
        boolean rc = false;
        for (int i = 0; i < this.possibleValues.size(); ++i) {
            if (((Comparable)this.possibleValues.get(i)).compareTo(v) != 0) continue;
            rc = true;
            break;
        }
        return rc;
    }

    public synchronized Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.defaultValue;
    }

    public synchronized void setValue(Object value) throws InvalidValueException, InvalidTypeException, PropertyChangeException {
        if (value != null) {
            if (this.type == null) {
                throw new InvalidTypeException("no type set");
            }
            if (this.type != value.getClass()) {
                throw new InvalidTypeException("invalid type for value; does not match " + this.type);
            }
            if (this.minValue != null && this.minValue.compareTo(value) > 0) {
                throw new InvalidValueException("invalid value, must be >= " + this.minValue);
            }
            if (this.maxValue != null && this.maxValue.compareTo(value) < 0) {
                throw new InvalidValueException("invalid value, must be <= " + this.maxValue);
            }
            if (!this.isInPossibleList(value)) {
                throw new InvalidValueException("invalid value, must be in " + this.possibleValues);
            }
        } else {
            if (this.mandatory && this.defaultValue == null) {
                throw new InvalidValueException("Property is mandatory, value can't be null");
            }
            if (this.type != String.class) {
                throw new InvalidValueException("Null values are only possible for String types");
            }
        }
        if (this.propertyChangeListener != null) {
            this.propertyChangeListener.propertyChanged(this, this.value, value);
        }
        this.value = value;
        this.notifyPropertyWatchListeners();
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) throws InvalidTypeException {
        if (type != null && type != Boolean.class && type != Double.class && type != Integer.class && type != Long.class && type != String.class && type != Float.class) {
            throw new InvalidTypeException("invalid type; must be of Boolean, Double, Integer, Long, Float, String");
        }
        this.type = type;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isStorable() {
        return this.storable;
    }

    public void setStorable(boolean storable) {
        this.storable = storable;
    }

    public boolean isRebootRequired() {
        return this.rebootRequired;
    }

    public void setRebootRequired(boolean rebootRequired) {
        this.rebootRequired = rebootRequired;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public Comparable getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Comparable minValue) throws InvalidTypeException {
        if (this.type == null) {
            throw new InvalidTypeException("type not set");
        }
        this.minValue = minValue;
    }

    public Comparable getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Comparable maxValue) throws InvalidTypeException {
        if (this.type == null) {
            throw new InvalidTypeException("type not set");
        }
        this.maxValue = maxValue;
    }

    public ArrayList getPossibleValues() {
        return this.possibleValues;
    }

    public void setPossibleValues(ArrayList possibleValues) throws InvalidTypeException {
        if (this.type == null) {
            throw new InvalidTypeException("type not set");
        }
        if (possibleValues != null) {
            for (int i = 0; i < possibleValues.size(); ++i) {
                Object value = possibleValues.get(i);
                if (value == null || this.type == value.getClass()) continue;
                throw new InvalidTypeException("invalid type for value '" + value + "'; does not match " + this.type);
            }
        }
        this.possibleValues = possibleValues;
    }

    public ArrayList getPossibleValueDescriptions() {
        return this.possibleValueDescriptions;
    }

    public void setPossibleValueDescriptions(ArrayList possibleValueDescriptions) {
        this.possibleValueDescriptions = possibleValueDescriptions;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDefaultProp(Property defaultProp) {
        if (defaultProp != null) {
            this.defaultValue = defaultProp.getValue();
            defaultProp.addPropertyWatchListener(new PropertyWatchListener(){

                @Override
                public void propertyValueChanged(Property p) {
                    Property.this.defaultValue = p.getValue();
                }
            });
        }
    }

    public PropertyChangeListener getPropertyChangeListener() {
        return this.propertyChangeListener;
    }

    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
    }

    public synchronized void addPropertyWatchListener(PropertyWatchListener l) {
        if (this.watchListeners == null) {
            this.watchListeners = new ArrayList();
        }
        this.watchListeners.add(l);
    }

    public synchronized void removePropertyWatchListener(PropertyWatchListener l) {
        if (this.watchListeners != null) {
            this.watchListeners.remove(l);
        }
    }

    private void notifyPropertyWatchListeners() {
        if (this.watchListeners == null) {
            return;
        }
        for (int i = 0; i < this.watchListeners.size(); ++i) {
            PropertyWatchListener l = (PropertyWatchListener)this.watchListeners.get(i);
            l.propertyValueChanged(this);
        }
    }

    public Entity getParent() {
        return this.parent;
    }

    protected void setParent(Entity parent) {
        this.parent = parent;
    }

    public Property createCopy() {
        Property prop = new Property(this.name);
        prop.displayName = this.displayName;
        prop.description = this.description;
        prop.type = this.type;
        prop.readOnly = this.readOnly;
        prop.mandatory = this.mandatory;
        prop.rebootRequired = this.rebootRequired;
        prop.storable = this.storable;
        prop.value = this.value;
        prop.minValue = this.minValue;
        prop.maxValue = this.maxValue;
        prop.defaultValue = this.defaultValue;
        prop.possibleValues = this.possibleValues;
        prop.possibleValueDescriptions = this.possibleValueDescriptions;
        return prop;
    }

    private String escapeJsonControls(String s) {
        return SwiftUtilities.replace(s, "\\", "\\\\").replace("\"", "\\\"");
    }

    private String quote(String s) {
        return "\"" + this.escapeJsonControls(s) + "\"";
    }

    public String toJson() {
        StringBuffer s = new StringBuffer();
        s.append("{");
        s.append(this.quote("name")).append(": ");
        s.append(this.quote(this.name)).append(", ");
        s.append(this.quote("displayName")).append(": ");
        s.append(this.quote(this.displayName)).append(", ");
        s.append(this.quote("description")).append(": ");
        s.append(this.quote(this.description)).append(", ");
        s.append(this.quote("type")).append(": ");
        s.append(this.quote(this.type.getSimpleName())).append(", ");
        s.append(this.quote("readOnly")).append(": ");
        s.append(this.readOnly).append(", ");
        s.append(this.quote("mandatory")).append(": ");
        s.append(this.mandatory).append(", ");
        s.append(this.quote("rebootRequired")).append(": ");
        s.append(this.rebootRequired);
        if (this.value != null) {
            s.append(", ");
            s.append(this.quote("value")).append(": ");
            if (this.value instanceof String) {
                s.append(this.quote((String)this.value));
            } else {
                s.append(this.value);
            }
        }
        if (this.minValue != null) {
            s.append(", ");
            s.append(this.quote("minValue")).append(": ");
            s.append(this.minValue);
        }
        if (this.maxValue != null) {
            s.append(", ");
            s.append(this.quote("maxValue")).append(": ");
            s.append(this.maxValue);
        }
        if (this.defaultValue != null) {
            s.append(", ");
            s.append(this.quote("defaultValue")).append(": ");
            if (this.type == String.class) {
                s.append(this.quote((String)this.defaultValue));
            } else {
                s.append(this.defaultValue);
            }
        }
        if (this.possibleValues != null) {
            s.append(", ");
            s.append(this.quote("possibleValues")).append(": ");
            s.append("[");
            for (int i = 0; i < this.possibleValues.size(); ++i) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append(this.quote(this.possibleValues.get(i).toString()));
            }
            s.append("]");
        }
        s.append("}");
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[Property, name=");
        s.append(this.name);
        s.append(", displayName=");
        s.append(this.displayName);
        s.append(", description=");
        s.append(this.description);
        s.append(", type=");
        s.append(this.type);
        s.append(", value=");
        s.append(this.value);
        s.append(", readOnly=");
        s.append(this.readOnly);
        s.append(", storable=");
        s.append(this.storable);
        s.append(", mandatory=");
        s.append(this.mandatory);
        s.append(", rebootRequired=");
        s.append(this.rebootRequired);
        s.append(", minValue=");
        s.append(this.minValue);
        s.append(", maxValue=");
        s.append(this.maxValue);
        s.append(", possibleValues=");
        s.append(this.possibleValues);
        s.append(", possibleValueDescriptions=");
        s.append(this.possibleValueDescriptions);
        s.append(", defaultValue=");
        s.append(this.defaultValue);
        s.append("]");
        return s.toString();
    }
}

