/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt.protocol.v750;

import com.swiftmq.mgmt.protocol.v750.ProtocolVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import com.swiftmq.util.SwiftUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class PropertyChangedRequest
extends Request {
    String[] context = null;
    String name = null;
    Object value = null;

    public PropertyChangedRequest(String[] context, String name, Object value) {
        super(0, false);
        this.context = context;
        this.name = name;
        this.value = value;
    }

    public PropertyChangedRequest() {
        this(null, null, null);
    }

    public String[] getContext() {
        return this.context;
    }

    public void setContext(String[] context) {
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public int getDumpId() {
        return 110;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.context != null) {
            out.writeByte(1);
            out.writeInt(this.context.length);
            for (int i = 0; i < this.context.length; ++i) {
                out.writeUTF(this.context[i]);
            }
        } else {
            out.writeByte(0);
        }
        out.writeUTF(this.name);
        if (this.value != null) {
            out.writeByte(1);
            DataByteArrayOutputStream dbos = new DataByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(dbos);
            oos.writeObject(this.value);
            oos.flush();
            oos.close();
            out.writeInt(dbos.getCount());
            out.write(dbos.getBuffer(), 0, dbos.getCount());
        } else {
            out.writeByte(0);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        byte set = in.readByte();
        if (set == 1) {
            this.context = new String[in.readInt()];
            for (int i = 0; i < this.context.length; ++i) {
                this.context[i] = in.readUTF();
            }
        }
        this.name = in.readUTF();
        set = in.readByte();
        if (set == 1) {
            byte[] b = new byte[in.readInt()];
            in.readFully(b);
            DataByteArrayInputStream dbis = new DataByteArrayInputStream(b);
            ObjectInputStream ois = new ObjectInputStream(dbis);
            try {
                this.value = ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e.toString());
            }
            ois.close();
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return null;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((ProtocolVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        return "[PropertyChangedRequest " + super.toString() + ", context=" + (this.context != null ? SwiftUtilities.concat(this.context, "/") : "null") + ", name=" + this.name + ", value=" + this.value + "]";
    }
}

