/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.mgmt.protocol.v750;

import com.swiftmq.mgmt.protocol.v750.ProtocolVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RouterConfigRequest
extends Request {
    int connectId = 0;
    String routerName = null;
    byte[] buffer = null;
    int length = 0;

    public RouterConfigRequest(int connectId, String routerName, byte[] buffer, int length) {
        super(0, false);
        this.connectId = connectId;
        this.routerName = routerName;
        this.buffer = new byte[length];
        this.length = length;
        System.arraycopy(buffer, 0, this.buffer, 0, length);
    }

    public RouterConfigRequest() {
        super(0, false);
    }

    public int getConnectId() {
        return this.connectId;
    }

    public void setConnectId(int connectId) {
        this.connectId = connectId;
    }

    public String getRouterName() {
        return this.routerName;
    }

    public void setRouterName(String routerName) {
        this.routerName = routerName;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = new byte[buffer.length];
        System.arraycopy(buffer, 0, this.buffer, 0, buffer.length);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public int getDumpId() {
        return 113;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.writeInt(this.connectId);
        out.writeUTF(this.routerName);
        out.writeInt(this.length);
        out.write(this.buffer, 0, this.length);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.connectId = in.readInt();
        this.routerName = in.readUTF();
        this.length = in.readInt();
        this.buffer = new byte[this.length];
        in.readFully(this.buffer);
    }

    @Override
    protected Reply createReplyInstance() {
        return null;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((ProtocolVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        return "[RouterConfigRequest " + super.toString() + ", connectId=" + this.connectId + ", routerName=" + this.routerName + ", length=" + this.length + "]";
    }
}

