/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.ms.artemis.filter;

import com.swiftmq.ms.artemis.filter.BinaryExpression;
import com.swiftmq.ms.artemis.filter.BooleanExpression;
import com.swiftmq.ms.artemis.filter.FilterException;
import com.swiftmq.ms.artemis.filter.Filterable;

public abstract class LogicExpression
extends BinaryExpression
implements BooleanExpression {
    public LogicExpression(BooleanExpression left, BooleanExpression right) {
        super(left, right);
    }

    public static BooleanExpression createOR(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            @Override
            public Object evaluate(Filterable message) throws FilterException {
                Boolean lv = (Boolean)this.left.evaluate(message);
                if (lv != null && lv.booleanValue()) {
                    return Boolean.TRUE;
                }
                Boolean rv = (Boolean)this.right.evaluate(message);
                return rv == null ? null : rv;
            }

            @Override
            public String getExpressionSymbol() {
                return "OR";
            }
        };
    }

    public static BooleanExpression createAND(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            @Override
            public Object evaluate(Filterable message) throws FilterException {
                Boolean lv = (Boolean)this.left.evaluate(message);
                if (lv == null) {
                    return null;
                }
                if (!lv.booleanValue()) {
                    return Boolean.FALSE;
                }
                Boolean rv = (Boolean)this.right.evaluate(message);
                return rv == null ? null : rv;
            }

            @Override
            public String getExpressionSymbol() {
                return "AND";
            }
        };
    }

    @Override
    public abstract Object evaluate(Filterable var1) throws FilterException;

    @Override
    public boolean matches(Filterable message) throws FilterException {
        Object object = this.evaluate(message);
        return object == Boolean.TRUE;
    }
}

