/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.ms.artemis.filter;

import com.swiftmq.ms.artemis.filter.Expression;
import com.swiftmq.ms.artemis.filter.FilterException;
import com.swiftmq.ms.artemis.filter.Filterable;
import com.swiftmq.ms.artemis.util.SimpleString;

public class PropertyExpression
implements Expression {
    private final SimpleString name;

    public PropertyExpression(String name) {
        this(SimpleString.toSimpleString(name));
    }

    public PropertyExpression(SimpleString name) {
        this.name = name;
    }

    @Override
    public Object evaluate(Filterable message) throws FilterException {
        return message.getProperty(this.name);
    }

    public String getName() {
        return this.name.toString();
    }

    public String toString() {
        return this.name.toString();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.name.equals(((PropertyExpression)o).name);
    }
}

