/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.ms.artemis.impl;

import com.swiftmq.ms.artemis.filter.BooleanExpression;
import com.swiftmq.ms.artemis.filter.ComparisonExpression;
import com.swiftmq.ms.artemis.filter.FilterException;
import com.swiftmq.ms.artemis.hyphenated.HyphenatedParser;
import com.swiftmq.ms.artemis.strict.StrictParser;
import java.io.StringReader;

public class SelectorParser {
    private static final String CONVERT_STRING_EXPRESSIONS_PREFIX = "convert_string_expressions:";
    private static final String HYPHENATED_PROPS_PREFIX = "hyphenated_props:";
    private static final String NO_CONVERT_STRING_EXPRESSIONS_PREFIX = "no_convert_string_expressions:";
    private static final String NO_HYPHENATED_PROPS_PREFIX = "no_hyphenated_props:";

    public static BooleanExpression parse(String sql) throws FilterException {
        String actual = sql;
        boolean convertStringExpressions = false;
        boolean hyphenatedProps = false;
        while (true) {
            if (actual.startsWith(CONVERT_STRING_EXPRESSIONS_PREFIX)) {
                convertStringExpressions = true;
                actual = actual.substring(CONVERT_STRING_EXPRESSIONS_PREFIX.length());
                continue;
            }
            if (actual.startsWith(HYPHENATED_PROPS_PREFIX)) {
                hyphenatedProps = true;
                actual = actual.substring(HYPHENATED_PROPS_PREFIX.length());
                continue;
            }
            if (actual.startsWith(NO_CONVERT_STRING_EXPRESSIONS_PREFIX)) {
                convertStringExpressions = false;
                actual = actual.substring(NO_CONVERT_STRING_EXPRESSIONS_PREFIX.length());
                continue;
            }
            if (!actual.startsWith(NO_HYPHENATED_PROPS_PREFIX)) break;
            hyphenatedProps = false;
            actual = actual.substring(NO_HYPHENATED_PROPS_PREFIX.length());
        }
        if (convertStringExpressions) {
            ComparisonExpression.CONVERT_STRING_EXPRESSIONS.set(true);
        }
        try {
            Object parser;
            BooleanExpression e = null;
            if (hyphenatedProps) {
                parser = new HyphenatedParser(new StringReader(actual));
                e = ((HyphenatedParser)parser).JmsSelector();
            } else {
                parser = new StrictParser(new StringReader(actual));
                e = ((StrictParser)parser).JmsSelector();
            }
            parser = e;
            return parser;
        }
        catch (Throwable e) {
            FilterException fe = new FilterException(actual, e);
            throw fe;
        }
        finally {
            if (convertStringExpressions) {
                ComparisonExpression.CONVERT_STRING_EXPRESSIONS.remove();
            }
        }
    }
}

