/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.ms.artemis.util;

import com.swiftmq.ms.artemis.util.ByteUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SimpleString
implements CharSequence,
Serializable,
Comparable<SimpleString> {
    private static final SimpleString EMPTY = new SimpleString("");
    private static final long serialVersionUID = 4204223851422244307L;
    private final byte[] data;
    private transient int hash;
    private transient String str;

    public static SimpleString toSimpleString(String string) {
        if (string == null) {
            return null;
        }
        return new SimpleString(string);
    }

    public SimpleString(String string) {
        int len = string.length();
        this.data = new byte[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            byte low = (byte)(c & 0xFF);
            this.data[j++] = low;
            byte high = (byte)(c >> 8 & 0xFF);
            this.data[j++] = high;
        }
        this.str = string;
    }

    public SimpleString(byte[] data) {
        this.data = data;
    }

    public SimpleString(char c) {
        byte high;
        byte low;
        this.data = new byte[2];
        this.data[0] = low = (byte)(c & 0xFF);
        this.data[1] = high = (byte)(c >> 8 & 0xFF);
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public int length() {
        return this.data.length >> 1;
    }

    @Override
    public char charAt(int pos) {
        if (pos < 0 || pos >= this.data.length >> 1) {
            throw new IndexOutOfBoundsException();
        }
        return (char)(this.data[pos <<= 1] & 0xFF | this.data[pos + 1] << 8 & 0xFF00);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.subSeq(start, end);
    }

    public SimpleString subSeq(int start, int end) {
        int len = this.data.length >> 1;
        if (end < start || start < 0 || end > len) {
            throw new IndexOutOfBoundsException();
        }
        int newlen = end - start << 1;
        byte[] bytes = new byte[newlen];
        System.arraycopy(this.data, start << 1, bytes, 0, newlen);
        return new SimpleString(bytes);
    }

    @Override
    public int compareTo(SimpleString o) {
        return this.toString().compareTo(o.toString());
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean startsWith(SimpleString other) {
        byte[] otherdata = other.data;
        if (otherdata.length > this.data.length) {
            return false;
        }
        for (int i = 0; i < otherdata.length; ++i) {
            if (this.data[i] == otherdata[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.str == null) {
            int len = this.data.length >> 1;
            char[] chars = new char[len];
            int j = 0;
            for (int i = 0; i < len; ++i) {
                int low = this.data[j++] & 0xFF;
                int high = this.data[j++] << 8 & 0xFF00;
                chars[i] = (char)(low | high);
            }
            this.str = new String(chars);
        }
        return this.str;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SimpleString) {
            SimpleString s = (SimpleString)other;
            return ByteUtil.equals(this.data, s.data);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int tmphash = 0;
            for (byte element : this.data) {
                tmphash = (tmphash << 5) - tmphash + element;
            }
            this.hash = tmphash;
        }
        return this.hash;
    }

    public SimpleString[] split(char delim) {
        if (this.str != null) {
            return SimpleString.splitWithCachedString(this, delim);
        }
        return this.splitWithoutCachedString(delim);
    }

    private SimpleString[] splitWithoutCachedString(char delim) {
        ArrayList<SimpleString> all = null;
        byte low = (byte)(delim & 0xFF);
        byte high = (byte)(delim >> 8 & 0xFF);
        int lasPos = 0;
        int i = 0;
        while (i + 1 < this.data.length) {
            if (this.data[i] == low && this.data[i + 1] == high) {
                byte[] bytes = new byte[i - lasPos];
                System.arraycopy(this.data, lasPos, bytes, 0, bytes.length);
                lasPos = i + 2;
                if (all == null) {
                    all = new ArrayList<SimpleString>(2);
                }
                all.add(new SimpleString(bytes));
            }
            i += 2;
        }
        if (all == null) {
            return new SimpleString[]{this};
        }
        byte[] bytes = new byte[this.data.length - lasPos];
        System.arraycopy(this.data, lasPos, bytes, 0, bytes.length);
        all.add(new SimpleString(bytes));
        SimpleString[] parts = new SimpleString[all.size()];
        return all.toArray(parts);
    }

    private static SimpleString[] splitWithCachedString(SimpleString simpleString, int delim) {
        int delimIndex;
        String str = simpleString.str;
        byte[] data = simpleString.data;
        int length = str.length();
        List<SimpleString> all = null;
        int index = 0;
        while (index < length && (delimIndex = str.indexOf(delim, index)) != -1) {
            all = SimpleString.addSimpleStringPart(all, data, index, delimIndex);
            index = delimIndex + 1;
        }
        if (all == null) {
            return new SimpleString[]{simpleString};
        }
        all = SimpleString.addSimpleStringPart(all, data, index, length);
        SimpleString[] parts = new SimpleString[all.size()];
        return all.toArray(parts);
    }

    private static List<SimpleString> addSimpleStringPart(List<SimpleString> all, byte[] data, int startIndex, int endIndex) {
        SimpleString ss;
        int expectedLength = endIndex - startIndex;
        if (expectedLength == 0) {
            ss = EMPTY;
        } else {
            int ssIndex = startIndex << 1;
            int delIndex = endIndex << 1;
            byte[] bytes = Arrays.copyOfRange(data, ssIndex, delIndex);
            ss = new SimpleString(bytes);
        }
        if (all == null) {
            all = new ArrayList<SimpleString>(3);
        }
        all.add(ss);
        return all;
    }

    public boolean contains(char c) {
        if (this.str != null) {
            return this.str.indexOf(c) != -1;
        }
        byte low = (byte)(c & 0xFF);
        byte high = (byte)(c >> 8 & 0xFF);
        int i = 0;
        while (i + 1 < this.data.length) {
            if (this.data[i] == low && this.data[i + 1] == high) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public SimpleString concat(String toAdd) {
        int len = toAdd.length();
        byte[] bytes = new byte[this.data.length + len * 2];
        System.arraycopy(this.data, 0, bytes, 0, this.data.length);
        for (int i = 0; i < len; ++i) {
            char c = toAdd.charAt(i);
            int offset = this.data.length + i * 2;
            bytes[offset] = (byte)(c & 0xFF);
            bytes[offset + 1] = (byte)(c >> 8 & 0xFF);
        }
        return new SimpleString(bytes);
    }

    public SimpleString concat(SimpleString toAdd) {
        byte[] bytes = new byte[this.data.length + toAdd.getData().length];
        System.arraycopy(this.data, 0, bytes, 0, this.data.length);
        System.arraycopy(toAdd.getData(), 0, bytes, this.data.length, toAdd.getData().length);
        return new SimpleString(bytes);
    }

    public SimpleString concat(char c) {
        byte[] bytes = new byte[this.data.length + 2];
        System.arraycopy(this.data, 0, bytes, 0, this.data.length);
        bytes[this.data.length] = (byte)(c & 0xFF);
        bytes[this.data.length + 1] = (byte)(c >> 8 & 0xFF);
        return new SimpleString(bytes);
    }

    public int sizeof() {
        return 4 + this.data.length;
    }

    public static int sizeofString(SimpleString str) {
        return str.sizeof();
    }

    public static int sizeofNullableString(SimpleString str) {
        if (str == null) {
            return 1;
        }
        return 1 + str.sizeof();
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstPos) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.length()) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        int j = srcBegin * 2;
        int d = dstPos;
        for (int i = srcBegin; i < srcEnd; ++i) {
            int low = this.data[j++] & 0xFF;
            int high = this.data[j++] << 8 & 0xFF00;
            dst[d++] = (char)(low | high);
        }
    }
}

