/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net;

import com.swiftmq.net.HttpTunnelProperties;
import com.swiftmq.net.SocketFactory;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.prop.SystemProperties;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class JSSESocketFactory
implements SocketFactory,
Serializable {
    static final int SO_TIMEOUT = Integer.parseInt(SystemProperties.get("swiftmq.socket.sotimeout", "0"));

    protected static SSLSocketFactory getSocketFactory() throws IOException {
        SSLSocketFactory ssf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        return ssf;
    }

    protected static ServerSocketFactory getServerSocketFactory() throws IOException {
        SSLServerSocketFactory ssf = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        return ssf;
    }

    @Override
    public Socket createSocket(String host, int port, boolean useTcpNoDelay) throws UnknownHostException, IOException {
        SSLSocket sslSocket = null;
        if (HttpTunnelProperties.getInstance().isProxy() && HttpTunnelProperties.getInstance().isHostViaProxy(host)) {
            Socket socket = new Socket(HttpTunnelProperties.getInstance().getProxyHost(), HttpTunnelProperties.getInstance().getProxyPort());
            HttpTunnelProperties.getInstance().setupHttpProxy(host, port, socket.getInputStream(), socket.getOutputStream());
            sslSocket = (SSLSocket)JSSESocketFactory.getSocketFactory().createSocket(socket, host, port, true);
        } else {
            sslSocket = (SSLSocket)JSSESocketFactory.getSocketFactory().createSocket(host, port);
        }
        if (SO_TIMEOUT > 0) {
            try {
                sslSocket.setSoTimeout(SO_TIMEOUT);
            }
            catch (SocketException e) {
                System.err.println("JSSESocketFactory: Unable to perform 'socket.setSoTimeout(" + SO_TIMEOUT + ")', exception: " + e);
            }
        }
        sslSocket.setTcpNoDelay(useTcpNoDelay);
        Semaphore sem = new Semaphore();
        sslSocket.addHandshakeCompletedListener(new CompletionListener(sem));
        sslSocket.startHandshake();
        sem.waitHere();
        return sslSocket;
    }

    @Override
    public Socket createSocket(String host, int port) throws UnknownHostException, IOException {
        return this.createSocket(host, port, true);
    }

    @Override
    public Socket createSocket(InetAddress addr, int port, boolean useTcpNoDelay) throws UnknownHostException, IOException {
        SSLSocket sslSocket = null;
        if (HttpTunnelProperties.getInstance().isProxy() && HttpTunnelProperties.getInstance().isHostViaProxy(addr.getHostName())) {
            Socket socket = new Socket(HttpTunnelProperties.getInstance().getProxyHost(), HttpTunnelProperties.getInstance().getProxyPort());
            HttpTunnelProperties.getInstance().setupHttpProxy(addr.getHostName(), port, socket.getInputStream(), socket.getOutputStream());
            sslSocket = (SSLSocket)JSSESocketFactory.getSocketFactory().createSocket(socket, addr.getHostName(), port, true);
        } else {
            sslSocket = (SSLSocket)JSSESocketFactory.getSocketFactory().createSocket(addr, port);
        }
        if (SO_TIMEOUT > 0) {
            try {
                sslSocket.setSoTimeout(SO_TIMEOUT);
            }
            catch (SocketException e) {
                System.err.println("JSSESocketFactory: Unable to perform 'socket.setSoTimeout(" + SO_TIMEOUT + ")', exception: " + e);
            }
        }
        sslSocket.setTcpNoDelay(useTcpNoDelay);
        Semaphore sem = new Semaphore();
        sslSocket.addHandshakeCompletedListener(new CompletionListener(sem));
        sslSocket.startHandshake();
        sem.waitHere();
        return sslSocket;
    }

    @Override
    public Socket createSocket(InetAddress addr, int port) throws IOException {
        return this.createSocket(addr, port, true);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)JSSESocketFactory.getServerSocketFactory().createServerSocket(port);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)JSSESocketFactory.getServerSocketFactory().createServerSocket(port, backlog);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)JSSESocketFactory.getServerSocketFactory().createServerSocket(port, backlog, bindAddr);
        return socket;
    }

    private class CompletionListener
    implements HandshakeCompletedListener {
        Semaphore sem = null;

        CompletionListener(Semaphore sem) {
            this.sem = sem;
        }

        @Override
        public void handshakeCompleted(HandshakeCompletedEvent event) {
            this.sem.notifySingleWaiter();
        }
    }
}

