/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net;

import com.swiftmq.net.HttpTunnelProperties;
import com.swiftmq.net.SocketFactory2;
import com.swiftmq.tools.prop.SystemProperties;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class PlainSocketFactory
implements SocketFactory2,
Serializable {
    static final boolean SET_SOCKET_OPTIONS = Boolean.valueOf(SystemProperties.get("swiftmq.socket.set.options", "true"));
    static final boolean SET_REUSE_ADDRESS = Boolean.valueOf(SystemProperties.get("swiftmq.socket.set.reuseaddress", "false"));
    static final int MAX_RCVBUFSIZE = Integer.parseInt(SystemProperties.get("swiftmq.socket.max.receivebuffersize", "0"));
    static final int CONNECT_TIMEOUT = Integer.parseInt(SystemProperties.get("swiftmq.socket.connect.timeout", "5000"));
    int rcvBufSize = -1;

    @Override
    public void setReceiveBufferSize(int size) {
        if (SET_SOCKET_OPTIONS) {
            this.rcvBufSize = MAX_RCVBUFSIZE > 0 ? Math.min(size, MAX_RCVBUFSIZE) : size;
        }
    }

    private Socket _createSocket(String host, int port) throws IOException {
        Socket socket = null;
        if (this.rcvBufSize == -1) {
            socket = new Socket(host, port);
        } else {
            socket = new Socket();
            try {
                socket.setReceiveBufferSize(this.rcvBufSize);
            }
            catch (SocketException e) {
                System.err.println("Unable to set socket receive buffer size to: " + this.rcvBufSize);
            }
            if (SET_REUSE_ADDRESS) {
                socket.setReuseAddress(true);
            }
            if (CONNECT_TIMEOUT > 0) {
                socket.connect(new InetSocketAddress(host, port), CONNECT_TIMEOUT);
            } else {
                socket.connect(new InetSocketAddress(host, port));
            }
        }
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, boolean useTcpNoDelay) throws UnknownHostException, IOException {
        Socket socket = null;
        if (HttpTunnelProperties.getInstance().isProxy() && HttpTunnelProperties.getInstance().isHostViaProxy(host)) {
            socket = this._createSocket(HttpTunnelProperties.getInstance().getProxyHost(), HttpTunnelProperties.getInstance().getProxyPort());
            HttpTunnelProperties.getInstance().setupHttpProxy(host, port, socket.getInputStream(), socket.getOutputStream());
        } else {
            socket = this._createSocket(host, port);
        }
        try {
            socket.setTcpNoDelay(useTcpNoDelay);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws UnknownHostException, IOException {
        return this.createSocket(host, port, true);
    }

    @Override
    public Socket createSocket(InetAddress addr, int port, boolean useTcpNoDelay) throws UnknownHostException, IOException {
        Socket socket = null;
        if (HttpTunnelProperties.getInstance().isProxy() && HttpTunnelProperties.getInstance().isHostViaProxy(addr.getHostName())) {
            socket = this._createSocket(HttpTunnelProperties.getInstance().getProxyHost(), HttpTunnelProperties.getInstance().getProxyPort());
            HttpTunnelProperties.getInstance().setupHttpProxy(addr.getHostName(), port, socket.getInputStream(), socket.getOutputStream());
        } else {
            socket = this._createSocket(addr.getHostName(), port);
        }
        try {
            socket.setTcpNoDelay(useTcpNoDelay);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress addr, int port) throws UnknownHostException, IOException {
        return this.createSocket(addr, port, true);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket ss = null;
        if (this.rcvBufSize == -1) {
            ss = new ServerSocket(port);
        } else {
            ss = new ServerSocket();
            try {
                ss.setReceiveBufferSize(this.rcvBufSize);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            if (SET_REUSE_ADDRESS) {
                ss.setReuseAddress(true);
            }
            ss.bind(new InetSocketAddress(port));
        }
        return ss;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        ServerSocket ss = null;
        if (this.rcvBufSize == -1) {
            ss = new ServerSocket(port, backlog);
        } else {
            ss = new ServerSocket();
            try {
                ss.setReceiveBufferSize(this.rcvBufSize);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            if (SET_REUSE_ADDRESS) {
                ss.setReuseAddress(true);
            }
            ss.bind(new InetSocketAddress(port), backlog);
        }
        return ss;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        ServerSocket ss = null;
        if (this.rcvBufSize == -1) {
            ss = new ServerSocket(port, backlog, bindAddr);
        } else {
            ss = new ServerSocket();
            try {
                ss.setReceiveBufferSize(this.rcvBufSize);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            if (SET_REUSE_ADDRESS) {
                ss.setReuseAddress(true);
            }
            ss.bind(new InetSocketAddress(bindAddr, port), backlog);
        }
        return ss;
    }
}

