/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net.protocol.raw;

import com.swiftmq.net.protocol.ProtocolOutputHandler;

public class RawOutputHandler
extends ProtocolOutputHandler {
    static final int BUFFER_SIZE = 131072;
    static final int EXTEND_SIZE = 65536;
    int bufferSize = 131072;
    int extendSize = 65536;
    byte[] currentInput = null;
    int inputLength = 0;
    byte[] currentOutput = null;
    int outputOffset = 0;
    int outputLength = 0;
    int chunkCount = 0;

    public RawOutputHandler(int bufferSize, int extendSize) {
        this.bufferSize = bufferSize;
        this.extendSize = extendSize;
    }

    public RawOutputHandler() {
        this(131072, 65536);
    }

    private void ensureInput(int size) {
        if (this.currentInput == null) {
            this.currentInput = new byte[Math.max(this.bufferSize, size)];
            this.inputLength = 0;
        } else if (this.currentInput.length - this.inputLength < size) {
            byte[] b = new byte[Math.max(this.extendSize, size + this.inputLength)];
            System.arraycopy(this.currentInput, 0, b, 0, this.inputLength);
            this.currentInput = b;
        }
    }

    @Override
    public ProtocolOutputHandler create() {
        return new RawOutputHandler();
    }

    @Override
    public ProtocolOutputHandler create(int bufferSize, int extendSize) {
        return new RawOutputHandler(bufferSize, extendSize);
    }

    @Override
    public int getChunkCount() {
        return this.chunkCount;
    }

    @Override
    protected byte[] getByteArray() {
        if (this.currentOutput == null) {
            this.currentOutput = this.currentInput;
            this.outputOffset = 0;
            this.outputLength = this.inputLength;
        }
        return this.currentOutput;
    }

    @Override
    protected int getOffset() {
        return this.outputOffset;
    }

    @Override
    protected int getLength() {
        return this.outputLength - this.outputOffset;
    }

    @Override
    protected void setBytesWritten(int written) {
        this.outputOffset += written;
        if (this.outputOffset == this.outputLength) {
            this.currentOutput = null;
            this.outputOffset = 0;
            this.outputLength = 0;
            this.inputLength = 0;
            this.chunkCount = 0;
        }
    }

    @Override
    protected void addByte(byte b) {
        this.ensureInput(1);
        this.currentInput[this.inputLength++] = b;
    }

    @Override
    protected void addBytes(byte[] b, int offset, int len) {
        this.ensureInput(len);
        System.arraycopy(b, offset, this.currentInput, this.inputLength, len);
        this.inputLength += len;
    }

    @Override
    protected void markChunkCompleted() {
        this.chunkCount = 1;
    }

    public String toString() {
        return "[RawOutputHandler]";
    }
}

