/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net.protocol.smqp;

import com.swiftmq.net.protocol.ChunkListener;
import com.swiftmq.net.protocol.ProtocolInputHandler;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SMQPInputHandler
implements ProtocolInputHandler {
    static final boolean debug = Boolean.valueOf(System.getProperty("swiftmq.smqp.handler.debug", "false"));
    static final SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy-HH:mm:ss.SSS");
    ChunkListener listener = null;
    int initialSize = 0;
    int ensureSize = 0;
    byte[] lengthField = new byte[4];
    byte[] buffer = null;
    ByteBuffer byteBuffer = null;
    int bufferOffset = 0;
    boolean lengthComplete = false;
    int lengthByteCount = 0;
    int chunkMissed = 0;
    int chunkLength = 0;
    int chunkStart = 0;
    int lengthFieldPos = 0;
    long gclen = 0L;

    @Override
    public ProtocolInputHandler create() {
        return new SMQPInputHandler();
    }

    @Override
    public void setChunkListener(ChunkListener listener) {
        this.listener = listener;
    }

    @Override
    public void createInputBuffer(int initialSize, int ensureSize) {
        this.initialSize = initialSize;
        this.ensureSize = ensureSize;
        this.buffer = new byte[initialSize];
        this.byteBuffer = ByteBuffer.wrap(this.buffer);
        if (debug) {
            System.out.println(format.format(new Date()) + "/" + super.toString() + ", createInputBuffer, len=" + this.buffer.length);
        }
    }

    @Override
    public ByteBuffer getByteBuffer() {
        this.getBuffer();
        this.byteBuffer.position(this.bufferOffset);
        return this.byteBuffer;
    }

    @Override
    public byte[] getBuffer() {
        if (this.buffer.length - this.bufferOffset < this.ensureSize) {
            this.gclen += (long)this.buffer.length;
            byte[] b = new byte[this.buffer.length + this.ensureSize];
            System.arraycopy(this.buffer, 0, b, 0, this.bufferOffset);
            this.buffer = b;
            this.byteBuffer = ByteBuffer.wrap(this.buffer);
            if (debug) {
                System.out.println(format.format(new Date()) + "/" + super.toString() + ", extend buffer, gced=" + this.gclen + ", len=" + this.buffer.length);
            }
        }
        return this.buffer;
    }

    @Override
    public int getOffset() {
        return this.bufferOffset;
    }

    private int readLength(byte[] b, int offset) {
        int i1 = b[offset] & 0xFF;
        int i2 = b[offset + 1] & 0xFF;
        int i3 = b[offset + 2] & 0xFF;
        int i4 = b[offset + 3] & 0xFF;
        int i = (i1 << 24) + (i2 << 16) + (i3 << 8) + (i4 << 0);
        return i;
    }

    @Override
    public void setBytesWritten(int written) {
        if (this.lengthComplete) {
            if (written >= this.chunkMissed) {
                this.listener.chunkCompleted(this.buffer, this.chunkStart, this.chunkLength);
                this.bufferOffset += this.chunkMissed;
                this.lengthComplete = false;
                this.lengthByteCount = 0;
                this.chunkMissed = 0;
                if ((written -= this.chunkMissed) > 0) {
                    this.lengthFieldPos = this.chunkStart + this.chunkLength;
                    this.setBytesWritten(written);
                } else {
                    this.bufferOffset = 0;
                    this.lengthFieldPos = 0;
                }
            } else {
                this.bufferOffset += written;
                this.chunkMissed -= written;
            }
        } else if (this.lengthByteCount + written >= 4) {
            int rest = 4 - this.lengthByteCount;
            this.chunkLength = this.readLength(this.buffer, this.lengthFieldPos);
            this.bufferOffset += rest;
            this.chunkStart = this.bufferOffset;
            this.chunkMissed = this.chunkLength;
            this.lengthByteCount = 4;
            this.lengthComplete = true;
            if ((written -= rest) > 0) {
                this.setBytesWritten(written);
            }
        } else {
            this.bufferOffset += written;
            this.lengthByteCount += written;
        }
    }

    public String toString() {
        return "[SMQPInputHandler]";
    }
}

