/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.net.protocol.smqp;

import com.swiftmq.net.protocol.ProtocolOutputHandler;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SMQPOutputHandler
extends ProtocolOutputHandler {
    static final int BUFFER_SIZE = 131072;
    static final int EXTEND_SIZE = 65536;
    static final boolean DEBUG = Boolean.valueOf(System.getProperty("swiftmq.smqp.handler.debug", "false"));
    static final boolean USE_THREAD_LOCAL = Boolean.valueOf(System.getProperty("swiftmq.smqp.handler.buffer.threadlocal", "true"));
    static final SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy-HH:mm:ss.SSS");
    static ThreadLocal bufferHolder = USE_THREAD_LOCAL ? new ThreadLocal() : null;
    int bufferSize = 131072;
    int extendSize = 65536;
    byte[] currentInput = null;
    int inputLength = 0;
    byte[] currentOutput = null;
    int outputOffset = 0;
    int outputLength = 0;
    int chunkCount = 0;
    long gclen = 0L;

    public SMQPOutputHandler(int bufferSize, int extendSize) {
        this.bufferSize = bufferSize;
        this.extendSize = extendSize;
    }

    public SMQPOutputHandler() {
        this(131072, 65536);
    }

    private int readLength(byte[] b) {
        int i1 = b[0] & 0xFF;
        int i2 = b[1] & 0xFF;
        int i3 = b[2] & 0xFF;
        int i4 = b[3] & 0xFF;
        int i = (i1 << 24) + (i2 << 16) + (i3 << 8) + (i4 << 0);
        return i;
    }

    private void writeLength(byte[] b, int length) {
        b[0] = (byte)(length >>> 24 & 0xFF);
        b[1] = (byte)(length >>> 16 & 0xFF);
        b[2] = (byte)(length >>> 8 & 0xFF);
        b[3] = (byte)(length >>> 0 & 0xFF);
    }

    private void ensureInput(int size) {
        if (this.currentInput == null) {
            byte[] b;
            byte[] byArray = b = bufferHolder != null ? (byte[])bufferHolder.get() : null;
            if (b == null) {
                this.currentInput = new byte[Math.max(this.bufferSize, size)];
                if (DEBUG) {
                    System.out.println(format.format(new Date()) + "/" + super.toString() + ", create buffer, len=" + this.currentInput.length);
                }
            } else {
                if (DEBUG) {
                    System.out.println(format.format(new Date()) + "/" + super.toString() + ", got buffer " + b + ", len=" + b.length + " from bufferHolder of thread: " + Thread.currentThread());
                }
                this.currentInput = b;
            }
            this.inputLength = 4;
        } else if (this.currentInput.length - this.inputLength < size) {
            this.gclen += (long)this.currentInput.length;
            byte[] b = new byte[Math.max(this.currentInput.length + this.extendSize, size + this.inputLength)];
            System.arraycopy(this.currentInput, 0, b, 0, this.inputLength);
            this.currentInput = b;
            if (DEBUG) {
                System.out.println(format.format(new Date()) + "/" + super.toString() + ", extend buffer, gced=" + this.gclen + ", len=" + this.currentInput.length);
            }
        }
    }

    @Override
    public ProtocolOutputHandler create() {
        return new SMQPOutputHandler();
    }

    @Override
    public ProtocolOutputHandler create(int bufferSize, int extendSize) {
        return new SMQPOutputHandler(bufferSize, extendSize);
    }

    @Override
    public int getChunkCount() {
        return this.chunkCount;
    }

    @Override
    protected byte[] getByteArray() {
        if (this.currentOutput == null) {
            this.currentOutput = this.currentInput;
            this.outputOffset = 0;
            this.outputLength = this.inputLength;
        }
        return this.currentOutput;
    }

    @Override
    protected int getOffset() {
        return this.outputOffset;
    }

    @Override
    protected int getLength() {
        return this.outputLength - this.outputOffset;
    }

    @Override
    protected void setBytesWritten(int written) {
        this.outputOffset += written;
        if (this.outputOffset == this.outputLength) {
            this.currentOutput = null;
            this.outputOffset = 0;
            this.outputLength = 0;
            this.inputLength = 4;
            this.chunkCount = 0;
            if (bufferHolder != null) {
                if (DEBUG) {
                    System.out.println(format.format(new Date()) + "/" + super.toString() + ", buffer " + this.currentInput + ", len=" + this.currentInput.length + " stored in bufferHolder of thread: " + Thread.currentThread());
                }
                bufferHolder.set(this.currentInput);
                this.currentInput = null;
            }
        }
    }

    @Override
    protected void addByte(byte b) {
        this.ensureInput(1);
        this.currentInput[this.inputLength++] = b;
    }

    @Override
    protected void addBytes(byte[] b, int offset, int len) {
        this.ensureInput(len);
        System.arraycopy(b, offset, this.currentInput, this.inputLength, len);
        this.inputLength += len;
    }

    @Override
    protected void markChunkCompleted() {
        this.writeLength(this.currentInput, this.inputLength - 4);
        this.chunkCount = 1;
    }

    public String toString() {
        return "[SMQPOutputHandler]";
    }
}

