/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.streamrepo;

import com.swiftmq.amqp.AMQPContext;
import com.swiftmq.amqp.v100.client.Connection;
import com.swiftmq.amqp.v100.client.Consumer;
import com.swiftmq.amqp.v100.client.Producer;
import com.swiftmq.amqp.v100.client.Session;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AddressIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AmqpValue;
import com.swiftmq.amqp.v100.generated.messaging.message_format.ApplicationProperties;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Properties;
import com.swiftmq.amqp.v100.messaging.AMQPMessage;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.amqp.v100.types.AMQPMap;
import com.swiftmq.amqp.v100.types.AMQPString;
import com.swiftmq.net.JSSESocketFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class AMQPRepo {
    static final String REPOQUEUE = "streamrepo";
    static final long TIMEOUT = 30000L;
    static final String Q_MECHANISM = "mechanism";
    static final String Q_MAXFRAMESIZE = "maxframesize";
    static final String Q_IDLETIMEOUT = "idletimeout";
    Connection connection;
    Session session;
    Producer producer;
    Consumer consumer;
    AddressIF replyQueue;
    String routername;

    AMQPRepo(String url, String username, String password, String routername) throws Exception {
        this.routername = routername;
        try {
            this.connect(url, username, password);
            this.session = this.connection.createSession(100L, 100L);
            this.producer = this.session.createProducer("streamrepo@" + routername, 0);
            this.consumer = this.session.createConsumer(100, 0);
            this.replyQueue = this.consumer.getRemoteAddress();
        }
        catch (Exception e) {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static void main(String[] args) {
        if (args.length < 6) {
            System.err.println("Usage: repo <amqp-url> <username> <password> <routername> add|remove|list <reponame> [<streamfile>|(<streamdir> <extension>)]");
            System.exit(-1);
        }
        String url = args[0];
        String username = args[1];
        String password = args[2];
        String routername = args[3];
        String operation = args[4];
        if (!(operation.equals("add") || operation.equals("remove") || operation.equals("list"))) {
            System.err.println("Operation must be: 'add', 'remove' or 'list'.");
            System.exit(-1);
        }
        String appname = args[5];
        try {
            if (operation.equals("add")) {
                String filename;
                File file;
                if (args.length < 7) {
                    System.err.println("Missing: [<streamfile>|(<streamdir> <extension>)]");
                    System.exit(-1);
                }
                if (!(file = new File(filename = args[6])).exists()) {
                    System.err.println("File or directory '" + filename + "' does not exists.");
                    System.exit(-1);
                }
                if (file.isDirectory()) {
                    if (args.length != 8) {
                        System.err.println("Missing '<extension>', e.g. '.js'.");
                        System.exit(-1);
                    }
                    String extension = args[7];
                    new AMQPRepo(url, username, password, routername).addDir(file, extension, appname).close();
                } else {
                    new AMQPRepo(url, username, password, routername).add(file, appname).close();
                }
            } else if (operation.equals("remove")) {
                if (args.length == 6) {
                    new AMQPRepo(url, username, password, routername).remove(appname).close();
                } else {
                    String filename = args[6];
                    File file = new File(filename);
                    if (!file.exists()) {
                        System.err.println("File or directory '" + filename + "' does not exists.");
                        System.exit(-1);
                    }
                    if (file.isDirectory()) {
                        if (args.length != 8) {
                            System.err.println("Missing '<extension>', e.g. '.js'.");
                            System.exit(-1);
                        }
                        String extension = args[7];
                        new AMQPRepo(url, username, password, routername).removeDir(file, extension, appname).close();
                    } else {
                        new AMQPRepo(url, username, password, routername).remove(file, appname).close();
                    }
                }
            } else {
                new AMQPRepo(url, username, password, routername).list(appname).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    private Map<String, String> getQueryMap(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    public void connect(String urlString, String username, String password) throws Exception {
        String query;
        int port;
        URL url = new URL(urlString.replaceFirst("amqp:", "http:").replaceFirst("amqps:", "https:"));
        String hostname = url.getHost();
        if (hostname == null) {
            hostname = "localhost";
        }
        if ((port = url.getPort()) == -1) {
            port = urlString.startsWith("amqps:") ? 5671 : 5672;
        }
        AMQPContext ctx = new AMQPContext(0);
        this.connection = username == null || username.trim().length() == 0 ? new Connection(ctx, hostname, port, true) : new Connection(ctx, hostname, port, username, password);
        if (urlString.startsWith("amqps:")) {
            this.connection.setSocketFactory(new JSSESocketFactory());
        }
        if ((query = url.getQuery()) != null) {
            Map<String, String> queryMap = this.getQueryMap(query);
            String v = queryMap.get(Q_MECHANISM);
            if (v != null) {
                this.connection.setMechanism(v);
            }
            if ((v = queryMap.get(Q_MAXFRAMESIZE)) != null) {
                this.connection.setMaxFrameSize(Long.parseLong(v));
            }
            if ((v = queryMap.get(Q_IDLETIMEOUT)) != null) {
                this.connection.setIdleTimeout(Long.parseLong(v));
            }
        }
        this.connection.connect();
    }

    private String loadFile(File f) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        char[] buffer = new char[(int)f.length()];
        reader.read(buffer);
        reader.close();
        return new String(buffer);
    }

    AMQPRepo addDir(File dir, final String extension, String appname) throws Exception {
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            this.add(files[i], appname);
        }
        return this;
    }

    AMQPRepo add(File file, String appname) throws Exception {
        String filename = file.getName();
        String content = this.loadFile(file);
        AMQPMessage request = new AMQPMessage();
        HashMap<AMQPString, AMQPString> propMap = new HashMap<AMQPString, AMQPString>();
        propMap.put(new AMQPString("app"), new AMQPString(appname));
        propMap.put(new AMQPString("file"), new AMQPString(filename));
        propMap.put(new AMQPString("operation"), new AMQPString("add"));
        request.setApplicationProperties(new ApplicationProperties(propMap));
        Properties properties = new Properties();
        properties.setReplyTo(this.replyQueue);
        request.setProperties(properties);
        request.setAmqpValue(new AmqpValue(new AMQPString(content)));
        this.producer.send(request);
        AMQPMessage reply = this.consumer.receive(30000L);
        if (reply == null) {
            throw new Exception("Timeout occurred while waiting for a reply!");
        }
        AMQPMap body = (AMQPMap)reply.getAmqpValue().getValue();
        boolean success = ((AMQPBoolean)body.getValue().get(new AMQPString("success"))).getValue();
        if (success) {
            System.out.println(filename + " added to repository " + appname);
        } else {
            String result = ((AMQPString)body.getValue().get(new AMQPString("result"))).getValue();
            System.out.println(result);
        }
        return this;
    }

    AMQPRepo removeDir(File dir, final String extension, String appname) throws Exception {
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            this.remove(files[i], appname);
        }
        return this;
    }

    AMQPRepo remove(File file, String appname) throws Exception {
        String filename = file.getName();
        AMQPMessage request = new AMQPMessage();
        HashMap<AMQPString, AMQPString> propMap = new HashMap<AMQPString, AMQPString>();
        propMap.put(new AMQPString("app"), new AMQPString(appname));
        propMap.put(new AMQPString("file"), new AMQPString(filename));
        propMap.put(new AMQPString("operation"), new AMQPString("remove"));
        request.setApplicationProperties(new ApplicationProperties(propMap));
        Properties properties = new Properties();
        properties.setReplyTo(this.replyQueue);
        request.setProperties(properties);
        this.producer.send(request);
        AMQPMessage reply = this.consumer.receive(30000L);
        if (reply == null) {
            throw new Exception("Timeout occurred while waiting for a reply!");
        }
        AMQPMap body = (AMQPMap)reply.getAmqpValue().getValue();
        boolean success = ((AMQPBoolean)body.getValue().get(new AMQPString("success"))).getValue();
        if (success) {
            System.out.println(filename + " removed from repository " + appname);
        } else {
            String result = ((AMQPString)body.getValue().get(new AMQPString("result"))).getValue();
            System.out.println(result);
        }
        return this;
    }

    AMQPRepo remove(String appname) throws Exception {
        AMQPMessage request = new AMQPMessage();
        HashMap<AMQPString, AMQPString> propMap = new HashMap<AMQPString, AMQPString>();
        propMap.put(new AMQPString("app"), new AMQPString(appname));
        propMap.put(new AMQPString("operation"), new AMQPString("remove"));
        request.setApplicationProperties(new ApplicationProperties(propMap));
        Properties properties = new Properties();
        properties.setReplyTo(this.replyQueue);
        request.setProperties(properties);
        this.producer.send(request);
        AMQPMessage reply = this.consumer.receive(30000L);
        if (reply == null) {
            throw new Exception("Timeout occurred while waiting for a reply!");
        }
        AMQPMap body = (AMQPMap)reply.getAmqpValue().getValue();
        boolean success = ((AMQPBoolean)body.getValue().get(new AMQPString("success"))).getValue();
        if (success) {
            System.out.println("Removed repository " + appname);
        } else {
            String result = ((AMQPString)body.getValue().get(new AMQPString("result"))).getValue();
            System.out.println(result);
        }
        return this;
    }

    AMQPRepo list(String appname) throws Exception {
        AMQPMessage request = new AMQPMessage();
        HashMap<AMQPString, AMQPString> propMap = new HashMap<AMQPString, AMQPString>();
        propMap.put(new AMQPString("app"), new AMQPString(appname));
        propMap.put(new AMQPString("operation"), new AMQPString("list"));
        request.setApplicationProperties(new ApplicationProperties(propMap));
        Properties properties = new Properties();
        properties.setReplyTo(this.replyQueue);
        request.setProperties(properties);
        this.producer.send(request);
        AMQPMessage reply = this.consumer.receive(30000L);
        if (reply == null) {
            throw new Exception("Timeout occurred while waiting for a reply!");
        }
        AMQPMap body = (AMQPMap)reply.getAmqpValue().getValue();
        boolean success = ((AMQPBoolean)body.getValue().get(new AMQPString("success"))).getValue();
        if (success) {
            System.out.println("Content of repository " + appname + ":");
            System.out.println();
            int n = Integer.parseInt(((AMQPString)body.getValue().get(new AMQPString("nfiles"))).getValue());
            for (int i = 0; i < n; ++i) {
                System.out.println(((AMQPString)body.getValue().get(new AMQPString("storetime" + i))).getValue() + "\t" + ((AMQPString)body.getValue().get(new AMQPString("file" + i))).getValue());
            }
            System.out.println();
        } else {
            String result = ((AMQPString)body.getValue().get(new AMQPString("result"))).getValue();
            System.out.println(result);
        }
        return this;
    }

    void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

