/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.streamrepo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.naming.InitialContext;

public class JMSRepo {
    static final String REPOQUEUE = "streamrepo";
    static final long TIMEOUT = 30000L;
    Connection connection;
    Session session;
    MessageProducer producer;
    MessageConsumer consumer;
    TemporaryQueue replyQueue;
    Queue repoQueue;
    String routername;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JMSRepo(String url, String cf, String username, String password, String routername) throws Exception {
        this.routername = routername;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.swiftmq.jndi.InitialContextFactoryImpl");
        env.put("java.naming.provider.url", url);
        try (InitialContext ctx = new InitialContext(env);){
            this.connection = ((ConnectionFactory)ctx.lookup(cf)).createConnection(username, password);
            this.session = this.connection.createSession(false, 1);
            this.repoQueue = this.session.createQueue("streamrepo@" + routername);
            this.producer = this.session.createProducer((Destination)this.repoQueue);
            this.replyQueue = this.session.createTemporaryQueue();
            this.consumer = this.session.createConsumer((Destination)this.replyQueue);
            this.connection.start();
        }
        catch (Exception e) {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            throw e;
        }
    }

    public static void main(String[] args) {
        if (args.length < 7) {
            System.err.println("Usage: repo <smqp-url> <connectionfactory> <username> <password> <routername> add|remove|list <reponame> [<streamfile>|(<streamdir> <extension>)]");
            System.exit(-1);
        }
        String url = args[0];
        String cf = args[1];
        String username = args[2];
        String password = args[3];
        String routername = args[4];
        String operation = args[5];
        if (!(operation.equals("add") || operation.equals("remove") || operation.equals("list"))) {
            System.err.println("Operation must be: 'add', 'remove' or 'list'.");
            System.exit(-1);
        }
        String appname = args[6];
        try {
            if (operation.equals("add")) {
                String filename;
                File file;
                if (args.length < 8) {
                    System.err.println("Missing: [<streamfile>|(<streamdir> <extension>)]");
                    System.exit(-1);
                }
                if (!(file = new File(filename = args[7])).exists()) {
                    System.err.println("File or directory '" + filename + "' does not exists.");
                    System.exit(-1);
                }
                if (file.isDirectory()) {
                    if (args.length != 9) {
                        System.err.println("Missing '<extension>', e.g. '.js'.");
                        System.exit(-1);
                    }
                    String extension = args[8];
                    new JMSRepo(url, cf, username, password, routername).addDir(file, extension, appname).close();
                } else {
                    new JMSRepo(url, cf, username, password, routername).add(file, appname).close();
                }
            } else if (operation.equals("remove")) {
                if (args.length == 7) {
                    new JMSRepo(url, cf, username, password, routername).remove(appname).close();
                } else {
                    String filename = args[7];
                    File file = new File(filename);
                    if (!file.exists()) {
                        System.err.println("File or directory '" + filename + "' does not exists.");
                        System.exit(-1);
                    }
                    if (file.isDirectory()) {
                        if (args.length != 9) {
                            System.err.println("Missing '<extension>', e.g. '.js'.");
                            System.exit(-1);
                        }
                        String extension = args[8];
                        new JMSRepo(url, cf, username, password, routername).removeDir(file, extension, appname).close();
                    } else {
                        new JMSRepo(url, cf, username, password, routername).remove(file, appname).close();
                    }
                }
            } else {
                new JMSRepo(url, cf, username, password, routername).list(appname).close();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    private String loadFile(File f) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        char[] buffer = new char[(int)f.length()];
        reader.read(buffer);
        reader.close();
        return new String(buffer);
    }

    JMSRepo addDir(File dir, final String extension, String appname) throws Exception {
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            this.add(files[i], appname);
        }
        return this;
    }

    JMSRepo add(File file, String appname) throws Exception {
        String filename = file.getName();
        String content = this.loadFile(file);
        TextMessage request = this.session.createTextMessage();
        request.setStringProperty("app", appname);
        request.setStringProperty("file", filename);
        request.setStringProperty("operation", "add");
        request.setText(content);
        request.setJMSReplyTo((Destination)this.replyQueue);
        this.producer.send((Message)request);
        MapMessage reply = (MapMessage)this.consumer.receive(30000L);
        if (reply == null) {
            throw new Exception("Timeout occurred while waiting for a reply!");
        }
        if (reply.getBoolean("success")) {
            System.out.println(filename + " added to repository " + appname);
        } else {
            System.out.println(reply.getString("result"));
        }
        return this;
    }

    JMSRepo removeDir(File dir, final String extension, String appname) throws Exception {
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            this.remove(files[i], appname);
        }
        return this;
    }

    JMSRepo remove(File file, String appname) throws Exception {
        String filename = file.getName();
        Message request = this.session.createMessage();
        request.setStringProperty("app", appname);
        request.setStringProperty("file", filename);
        request.setStringProperty("operation", "remove");
        request.setJMSReplyTo((Destination)this.replyQueue);
        this.producer.send(request);
        MapMessage reply = (MapMessage)this.consumer.receive(30000L);
        if (reply == null) {
            throw new Exception("Timeout occurred while waiting for a reply!");
        }
        if (reply.getBoolean("success")) {
            System.out.println(filename + " removed from repository " + appname);
        } else {
            System.out.println(reply.getString("result"));
        }
        return this;
    }

    JMSRepo remove(String appname) throws Exception {
        Message request = this.session.createMessage();
        request.setStringProperty("app", appname);
        request.setStringProperty("operation", "remove");
        request.setJMSReplyTo((Destination)this.replyQueue);
        this.producer.send(request);
        MapMessage reply = (MapMessage)this.consumer.receive(30000L);
        if (reply == null) {
            throw new Exception("Timeout occurred while waiting for a reply!");
        }
        if (reply.getBoolean("success")) {
            System.out.println("Removed repository " + appname);
        } else {
            System.out.println(reply.getString("result"));
        }
        return this;
    }

    JMSRepo list(String appname) throws Exception {
        Message request = this.session.createMessage();
        request.setStringProperty("app", appname);
        request.setStringProperty("operation", "list");
        request.setJMSReplyTo((Destination)this.replyQueue);
        this.producer.send(request);
        MapMessage reply = (MapMessage)this.consumer.receive(30000L);
        if (reply == null) {
            throw new Exception("Timeout occurred while waiting for a reply!");
        }
        if (reply.getBoolean("success")) {
            System.out.println("Content of repository " + appname + ":");
            System.out.println();
            int n = Integer.parseInt(reply.getString("nfiles"));
            for (int i = 0; i < n; ++i) {
                System.out.println(reply.getString("storetime" + i) + "\t" + reply.getString("file" + i));
            }
            System.out.println();
        } else {
            System.out.println(reply.getString("result"));
        }
        return this;
    }

    void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

