/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet;

import com.swiftmq.mgmt.Command;
import com.swiftmq.mgmt.CommandExecutor;
import com.swiftmq.mgmt.Entity;
import com.swiftmq.mgmt.EntityList;
import com.swiftmq.mgmt.Property;
import com.swiftmq.mgmt.PropertyChangeException;
import com.swiftmq.mgmt.PropertyChangeListener;
import com.swiftmq.swiftlet.SwiftletManager;
import com.swiftmq.swiftlet.event.SwiftletManagerAdapter;
import com.swiftmq.swiftlet.event.SwiftletManagerEvent;
import com.swiftmq.swiftlet.mgmt.MgmtSwiftlet;
import com.swiftmq.swiftlet.mgmt.event.MgmtListener;
import com.swiftmq.swiftlet.timer.TimerSwiftlet;
import com.swiftmq.swiftlet.timer.event.TimerListener;

public class RouterMemoryMeter
implements TimerListener,
MgmtListener {
    TimerSwiftlet timerSwiftlet = null;
    MgmtSwiftlet mgmtSwiftlet = null;
    EntityList memoryList = null;
    Property freeMemProp = null;
    Property totalMemProp = null;
    Property memCollectIntervalProp = null;
    volatile long collectInterval = 0L;
    volatile boolean collectActive = false;

    public RouterMemoryMeter(Property memCollectIntervalProp) {
        this.memCollectIntervalProp = memCollectIntervalProp;
        this.collectInterval = (Long)memCollectIntervalProp.getValue();
        memCollectIntervalProp.setPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChanged(Property property, Object oldValue, Object newValue) throws PropertyChangeException {
                RouterMemoryMeter.this.collectInterval = (Long)newValue;
                RouterMemoryMeter.this.timerChange();
            }
        });
    }

    private synchronized void timerChange() {
        if (this.collectActive) {
            this.timerSwiftlet.removeTimerListener(this);
            this.timerSwiftlet.addTimerListener(this.collectInterval, this);
        }
    }

    public EntityList getMemoryList() {
        if (this.memoryList == null) {
            try {
                Entity tplEntity = new Entity("router-memory", "Router Memory", "Router Memory", null);
                Property prop = new Property("free-memory");
                prop.setType(Integer.class);
                prop.setDisplayName("Free Memory (KB)");
                prop.setDescription("Free Memory (KB)");
                prop.setDefaultValue(new Integer(0));
                prop.setRebootRequired(false);
                prop.setReadOnly(true);
                prop.setMandatory(true);
                tplEntity.addProperty(prop.getName(), prop);
                prop = new Property("total-memory");
                prop.setType(Integer.class);
                prop.setDisplayName("Total Memory (KB)");
                prop.setDescription("Total Memory (KB)");
                prop.setDefaultValue(new Integer(0));
                prop.setRebootRequired(false);
                prop.setReadOnly(true);
                prop.setMandatory(true);
                tplEntity.addProperty(prop.getName(), prop);
                this.memoryList = new EntityList("router-memory-list", "Router Memory List", "Router Memory List", null, tplEntity, false);
                this.memoryList.createCommands();
                CommandExecutor gcExecutor = new CommandExecutor(){

                    @Override
                    public String[] execute(String[] context, Entity entity, String[] cmd) {
                        if (cmd.length > 2) {
                            return new String[]{"Error:", "Invalid command, please try 'gc'"};
                        }
                        System.gc();
                        return null;
                    }
                };
                Command gcCommand = new Command("gc", "gc", "Run Garbage Collection", true, gcExecutor, true, true);
                this.memoryList.getCommandRegistry().addCommand(gcCommand);
                this.memoryList.setDynamicPropNames(new String[]{"free-memory", "total-memory"});
                this.memoryList.setDynamic(true);
                Entity entity = this.memoryList.createEntity();
                entity.setName(SwiftletManager.getInstance().getRouterName());
                entity.createCommands();
                this.freeMemProp = entity.getProperty("free-memory");
                this.totalMemProp = entity.getProperty("total-memory");
                this.memoryList.addEntity(entity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.memoryList;
    }

    public synchronized void start() {
        this.timerSwiftlet = (TimerSwiftlet)SwiftletManager.getInstance().getSwiftlet("sys$timer");
        this.mgmtSwiftlet = (MgmtSwiftlet)SwiftletManager.getInstance().getSwiftlet("sys$mgmt");
        if (this.mgmtSwiftlet != null) {
            this.mgmtSwiftlet.addMgmtListener(this);
        } else {
            SwiftletManager.getInstance().addSwiftletManagerListener("sys$mgmt", new SwiftletManagerAdapter(){

                @Override
                public void swiftletStarted(SwiftletManagerEvent evt) {
                    RouterMemoryMeter.this.mgmtSwiftlet = (MgmtSwiftlet)SwiftletManager.getInstance().getSwiftlet("sys$mgmt");
                    RouterMemoryMeter.this.mgmtSwiftlet.addMgmtListener(RouterMemoryMeter.this);
                }
            });
        }
    }

    @Override
    public synchronized void adminToolActivated() {
        this.timerSwiftlet.addTimerListener(this.collectInterval, this);
        this.collectActive = true;
    }

    @Override
    public synchronized void adminToolDeactivated() {
        this.timerSwiftlet.removeTimerListener(this);
        this.collectActive = false;
    }

    @Override
    public void performTimeAction() {
        try {
            this.freeMemProp.setValue(new Integer((int)Runtime.getRuntime().freeMemory() / 1024));
            this.totalMemProp.setValue(new Integer((int)Runtime.getRuntime().totalMemory() / 1024));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void close() {
        if (this.collectActive) {
            this.timerSwiftlet.removeTimerListener(this);
        }
        if (this.mgmtSwiftlet != null) {
            this.mgmtSwiftlet.removeMgmtListener(this);
        }
    }
}

