/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet;

import com.swiftmq.mgmt.XMLUtilities;
import com.swiftmq.swiftlet.SwiftletManager;
import com.swiftmq.swiftlet.deploy.DeploySpace;
import com.swiftmq.swiftlet.deploy.DeploySwiftlet;
import com.swiftmq.swiftlet.deploy.event.DeployListener;
import com.swiftmq.swiftlet.event.SwiftletManagerAdapter;
import com.swiftmq.swiftlet.event.SwiftletManagerEvent;
import com.swiftmq.swiftlet.log.LogSwiftlet;
import com.swiftmq.swiftlet.mgmt.CLIExecutor;
import com.swiftmq.swiftlet.mgmt.MgmtSwiftlet;
import com.swiftmq.swiftlet.trace.TraceSpace;
import com.swiftmq.swiftlet.trace.TraceSwiftlet;
import com.swiftmq.tools.deploy.Bundle;
import com.swiftmq.util.SwiftUtilities;
import java.util.List;

public class SwiftletDeployer
implements DeployListener {
    static final String SPACE_NAME = "extension-swiftlets";
    DeploySwiftlet deploySwiftlet = null;
    DeploySpace deploySpace = null;
    MgmtSwiftlet mgmtSwiftlet = null;
    LogSwiftlet logSwiftlet = null;
    TraceSwiftlet traceSwiftlet = (TraceSwiftlet)SwiftletManager.getInstance().getSwiftlet("sys$trace");
    TraceSpace traceSpace = this.traceSwiftlet.getTraceSpace("kernel");

    SwiftletDeployer() {
        SwiftletManager.getInstance().addSwiftletManagerListener("sys$log", new SwiftletManagerAdapter(){

            @Override
            public void swiftletStarted(SwiftletManagerEvent evt) {
                SwiftletDeployer.this.logSwiftlet = (LogSwiftlet)SwiftletManager.getInstance().getSwiftlet("sys$log");
            }
        });
        SwiftletManager.getInstance().addSwiftletManagerListener("sys$mgmt", new SwiftletManagerAdapter(){

            @Override
            public void swiftletStarted(SwiftletManagerEvent evt) {
                SwiftletDeployer.this.mgmtSwiftlet = (MgmtSwiftlet)SwiftletManager.getInstance().getSwiftlet("sys$mgmt");
            }
        });
        SwiftletManager.getInstance().addSwiftletManagerListener("sys$deploy", new SwiftletManagerAdapter(){

            @Override
            public void swiftletStarted(SwiftletManagerEvent evt) {
                SwiftletDeployer.this.deploySwiftlet = (DeploySwiftlet)SwiftletManager.getInstance().getSwiftlet("sys$deploy");
                SwiftletDeployer.this.deploySpace = SwiftletDeployer.this.deploySwiftlet.getDeploySpace(SwiftletDeployer.SPACE_NAME);
            }
        });
        SwiftletManager.getInstance().addSwiftletManagerListener("sys$scheduler", new SwiftletManagerAdapter(){

            @Override
            public void swiftletStarted(SwiftletManagerEvent evt) {
                SwiftletDeployer.this.start();
            }
        });
        if (this.traceSpace.enabled) {
            this.traceSpace.trace("SwiftletManager", this.toString() + "/created");
        }
    }

    public void start() {
        if (this.traceSpace.enabled) {
            this.traceSpace.trace("SwiftletManager", this.toString() + "/start ...");
        }
        if (this.deploySpace != null) {
            block15: {
                try {
                    Bundle[] bundles = this.deploySpace.getInstalledBundles();
                    if (bundles != null) {
                        for (int i = 0; i < bundles.length; ++i) {
                            if (this.traceSpace.enabled) {
                                this.traceSpace.trace("SwiftletManager", this.toString() + "/start, installing bundle=" + bundles[i]);
                            }
                            try {
                                SwiftletManager.getInstance().loadExtensionSwiftlet(bundles[i]);
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                if (this.traceSpace.enabled) {
                                    this.traceSpace.trace("SwiftletManager", this.toString() + "/start, bundle: " + bundles[i] + ", exception=" + e + ", trying to unload");
                                }
                                this.logSwiftlet.logError("SwiftletManager", this.toString() + "/start, bundle: " + bundles[i] + " exception=" + e + ", trying to unload");
                                try {
                                    SwiftletManager.getInstance().unloadExtensionSwiftlet(bundles[i]);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.traceSpace.enabled) break block15;
                    this.traceSpace.trace("SwiftletManager", this.toString() + "/start, exception getting installed bundles: " + e);
                }
            }
            this.deploySpace.setDeployListener(this);
        } else {
            this.logSwiftlet.logError("SwiftletManager", this.toString() + "/cannot deploy Extension Swiftlets, deploy space '" + SPACE_NAME + "' undefined!");
            if (this.traceSpace.enabled) {
                this.traceSpace.trace("SwiftletManager", this.toString() + "/cannot deploy Extension Swiftlets, deploy space '" + SPACE_NAME + "' undefined!");
            }
        }
        if (this.traceSpace.enabled) {
            this.traceSpace.trace("SwiftletManager", this.toString() + "/start done");
        }
    }

    private int executeCLICommands(Bundle bundle, CLIExecutor cliexec, String phase, boolean old) throws Exception {
        if (this.traceSpace.enabled) {
            this.traceSpace.trace("SwiftletManager", this.toString() + "/executeCLICommands, bundle=" + bundle.getBundleName() + ", phase=" + phase + " ...");
        }
        List cmdList = XMLUtilities.getCLICommands(old ? (bundle.getOldBundleConfig() == null ? bundle.getBundleConfig() : bundle.getOldBundleConfig()) : bundle.getBundleConfig(), phase);
        int ncmd = 0;
        if (cmdList == null || cmdList.size() == 0) {
            if (this.traceSpace.enabled) {
                this.traceSpace.trace("SwiftletManager", this.toString() + "/executeCLICommands, no commands found.");
            }
        } else {
            for (int i = 0; i < cmdList.size(); ++i) {
                String cmd = (String)cmdList.get(i);
                if (cmd == null || cmd.trim().length() <= 0) continue;
                cmd = SwiftUtilities.substitute(cmd, "routername", SwiftletManager.getInstance().getRouterName());
                if (this.traceSpace.enabled) {
                    this.traceSpace.trace("SwiftletManager", this.toString() + "/executeCLICommands: " + cmd);
                }
                try {
                    cliexec.execute(cmd);
                    continue;
                }
                catch (Exception e) {
                    if (cmd.toLowerCase().startsWith("new ")) continue;
                    throw e;
                }
            }
            ncmd = cmdList.size();
        }
        if (this.traceSpace.enabled) {
            this.traceSpace.trace("SwiftletManager", this.toString() + "/executeCLICommands, bundle=" + bundle.getBundleName() + ", phase=" + phase + " DONE.");
        }
        return ncmd;
    }

    @Override
    public void bundleAdded(Bundle bundle) throws Exception {
        if (this.traceSpace.enabled) {
            this.traceSpace.trace("SwiftletManager", this.toString() + "/bundleAdded, bundle: " + bundle);
        }
        CLIExecutor cliexec = this.mgmtSwiftlet.createCLIExecutor();
        int ncmd = 0;
        try {
            SwiftletManager.getInstance().loadExtensionSwiftlet(bundle);
        }
        catch (Exception e) {
            SwiftletManager.getInstance().unloadExtensionSwiftlet(bundle);
            ncmd += this.executeCLICommands(bundle, cliexec, "after-remove", false);
            throw e;
        }
        if ((ncmd += this.executeCLICommands(bundle, cliexec, "before-install", false)) > 0) {
            if (this.traceSpace.enabled) {
                this.traceSpace.trace("SwiftletManager", this.toString() + "/bundleAdded, saving configuration");
            }
            cliexec.execute("save");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bundleRemoved(Bundle bundle, boolean isRedeploy) throws Exception {
        if (this.traceSpace.enabled) {
            this.traceSpace.trace("SwiftletManager", this.toString() + "/bundleRemoved, bundle: " + bundle);
        }
        CLIExecutor cliexec = this.mgmtSwiftlet.createCLIExecutor();
        int ncmd = 0;
        try {
            SwiftletManager.getInstance().unloadExtensionSwiftlet(bundle);
        }
        finally {
            ncmd += this.executeCLICommands(bundle, cliexec, "after-remove", false);
        }
        if (!isRedeploy && ncmd > 0) {
            if (this.traceSpace.enabled) {
                this.traceSpace.trace("SwiftletManager", this.toString() + "/bundleRemoved, saving configuration");
            }
            cliexec.execute("save");
        }
    }

    public String toString() {
        return "SwiftletDeployer";
    }
}

