/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet;

import com.swiftmq.client.thread.PoolManager;
import com.swiftmq.mgmt.Command;
import com.swiftmq.mgmt.CommandExecutor;
import com.swiftmq.mgmt.CommandRegistry;
import com.swiftmq.mgmt.Configuration;
import com.swiftmq.mgmt.Entity;
import com.swiftmq.mgmt.MetaData;
import com.swiftmq.mgmt.PreConfigurator;
import com.swiftmq.mgmt.Property;
import com.swiftmq.mgmt.PropertyChangeAdapter;
import com.swiftmq.mgmt.PropertyChangeException;
import com.swiftmq.mgmt.RouterConfigInstance;
import com.swiftmq.mgmt.RouterConfiguration;
import com.swiftmq.mgmt.XMLUtilities;
import com.swiftmq.swiftlet.ConfigfileWatchdog;
import com.swiftmq.swiftlet.RouterMemoryMeter;
import com.swiftmq.swiftlet.Swiftlet;
import com.swiftmq.swiftlet.SwiftletDeployer;
import com.swiftmq.swiftlet.SwiftletException;
import com.swiftmq.swiftlet.UnknownSwiftletException;
import com.swiftmq.swiftlet.event.KernelStartupListener;
import com.swiftmq.swiftlet.event.SwiftletManagerEvent;
import com.swiftmq.swiftlet.event.SwiftletManagerListener;
import com.swiftmq.swiftlet.log.LogSwiftlet;
import com.swiftmq.swiftlet.timer.TimerSwiftlet;
import com.swiftmq.swiftlet.trace.TraceSpace;
import com.swiftmq.swiftlet.trace.TraceSwiftlet;
import com.swiftmq.tools.deploy.Bundle;
import com.swiftmq.tools.deploy.BundleEvent;
import com.swiftmq.tools.deploy.DeployPath;
import com.swiftmq.tools.file.NumberBackupFileReducer;
import com.swiftmq.tools.log.NullPrintStream;
import com.swiftmq.upgrade.UpgradeUtilities;
import com.swiftmq.util.SwiftUtilities;
import com.swiftmq.util.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SwiftletManager {
    static final String PROP_INITIAL_CONFIG = "swiftmq.initialconfig";
    static final String PROP_PRECONFIG = "swiftmq.preconfig";
    static final String PROP_SHUTDOWN_HOOK = "swiftmq.shutdown.hook";
    static final String PROP_REUSE_KERNEL_CL = "swiftmq.reuse.kernel.classloader";
    static final long PROP_CONFIG_WATCHDOG_INTERVAL = Long.parseLong(System.getProperty("swiftmq.config.watchdog.interval", "0"));
    protected static SwiftletManager _instance = null;
    static SimpleDateFormat fmt = new SimpleDateFormat(".yyyyMMddHHmmssSSS");
    String configFilename = null;
    Document routerConfig = null;
    String routerName = null;
    String workingDirectory = System.getProperty("user.dir");
    String[] kernelSwiftletNames = null;
    Map swiftletTable = null;
    DeployPath dp = null;
    Map bundleTable = null;
    Map listeners = new HashMap();
    Set allListeners = new HashSet();
    Set kernelListeners = new HashSet();
    Map surviveMap = Collections.synchronizedMap(new HashMap());
    RouterMemoryMeter memoryMeter = null;
    LogSwiftlet logSwiftlet = null;
    TraceSwiftlet traceSwiftlet = null;
    TimerSwiftlet timerSwiftlet = null;
    ConfigfileWatchdog configfileWatchdog = null;
    TraceSpace traceSpace = null;
    Object sSemaphore = new Object();
    Object lSemaphore = new Object();
    long memCollectInterval = 10000L;
    boolean smartTree = true;
    boolean startup = false;
    boolean rebooting = false;
    boolean workingDirAdded = false;
    boolean registerShutdownHook = Boolean.valueOf(System.getProperty("swiftmq.shutdown.hook", "true"));
    boolean quietMode = false;
    boolean strippedMode = false;
    boolean doFireKernelStartedEvent = true;
    PrintStream savedSystemOut = System.out;
    Thread shutdownHook = null;

    protected SwiftletManager() {
    }

    public static synchronized SwiftletManager getInstance() {
        if (_instance == null) {
            _instance = new SwiftletManager();
        }
        return _instance;
    }

    public boolean isHA() {
        return false;
    }

    public void setDoFireKernelStartedEvent(boolean doFireKernelStartedEvent) {
        this.doFireKernelStartedEvent = doFireKernelStartedEvent;
    }

    protected void trace(String message) {
        if (!this.quietMode && this.traceSpace != null && this.traceSpace.enabled) {
            this.traceSpace.trace("SwiftletManager", message);
        }
    }

    protected Configuration getConfiguration(Swiftlet swiftlet) throws Exception {
        this.trace("Swiftlet " + swiftlet.getName() + "', getConfiguration");
        Configuration config = (Configuration)RouterConfiguration.Singleton().getConfigurations().get(swiftlet.getName());
        if (config == null) {
            this.trace("Swiftlet " + swiftlet.getName() + "', get configuration template");
            config = this.getConfigurationTemplate(swiftlet.getName());
            if (config == null) {
                throw new Exception("Swiftlet " + swiftlet.getName() + "', getConfigurationTemplate returns null");
            }
            this.trace("Swiftlet " + swiftlet.getName() + "', fill configuration");
            config.getMetaData().setName(swiftlet.getName());
            config = this.fillConfiguration(config);
        }
        return config;
    }

    public Configuration getConfiguration(String name) {
        return (Configuration)RouterConfiguration.Singleton().getConfigurations().get(name);
    }

    private void startUpSwiftlet(Swiftlet swiftlet, Configuration config) throws SwiftletException {
        System.out.println("... startup: " + config.getMetaData().getDisplayName());
        if (swiftlet.isKernel()) {
            this.trace("Swiftlet " + swiftlet.getName() + "', fireSwiftletManagerEvent: swiftletStartInitiated");
            this.fireSwiftletManagerEvent(swiftlet.getName(), "swiftletStartInitiated", new SwiftletManagerEvent(this, swiftlet.getName()));
            this.trace("Swiftlet " + swiftlet.getName() + "', swiftlet.startup()");
        }
        swiftlet.startup(config);
        swiftlet.setState(0);
        if (swiftlet.isKernel()) {
            this.trace("Swiftlet " + swiftlet.getName() + "', fireSwiftletManagerEvent: swiftletStarted");
            this.fireSwiftletManagerEvent(swiftlet.getName(), "swiftletStarted", new SwiftletManagerEvent(this, swiftlet.getName()));
        }
    }

    protected void shutdownSwiftlet(Swiftlet swiftlet) throws SwiftletException {
        try {
            Configuration config = this.getConfiguration(swiftlet);
            System.out.println("... shutdown: " + config.getMetaData().getDisplayName());
        }
        catch (Exception config) {
            // empty catch block
        }
        SwiftletShutdown ss = new SwiftletShutdown(swiftlet);
        Thread t = new Thread(ss);
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (ss.getException() != null) {
            throw ss.getException();
        }
    }

    protected void startKernelSwiftlets() {
        String actSwiftletName = null;
        TraceSwiftlet swiftlet = null;
        long startupTime = -1L;
        Object className = null;
        try {
            actSwiftletName = "sys$trace";
            swiftlet = null;
            startupTime = -1L;
            try {
                swiftlet = (TraceSwiftlet)this.loadSwiftlet(actSwiftletName);
            }
            catch (Exception e) {
                System.err.println("Exception occurred while creating TraceSwiftlet instance: " + e.getMessage());
                System.exit(-1);
            }
            swiftlet.setName(actSwiftletName);
            swiftlet.setKernel(true);
            Configuration c = this.getConfiguration(swiftlet);
            RouterConfiguration.Singleton().getConfigurations().put(actSwiftletName, c);
            this.startUpSwiftlet(swiftlet, c);
            swiftlet.setStartupTime(System.currentTimeMillis());
            this.swiftletTable.put(actSwiftletName, swiftlet);
            this.traceSwiftlet = swiftlet;
            this.traceSpace = this.traceSwiftlet.getTraceSpace("kernel");
            this.trace("Trace swiftlet '" + actSwiftletName + " has been started");
            this.trace("Starting kernel swiftlets");
            new SwiftletDeployer();
            String[] stringArray = this.kernelSwiftletNames;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String kernelSwiftletName;
                actSwiftletName = kernelSwiftletName = stringArray[i];
                this.startKernelSwiftlet(actSwiftletName, this.swiftletTable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.trace("Kernel swiftlet: '" + actSwiftletName + "', exception during startup: " + e.getMessage());
            System.err.println("Exception during startup kernel swiftlet '" + actSwiftletName + "': " + e.getMessage());
            System.exit(-1);
        }
        this.logSwiftlet = (LogSwiftlet)this.getSwiftlet("sys$log");
        this.trace("Kernel swiftlets started");
    }

    protected void startKernelSwiftlet(String actSwiftletName, Map table) throws Exception {
        this.trace("Starting kernel swiftlet: '" + actSwiftletName + "' ...");
        Swiftlet swiftlet = null;
        long startupTime = -1L;
        this.trace("Kernel swiftlet: '" + actSwiftletName + "'");
        try {
            swiftlet = this.loadSwiftlet(actSwiftletName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.trace("Kernel swiftlet: '" + actSwiftletName + "', exception occurred while creating Swiftlet instance: " + e.getMessage());
            System.err.println("Exception occurred while creating Swiftlet instance: " + e.getMessage());
            System.exit(-1);
        }
        swiftlet.setName(actSwiftletName);
        swiftlet.setKernel(true);
        this.trace("Kernel swiftlet: '" + actSwiftletName + "', startUpSwiftlet ...");
        table.put(actSwiftletName, swiftlet);
        Configuration conf = this.getConfiguration(swiftlet);
        RouterConfiguration.Singleton().getConfigurations().put(actSwiftletName, conf);
        this.startUpSwiftlet(swiftlet, conf);
        swiftlet.setStartupTime(System.currentTimeMillis());
        this.trace("Kernel swiftlet: '" + actSwiftletName + "', is running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void stopKernelSwiftlets() {
        this.trace("stopKernelSwiftlets");
        this.logSwiftlet.logInformation("SwiftletManager", "stopKernelSwiftlets");
        ArrayList<Swiftlet> al = new ArrayList<Swiftlet>();
        Iterator iterator = this.sSemaphore;
        synchronized (iterator) {
            void var3_4;
            int n = this.kernelSwiftletNames.length - 1;
            while (var3_4 >= 0) {
                String name = this.kernelSwiftletNames[var3_4];
                Swiftlet swiftlet = (Swiftlet)this.swiftletTable.get(name);
                if (swiftlet.getState() == 0) {
                    al.add(swiftlet);
                }
                --var3_4;
            }
            al.add((Swiftlet)this.swiftletTable.get("sys$trace"));
        }
        for (Object e : al) {
            Swiftlet swiftlet = (Swiftlet)e;
            try {
                this.shutdownSwiftlet(swiftlet);
            }
            catch (SwiftletException swiftletException) {
                // empty catch block
            }
            swiftlet.setStartupTime(-1L);
        }
    }

    private void fillSwiftletTable() {
        for (String kernelSwiftletName : this.kernelSwiftletNames) {
            this.swiftletTable.put(kernelSwiftletName, null);
        }
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public boolean isRegisterShutdownHook() {
        return this.registerShutdownHook;
    }

    public void setRegisterShutdownHook(boolean registerShutdownHook) {
        this.registerShutdownHook = registerShutdownHook;
    }

    public void disableShutdownHook() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
    }

    public boolean isQuietMode() {
        return this.quietMode;
    }

    public void setQuietMode(boolean quietMode) {
        this.quietMode = quietMode;
        if (quietMode) {
            System.setOut(new NullPrintStream());
        } else {
            System.setOut(this.savedSystemOut);
        }
    }

    public boolean isStrippedMode() {
        return this.strippedMode;
    }

    public void setStrippedMode(boolean strippedMode) {
        this.strippedMode = strippedMode;
    }

    public synchronized void loadExtensionSwiftlet(Bundle bundle) throws Exception {
        String name = bundle.getBundleName();
        this.trace("loadExtensionSwiftlet: '" + name + "' ...");
        this.bundleTable.put(bundle.getBundleName(), bundle);
        Swiftlet swiftlet = this.loadSwiftlet(name);
        swiftlet.setName(name);
        long startupTime = -1L;
        Configuration config = this.getConfiguration(swiftlet);
        RouterConfiguration.Singleton().addEntity(config);
        config.setExtension(true);
        this.trace("Swiftlet: '" + name + "', startUpSwiftlet ...");
        this.startUpSwiftlet(swiftlet, config);
        startupTime = System.currentTimeMillis();
        swiftlet.setStartupTime(startupTime);
        this.swiftletTable.put(name, swiftlet);
        swiftlet = null;
        this.trace("loadExtensionSwiftlet: '" + name + "' DONE.");
    }

    public synchronized void unloadExtensionSwiftlet(Bundle bundle) {
        String name = bundle.getBundleName();
        this.trace("unloadExtensionSwiftlet: '" + name + "' ...");
        try {
            Swiftlet swiftlet = (Swiftlet)this.swiftletTable.get(name);
            if (swiftlet != null) {
                this.shutdownSwiftlet(swiftlet);
            }
            RouterConfiguration.Singleton().removeEntity(RouterConfiguration.Singleton().getEntity(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bundleTable.remove(name);
        this.swiftletTable.remove(name);
        System.gc();
        System.runFinalization();
        this.trace("unloadExtensionSwiftlet: '" + name + "' DONE.");
    }

    public boolean isUseSmartTree() {
        return this.smartTree;
    }

    public boolean isStartup() {
        return this.startup;
    }

    public boolean isRebooting() {
        return this.rebooting;
    }

    protected Map createBundleTable(String kernelPath) throws Exception {
        if (kernelPath == null) {
            throw new Exception("Missing attribute: kernelpath");
        }
        File f = new File(SwiftUtilities.addWorkingDir(kernelPath));
        if (!f.exists() || !f.isDirectory()) {
            throw new Exception("Invalid value for 'kernelpath': directory doesn't exists");
        }
        if (this.dp == null) {
            this.dp = new DeployPath(f, true, this.getClass().getClassLoader());
        } else {
            boolean reuseCL = Boolean.valueOf(System.getProperty(PROP_REUSE_KERNEL_CL, "false"));
            if (reuseCL) {
                this.dp.init();
            } else {
                this.dp = new DeployPath(f, true, this.getClass().getClassLoader());
            }
        }
        BundleEvent[] events = this.dp.getBundleEvents();
        if (events == null) {
            throw new Exception("No Kernel Swiftlets found in 'kernelpath'");
        }
        HashMap<String, Bundle> table = new HashMap<String, Bundle>();
        for (BundleEvent event : events) {
            Bundle b = event.getBundle();
            table.put(b.getBundleName(), b);
        }
        return table;
    }

    private Document getInitialConfig() throws Exception {
        String initialConfig = System.getProperty(PROP_INITIAL_CONFIG);
        if (initialConfig != null && initialConfig.trim().length() > 0) {
            return XMLUtilities.createDocument(new FileInputStream(initialConfig));
        }
        return this.routerConfig;
    }

    private void checkAndApplyPreconfig() throws Exception {
        String preconfig = System.getProperty(PROP_PRECONFIG);
        if (preconfig != null && preconfig.trim().length() > 0) {
            StringTokenizer t = new StringTokenizer(preconfig, ",");
            while (t.hasMoreTokens()) {
                String pc = t.nextToken();
                XMLUtilities.writeDocument(this.routerConfig, this.configFilename + fmt.format(new Date()));
                this.routerConfig = new PreConfigurator(this.routerConfig, XMLUtilities.createDocument(new FileInputStream(pc))).applyChanges();
                XMLUtilities.writeDocument(this.routerConfig, this.configFilename);
                System.out.println("Applied changes from preconfig file: " + pc);
            }
        }
    }

    public void startRouter(String name) throws Exception {
        if (!this.workingDirAdded) {
            this.configFilename = SwiftUtilities.addWorkingDir(name);
            this.workingDirAdded = true;
        }
        this.routerConfig = XMLUtilities.createDocument(new FileInputStream(this.configFilename));
        UpgradeUtilities.checkRelease(this.configFilename, this.routerConfig);
        this.checkAndApplyPreconfig();
        Element root = this.routerConfig.getRootElement();
        this.parseOptionalConfiguration(root);
        String value = root.attributeValue("startorder");
        if (value == null) {
            throw new Exception("Missing attribute: startorder");
        }
        StringTokenizer t = new StringTokenizer(value, " ,:");
        this.kernelSwiftletNames = new String[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            this.kernelSwiftletNames[i++] = t.nextToken();
        }
        this.smartTree = root.attributeValue("use-smart-tree") != null ? Boolean.valueOf(root.attributeValue("use-smart-tree")) : true;
        if (root.attributeValue("memory-collect-interval") != null) {
            this.memCollectInterval = Long.valueOf(root.attributeValue("memory-collect-interval"));
        }
        this.routerName = root.attributeValue("name");
        this.bundleTable = this.createBundleTable(root.attributeValue("kernelpath"));
        this.initSwiftlets();
        this.timerSwiftlet = (TimerSwiftlet)this.getSwiftlet("sys$timer");
        if (PROP_CONFIG_WATCHDOG_INTERVAL > 0L) {
            this.configfileWatchdog = new ConfigfileWatchdog(this.traceSpace, this.logSwiftlet, this.configFilename);
            this.timerSwiftlet.addTimerListener(PROP_CONFIG_WATCHDOG_INTERVAL, this.configfileWatchdog);
        }
        if (this.shutdownHook == null && this.registerShutdownHook) {
            this.shutdownHook = new Thread(() -> this.shutdown());
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    protected void parseOptionalConfiguration(Element root) {
    }

    protected void createRouterCommands() {
        RouterConfiguration.Singleton().setName(this.getRouterName());
        RouterConfiguration.Singleton().createCommands();
        CommandRegistry commandRegistry = new CommandRegistry("current Router's Swiftlet Manager", null);
        RouterConfiguration.Singleton().setCommandRegistry(commandRegistry);
        CommandExecutor rebootExecutor = (context, entity, cmd) -> {
            if (cmd.length != 1) {
                return new String[]{"Error:", "Invalid command, please try 'reboot'"};
            }
            String[] result = new String[]{"Information:", "Reboot Launch in 10 Seconds."};
            Thread t = new Thread(Thread.currentThread().getThreadGroup().getParent(), "Reboot Thread"){

                @Override
                public void run() {
                    SwiftletManager.this.reboot(10000L);
                }
            };
            t.setDaemon(false);
            t.setPriority(1);
            t.start();
            return result;
        };
        Command rebootCommand = new Command("reboot", "reboot", "Reboot the Router", true, rebootExecutor, true, false);
        commandRegistry.addCommand(rebootCommand);
        CommandExecutor haltExecutor = (context, entity, cmd) -> {
            if (cmd.length != 1) {
                return new String[]{"Error:", "Invalid command, please try 'halt'"};
            }
            String[] result = new String[]{"Information:", "Router Halt in 10 Seconds."};
            Thread t = new Thread(Thread.currentThread().getThreadGroup().getParent(), "Halt Thread"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SwiftletManager.this.shutdown(true);
                    System.exit(0);
                }
            };
            t.setDaemon(false);
            t.start();
            t.setPriority(1);
            return result;
        };
        Command haltCommand = new Command("halt", "halt", "Halt the Router", true, haltExecutor, true, false);
        commandRegistry.addCommand(haltCommand);
        CommandExecutor saveExecutor = (context, entity, cmd) -> {
            if (cmd.length > 1) {
                return new String[]{"Error:", "Invalid command, please try 'save'"};
            }
            String[] result = null;
            result = this.saveConfiguration(RouterConfiguration.Singleton());
            return result;
        };
        Command saveCommand = new Command("save", "save", "Save this Router Configuration", true, saveExecutor, true, false);
        commandRegistry.addCommand(saveCommand);
    }

    private synchronized void initSwiftlets() {
        System.out.println("Booting SwiftMQ " + Version.getKernelVersion() + " [" + this.getRouterName() + "] ...");
        this.startup = true;
        this.swiftletTable = Collections.synchronizedMap(new HashMap());
        this.createRouterCommands();
        try {
            Entity envEntity = new Entity(".env", "Router Environment", "Environment of this Router", null);
            envEntity.createCommands();
            RouterConfiguration.Singleton().addEntity(envEntity);
            Property prop = new Property("routername");
            prop.setType(String.class);
            prop.setDisplayName("Router Name");
            prop.setDescription("Name of this Router");
            prop.setValue(this.getRouterName());
            prop.setRebootRequired(true);
            prop.setPropertyChangeListener(new PropertyChangeAdapter(null){

                @Override
                public void propertyChanged(Property property, Object oldValue, Object newValue) throws PropertyChangeException {
                    try {
                        if (newValue != null) {
                            SwiftUtilities.verifyRouterName((String)newValue);
                        }
                    }
                    catch (Exception e) {
                        throw new PropertyChangeException(e.getMessage());
                    }
                }
            });
            envEntity.addProperty(prop.getName(), prop);
            prop = new Property("use-smart-tree");
            prop.setType(Boolean.class);
            prop.setDisplayName("Use Smart Management Tree");
            prop.setDescription("Use Smart Management Tree (reduced Usage Parts)");
            prop.setValue(this.smartTree);
            prop.setRebootRequired(true);
            envEntity.addProperty(prop.getName(), prop);
            prop = new Property("release");
            prop.setType(String.class);
            prop.setDisplayName("SwiftMQ Release");
            prop.setDescription("SwiftMQ Release");
            prop.setValue(Version.getKernelVersion());
            prop.setReadOnly(true);
            prop.setStorable(false);
            envEntity.addProperty(prop.getName(), prop);
            prop = new Property("hostname");
            prop.setType(String.class);
            prop.setDisplayName("Hostname");
            prop.setDescription("Router's DNS Hostname");
            String localhost = "unknown";
            try {
                localhost = InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
            }
            catch (UnknownHostException e) {
                System.err.println("Unable to determine local host name: " + e);
            }
            prop.setValue(localhost);
            prop.setReadOnly(true);
            prop.setStorable(false);
            envEntity.addProperty(prop.getName(), prop);
            prop = new Property("startuptime");
            prop.setType(String.class);
            prop.setDisplayName("Startup Time");
            prop.setDescription("Router's Startup Time");
            prop.setValue(new Date().toString());
            prop.setReadOnly(true);
            prop.setStorable(false);
            envEntity.addProperty(prop.getName(), prop);
            prop = new Property("os");
            prop.setType(String.class);
            prop.setDisplayName("Operating System");
            prop.setDescription("Router's Host OS");
            prop.setValue(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + " ");
            prop.setReadOnly(true);
            prop.setStorable(false);
            envEntity.addProperty(prop.getName(), prop);
            prop = new Property("jre");
            prop.setType(String.class);
            prop.setDisplayName("JRE");
            prop.setDescription("JRE Version");
            prop.setValue(System.getProperty("java.version"));
            prop.setReadOnly(true);
            prop.setStorable(false);
            envEntity.addProperty(prop.getName(), prop);
            prop = new Property("memory-collect-interval");
            prop.setType(Long.class);
            prop.setDisplayName("Memory Collect Interval");
            prop.setDescription("Memory Collect Interval (ms)");
            prop.setValue(this.memCollectInterval);
            prop.setReadOnly(false);
            prop.setStorable(false);
            envEntity.addProperty(prop.getName(), prop);
            this.memoryMeter = new RouterMemoryMeter(prop);
            envEntity.addEntity(this.memoryMeter.getMemoryList());
        }
        catch (Exception envEntity) {
            // empty catch block
        }
        this.fillSwiftletTable();
        this.startKernelSwiftlets();
        Set keySet = this.swiftletTable.keySet();
        for (Object aKeySet : keySet) {
            MetaData meta;
            Configuration config;
            String name = (String)aKeySet;
            Swiftlet swiftlet = (Swiftlet)this.swiftletTable.get(name);
            if (swiftlet.getState() != 0 || (config = (Configuration)RouterConfiguration.Singleton().getConfigurations().get(name)) == null || (meta = config.getMetaData()) == null) continue;
            this.logSwiftlet.logInformation("SwiftletManager", "Swiftlet started: " + meta);
        }
        this.trace("Init swiftlets successful");
        this.memoryMeter.start();
        this.startup = false;
        if (this.doFireKernelStartedEvent) {
            this.fireKernelStartedEvent();
        }
        System.out.println("SwiftMQ " + Version.getKernelVersion() + " [" + this.getRouterName() + "] is ready.");
    }

    public void reboot() {
        new Thread(() -> this.reboot(0L)).start();
    }

    public void reboot(long delay) {
        this.rebooting = true;
        try {
            Thread.sleep(delay);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.shutdown();
        System.gc();
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.startRouter(this.configFilename);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.rebooting = false;
    }

    protected Swiftlet loadSwiftlet(String swiftletName) throws Exception {
        Bundle bundle = (Bundle)this.bundleTable.get(swiftletName);
        if (bundle == null) {
            throw new Exception("No bundle found for Swiftlet '" + swiftletName + "'");
        }
        Document doc = XMLUtilities.createDocument(bundle.getBundleConfig());
        String className = doc.getRootElement().attributeValue("class");
        if (className == null) {
            throw new Exception("Missing Attribute 'class' for Swiftlet '" + swiftletName + "'");
        }
        return (Swiftlet)bundle.getBundleLoader().loadClass(className).newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Swiftlet getSwiftlet(String swiftletName) {
        Swiftlet swiftlet = null;
        Object object = this.sSemaphore;
        synchronized (object) {
            swiftlet = (Swiftlet)this.swiftletTable.get(swiftletName);
        }
        if (swiftlet != null && swiftlet.getState() == 0 && swiftlet.isKernel()) {
            return swiftlet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Swiftlet _getSwiftlet(String swiftletName) {
        Swiftlet swiftlet = null;
        Object object = this.sSemaphore;
        synchronized (object) {
            swiftlet = (Swiftlet)this.swiftletTable.get(swiftletName);
        }
        if (swiftlet != null && swiftlet.getState() == 0) {
            return swiftlet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSwiftletState(String swiftletName) throws UnknownSwiftletException {
        Swiftlet swiftlet = null;
        Object object = this.sSemaphore;
        synchronized (object) {
            swiftlet = (Swiftlet)this.swiftletTable.get(swiftletName);
        }
        if (swiftlet == null) {
            throw new UnknownSwiftletException("Swiftlet '" + swiftletName + "' is unknown");
        }
        return swiftlet.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSwiftletDefined(String swiftletName) {
        boolean b = false;
        Object object = this.sSemaphore;
        synchronized (object) {
            b = this.swiftletTable.containsKey(swiftletName);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllSwiftlets() {
        this.trace("stopAllSwiftlets");
        this.logSwiftlet.logInformation("SwiftletManager", "stopAllSwiftlets");
        ArrayList<Swiftlet> al = new ArrayList<Swiftlet>();
        Iterator iterator = this.sSemaphore;
        synchronized (iterator) {
            for (Map.Entry o : RouterConfiguration.Singleton().getConfigurations().entrySet()) {
                String name;
                Swiftlet swiftlet;
                Configuration conf;
                Entity entity = (Entity)o.getValue();
                if (!(entity instanceof Configuration) || !(conf = (Configuration)entity).isExtension() || (swiftlet = (Swiftlet)this.swiftletTable.get(name = conf.getName())) == null || swiftlet.getState() != 0) continue;
                al.add(swiftlet);
            }
        }
        for (Object e : al) {
            Swiftlet swiftlet = (Swiftlet)e;
            this.trace("stopAllSwiftlets: Stopping swiftlet '" + swiftlet.getName() + "'");
            this.logSwiftlet.logInformation("SwiftletManager", "stopAllSwiftlets: Stopping swiftlet '" + swiftlet.getName() + "'");
            try {
                this.shutdownSwiftlet(swiftlet);
            }
            catch (SwiftletException swiftletException) {
                // empty catch block
            }
            swiftlet.setStartupTime(-1L);
            this.trace("stopAllSwiftlets: Swiftlet " + swiftlet.getName() + " has been stopped");
            this.logSwiftlet.logInformation("SwiftletManager", "stopAllSwiftlets: Swiftlet " + swiftlet.getName() + " has been stopped");
        }
    }

    public void shutdown(boolean removeShutdownHook) {
        if (removeShutdownHook && this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        this.shutdown();
    }

    public synchronized void shutdown() {
        System.out.println("Shutdown SwiftMQ " + Version.getKernelVersion() + " [" + this.getRouterName() + "] ...");
        this.trace("shutdown");
        if (this.configfileWatchdog != null) {
            this.timerSwiftlet.removeTimerListener(this.configfileWatchdog);
        }
        this.memoryMeter.close();
        this.stopAllSwiftlets();
        this.stopKernelSwiftlets();
        this.listeners.clear();
        this.allListeners.clear();
        this.kernelListeners.clear();
        this.swiftletTable.clear();
        RouterConfiguration.removeInstance();
        PoolManager.reset();
        this.traceSpace = null;
        this.logSwiftlet = null;
        System.out.println("Shutdown SwiftMQ " + Version.getKernelVersion() + " [" + this.getRouterName() + "] DONE.");
    }

    public String getRouterName() {
        return this.routerName;
    }

    public void saveConfiguration() {
        this.saveConfiguration(RouterConfiguration.Singleton());
    }

    protected Element[] getOptionalElements() {
        return null;
    }

    protected String[] saveConfiguration(RouterConfigInstance entity) {
        ArrayList<String> al = new ArrayList<String>();
        al.add("Information:");
        try {
            String backupFile = this.configFilename + fmt.format(new Date());
            File file = new File(this.configFilename);
            file.renameTo(new File(backupFile));
            new NumberBackupFileReducer(file.getParent(), file.getName() + ".", 15).process();
            al.add("Configuration backed up to file '" + backupFile + "'.");
        }
        catch (Exception e) {
            al.add("Error creating configuration backup: " + e);
        }
        try {
            Element[] optional;
            long l;
            Document doc = DocumentHelper.createDocument();
            doc.addComment("  SwiftMQ Configuration. Last Save Time: " + new Date() + "  ");
            Element root = DocumentHelper.createElement((String)"router");
            root.addAttribute("name", (String)entity.getEntity(".env").getProperty("routername").getValue());
            root.addAttribute("kernelpath", this.routerConfig.getRootElement().attributeValue("kernelpath"));
            root.addAttribute("release", Version.getKernelConfigRelease());
            root.addAttribute("startorder", this.routerConfig.getRootElement().attributeValue("startorder"));
            boolean b = (Boolean)entity.getEntity(".env").getProperty("use-smart-tree").getValue();
            if (!b) {
                root.addAttribute("use-smart-tree", "false");
            }
            if ((l = ((Long)entity.getEntity(".env").getProperty("memory-collect-interval").getValue()).longValue()) != 10000L) {
                root.addAttribute("memory-collect-interval", String.valueOf(l));
            }
            if ((optional = this.getOptionalElements()) != null) {
                for (Element anOptional : optional) {
                    XMLUtilities.elementToXML(anOptional, root);
                }
            }
            doc.setRootElement(root);
            Map configs = entity.getEntities();
            for (Object o : configs.keySet()) {
                Entity c = (Entity)configs.get((String)o);
                if (!(c instanceof Configuration)) continue;
                XMLUtilities.configToXML((Configuration)c, root);
            }
            XMLUtilities.writeDocument(doc, this.configFilename);
            this.routerConfig = doc;
            al.add("Configuration saved to file '" + this.configFilename + "'.");
        }
        catch (Exception e) {
            al.add("Error saving configuration: " + e);
        }
        return al.toArray(new String[al.size()]);
    }

    private Configuration getConfigurationTemplate(String swiftletName) throws Exception {
        Bundle bundle = (Bundle)this.bundleTable.get(swiftletName);
        if (bundle == null) {
            return null;
        }
        Configuration c = XMLUtilities.createConfigurationTemplate(bundle.getBundleConfig());
        XMLUtilities.loadIcons(c, bundle.getBundleLoader());
        return c;
    }

    private Configuration fillConfiguration(Configuration template) throws Exception {
        return XMLUtilities.fillConfiguration(template, this.routerConfig);
    }

    Configuration fillConfigurationFromTemplate(String swiftletName, Document routerConfigDoc) throws Exception {
        Bundle bundle = (Bundle)this.bundleTable.get(swiftletName);
        if (bundle == null) {
            return null;
        }
        Configuration template = XMLUtilities.createConfigurationTemplate(bundle.getBundleConfig());
        return XMLUtilities.fillConfiguration(template, routerConfigDoc);
    }

    public void addSurviveData(String key, Object data) {
        this.surviveMap.put(key, data);
    }

    public void removeSurviveData(String key) {
        this.surviveMap.remove(key);
    }

    public Object getSurviveData(String key) {
        return this.surviveMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSwiftletManagerListener(String swiftletName, SwiftletManagerListener l) {
        this.trace("addSwiftletManagerListener: Swiftlet " + swiftletName + "', adding SwiftletManagerListener");
        Object object = this.lSemaphore;
        synchronized (object) {
            HashSet<SwiftletManagerListener> qListeners = (HashSet<SwiftletManagerListener>)this.listeners.get(swiftletName);
            if (qListeners == null) {
                qListeners = new HashSet<SwiftletManagerListener>();
                this.listeners.put(swiftletName, qListeners);
            }
            qListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSwiftletManagerListener(SwiftletManagerListener l) {
        this.trace("addSwiftletManagerListener: adding SwiftletManagerListener");
        Object object = this.lSemaphore;
        synchronized (object) {
            this.allListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSwiftletManagerListener(String swiftletName, SwiftletManagerListener l) {
        this.trace("removeSwiftletManagerListener: Swiftlet " + swiftletName + "', removing SwiftletManagerListener");
        Object object = this.lSemaphore;
        synchronized (object) {
            HashSet qListeners = (HashSet)this.listeners.get(swiftletName);
            if (qListeners != null) {
                qListeners.remove(l);
                if (qListeners.isEmpty()) {
                    this.listeners.put(swiftletName, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSwiftletManagerListener(SwiftletManagerListener l) {
        this.trace("removeSwiftletManagerListener: removing SwiftletManagerListener");
        Object object = this.lSemaphore;
        synchronized (object) {
            this.allListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addKernelStartupListener(KernelStartupListener l) {
        this.trace("addKernelStartupListener: adding KernelStartupListener");
        Object object = this.lSemaphore;
        synchronized (object) {
            this.kernelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeKernelStartupListener(KernelStartupListener l) {
        this.trace("removeKernelStartupListener: removing KernelStartupListener");
        Object object = this.lSemaphore;
        synchronized (object) {
            this.kernelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireKernelStartedEvent() {
        this.trace("fireKernelStartedEvent");
        Set cloned = null;
        Iterator iterator = this.lSemaphore;
        synchronized (iterator) {
            cloned = (Set)((HashSet)this.kernelListeners).clone();
        }
        for (Object aCloned : cloned) {
            ((KernelStartupListener)aCloned).kernelStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSwiftletManagerEvent(String swiftletName, String methodName, SwiftletManagerEvent evt) {
        this.trace("fireSwiftletManagerEvent: Swiftlet " + swiftletName + "', method: " + methodName);
        SwiftletManagerListener[] myListeners = null;
        SwiftletManagerListener[] swiftletManagerListenerArray = this.lSemaphore;
        synchronized (this.lSemaphore) {
            Object l;
            Object myListener;
            int n;
            HashSet qListeners = (HashSet)this.listeners.get(swiftletName);
            if (qListeners != null) {
                myListeners = qListeners.toArray(new SwiftletManagerListener[qListeners.size()]);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (myListeners != null) {
                swiftletManagerListenerArray = myListeners;
                int n2 = swiftletManagerListenerArray.length;
                block27: for (n = 0; n < n2; ++n) {
                    l = myListener = swiftletManagerListenerArray[n];
                    switch (methodName) {
                        case "swiftletStartInitiated": {
                            l.swiftletStartInitiated(evt);
                            continue block27;
                        }
                        case "swiftletStarted": {
                            l.swiftletStarted(evt);
                            continue block27;
                        }
                        case "swiftletStopInitiated": {
                            l.swiftletStopInitiated(evt);
                            continue block27;
                        }
                        case "swiftletStopped": {
                            l.swiftletStopped(evt);
                        }
                    }
                }
            }
            if ((myListeners = this.allListeners.toArray(new SwiftletManagerListener[this.allListeners.size()])) != null) {
                swiftletManagerListenerArray = myListeners;
                int n3 = swiftletManagerListenerArray.length;
                block28: for (n = 0; n < n3; ++n) {
                    l = myListener = swiftletManagerListenerArray[n];
                    switch (methodName) {
                        case "swiftletStartInitiated": {
                            l.swiftletStartInitiated(evt);
                            continue block28;
                        }
                        case "swiftletStarted": {
                            l.swiftletStarted(evt);
                            continue block28;
                        }
                        case "swiftletStopInitiated": {
                            l.swiftletStopInitiated(evt);
                            continue block28;
                        }
                        case "swiftletStopped": {
                            l.swiftletStopped(evt);
                        }
                    }
                }
            }
            return;
        }
    }

    private class SwiftletShutdown
    implements Runnable {
        Swiftlet swiftlet = null;
        SwiftletException exception = null;

        public SwiftletShutdown(Swiftlet swiftlet) {
            this.swiftlet = swiftlet;
        }

        public SwiftletException getException() {
            return this.exception;
        }

        @Override
        public void run() {
            try {
                if (this.swiftlet.isKernel()) {
                    SwiftletManager.this.trace("Swiftlet " + this.swiftlet.getName() + "', fireSwiftletManagerEvent: swiftletStopInitiated");
                    SwiftletManager.this.fireSwiftletManagerEvent(this.swiftlet.getName(), "swiftletStopInitiated", new SwiftletManagerEvent(SwiftletManager.this, this.swiftlet.getName()));
                    SwiftletManager.this.trace("Swiftlet " + this.swiftlet.getName() + "', swiftlet.shutdown()");
                }
                this.swiftlet.shutdown();
                this.swiftlet.setState(1);
                if (this.swiftlet.isKernel()) {
                    SwiftletManager.this.trace("Swiftlet " + this.swiftlet.getName() + "', fireSwiftletManagerEvent: swiftletStopped");
                    SwiftletManager.this.fireSwiftletManagerEvent(this.swiftlet.getName(), "swiftletStopped", new SwiftletManagerEvent(SwiftletManager.this, this.swiftlet.getName()));
                }
            }
            catch (SwiftletException e) {
                this.exception = e;
            }
        }
    }
}

