/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.auth;

import com.swiftmq.swiftlet.auth.ResourceLimitException;

public class ResourceLimitGroup {
    String name = null;
    int maxConnections;
    int maxSessions;
    int maxTempQueues;
    int maxProducers;
    int maxConsumers;
    int sessions = 0;
    int tempQueues = 0;
    int producers = 0;
    int consumers = 0;

    public ResourceLimitGroup(String name, int maxConnections, int maxSessions, int maxTempQueues, int maxProducers, int maxConsumers) {
        this.name = name;
        this.maxConnections = maxConnections;
        this.maxSessions = maxSessions;
        this.maxTempQueues = maxTempQueues;
        this.maxProducers = maxProducers;
        this.maxConsumers = maxConsumers;
    }

    public String getName() {
        return this.name;
    }

    public synchronized int getMaxConnections() {
        return this.maxConnections;
    }

    public synchronized void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public synchronized void verifyConnectionLimit(int n) throws ResourceLimitException {
        if (this.maxConnections != -1 && n >= this.maxConnections) {
            throw new ResourceLimitException("Resource Limit Group '" + this.name + "': max connections exceeded. Resource limit is: " + this.maxConnections);
        }
    }

    public synchronized int getMaxSessions() {
        return this.maxSessions;
    }

    public synchronized void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    public synchronized int getMaxTempQueues() {
        return this.maxTempQueues;
    }

    public synchronized void setMaxTempQueues(int maxTempQueues) {
        this.maxTempQueues = maxTempQueues;
    }

    public synchronized int getMaxProducers() {
        return this.maxProducers;
    }

    public synchronized void setMaxProducers(int maxProducers) {
        this.maxProducers = maxProducers;
    }

    public synchronized int getMaxConsumers() {
        return this.maxConsumers;
    }

    public synchronized void setMaxConsumers(int maxConsumers) {
        this.maxConsumers = maxConsumers;
    }

    public synchronized void incSessions() throws ResourceLimitException {
        if (this.sessions >= this.maxSessions) {
            throw new ResourceLimitException("Resource Limit Group '" + this.name + "': max sessions per connection exceeded. Resource limit is: " + this.maxSessions);
        }
        ++this.sessions;
    }

    public synchronized void decSessions() {
        --this.sessions;
        if (this.sessions < 0) {
            this.sessions = 0;
        }
    }

    public synchronized int getSessions() {
        return this.sessions;
    }

    public synchronized void incTempQueues() throws ResourceLimitException {
        if (this.tempQueues >= this.maxTempQueues) {
            throw new ResourceLimitException("Resource Limit Group '" + this.name + "': max temp. queues per connection exceeded. Resource limit is: " + this.maxTempQueues);
        }
        ++this.tempQueues;
    }

    public synchronized void decTempQueues() {
        --this.tempQueues;
        if (this.tempQueues < 0) {
            this.tempQueues = 0;
        }
    }

    public synchronized int getTempQueues() {
        return this.tempQueues;
    }

    public synchronized void incProducers() throws ResourceLimitException {
        if (this.producers >= this.maxProducers) {
            throw new ResourceLimitException("Resource Limit Group '" + this.name + "': max producers per connection exceeded. Resource limit is: " + this.maxProducers);
        }
        ++this.producers;
    }

    public synchronized void decProducers() {
        --this.producers;
        if (this.producers < 0) {
            this.producers = 0;
        }
    }

    public synchronized int getProducers() {
        return this.producers;
    }

    public synchronized void incConsumers() throws ResourceLimitException {
        if (this.consumers >= this.maxConsumers) {
            throw new ResourceLimitException("Resource Limit Group '" + this.name + "': max consumers per connection exceeded. Resource limit is: " + this.maxConsumers);
        }
        ++this.consumers;
    }

    public synchronized void decConsumers() {
        --this.consumers;
        if (this.consumers < 0) {
            this.consumers = 0;
        }
    }

    public synchronized int getConsumers() {
        return this.consumers;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("[ResourceLimitGroup ");
        b.append(this.name);
        b.append(", maxConnections=");
        b.append(this.maxConnections);
        b.append(", maxSessions=");
        b.append(this.maxSessions);
        b.append(", sessions=");
        b.append(this.sessions);
        b.append(", maxTempQueues=");
        b.append(this.maxTempQueues);
        b.append(", tempQueues=");
        b.append(this.tempQueues);
        b.append(", maxProducers=");
        b.append(this.maxProducers);
        b.append(", producers=");
        b.append(this.producers);
        b.append(", maxConsumers=");
        b.append(this.maxConsumers);
        b.append(", consumers=");
        b.append(this.consumers);
        b.append("]");
        return b.toString();
    }
}

