/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.net;

import com.swiftmq.net.protocol.ProtocolInputHandler;
import com.swiftmq.net.protocol.ProtocolOutputHandler;
import com.swiftmq.swiftlet.Swiftlet;
import com.swiftmq.swiftlet.net.ConnectionMetaData;
import com.swiftmq.swiftlet.net.event.ConnectionListener;
import com.swiftmq.tools.sql.LikeComparator;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Iterator;

public class ListenerMetaData
extends ConnectionMetaData {
    InetAddress bindAddress;
    int port;
    HashSet hostAccessList = null;

    public ListenerMetaData(InetAddress bindAddress, int port, Swiftlet swiftlet, long keepAliveInterval, String socketFactoryClass, ConnectionListener connectionListener, int inputBufferSize, int inputExtendSize, int outputBufferSize, int outputExtendSize) {
        super(swiftlet, keepAliveInterval, socketFactoryClass, connectionListener, inputBufferSize, inputExtendSize, outputBufferSize, outputExtendSize, true);
        this.bindAddress = bindAddress;
        this.port = port;
    }

    public ListenerMetaData(InetAddress bindAddress, int port, Swiftlet swiftlet, long keepAliveInterval, String socketFactoryClass, ConnectionListener connectionListener, int inputBufferSize, int inputExtendSize, int outputBufferSize, int outputExtendSize, boolean useTcpNoDelay) {
        super(swiftlet, keepAliveInterval, socketFactoryClass, connectionListener, inputBufferSize, inputExtendSize, outputBufferSize, outputExtendSize, useTcpNoDelay);
        this.bindAddress = bindAddress;
        this.port = port;
    }

    public ListenerMetaData(InetAddress bindAddress, int port, Swiftlet swiftlet, long keepAliveInterval, String socketFactoryClass, ConnectionListener connectionListener, int inputBufferSize, int inputExtendSize, int outputBufferSize, int outputExtendSize, ProtocolInputHandler protocolInputHandler, ProtocolOutputHandler protocolOutputHandler) {
        super(swiftlet, keepAliveInterval, socketFactoryClass, connectionListener, inputBufferSize, inputExtendSize, outputBufferSize, outputExtendSize, true, protocolInputHandler, protocolOutputHandler);
        this.bindAddress = bindAddress;
        this.port = port;
    }

    public ListenerMetaData(InetAddress bindAddress, int port, Swiftlet swiftlet, long keepAliveInterval, String socketFactoryClass, ConnectionListener connectionListener, int inputBufferSize, int inputExtendSize, int outputBufferSize, int outputExtendSize, boolean useTcpNoDelay, ProtocolInputHandler protocolInputHandler, ProtocolOutputHandler protocolOutputHandler) {
        super(swiftlet, keepAliveInterval, socketFactoryClass, connectionListener, inputBufferSize, inputExtendSize, outputBufferSize, outputExtendSize, useTcpNoDelay, protocolInputHandler, protocolOutputHandler);
        this.bindAddress = bindAddress;
        this.port = port;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public int getPort() {
        return this.port;
    }

    public synchronized void addToHostAccessList(String predicate) {
        if (this.hostAccessList == null) {
            this.hostAccessList = new HashSet();
        }
        this.hostAccessList.add(predicate);
    }

    public synchronized void removeFromHostAccessList(String predicate) {
        if (this.hostAccessList != null) {
            this.hostAccessList.remove(predicate);
        }
    }

    public boolean isConnectionAllowed(String hostname) {
        if (this.hostAccessList == null) {
            return true;
        }
        boolean rc = false;
        Iterator iter = this.hostAccessList.iterator();
        while (iter.hasNext()) {
            if (!LikeComparator.compare(hostname, (String)iter.next(), '\\')) continue;
            rc = true;
            break;
        }
        return rc;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[ListenerMetaData, ");
        b.append(super.toString());
        b.append(", bindAddress=");
        b.append(this.bindAddress);
        b.append(", port=");
        b.append(this.port);
        b.append(", hostAccessList=");
        b.append(this.hostAccessList);
        b.append("]");
        return b.toString();
    }
}

