/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.queue;

import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.XidImpl;
import com.swiftmq.swiftlet.queue.FlowController;
import com.swiftmq.swiftlet.queue.MessageEntry;
import com.swiftmq.swiftlet.queue.MessageIndex;
import com.swiftmq.swiftlet.queue.MessageProcessor;
import com.swiftmq.swiftlet.queue.QueueException;
import com.swiftmq.swiftlet.queue.QueueTimeoutException;
import com.swiftmq.swiftlet.queue.Selector;
import com.swiftmq.swiftlet.queue.WireTapSubscriber;
import com.swiftmq.swiftlet.queue.event.QueueReceiverListener;
import com.swiftmq.swiftlet.store.CompositeStoreTransaction;
import com.swiftmq.swiftlet.store.PrepareLogRecord;
import com.swiftmq.tools.concurrent.AsyncCompletionCallback;
import java.util.List;
import java.util.SortedSet;

public abstract class AbstractQueue {
    public static final int SHARED = 0;
    public static final int EXCLUSIVE = 1;
    public static final int ACTIVESTANDBY = 2;
    public static final int AS_MESSAGE = 0;
    public static final int PERSISTENT = 1;
    public static final int NON_PERSISTENT = 2;
    protected volatile int maxMessages = -1;
    protected volatile int persistenceMode = 0;
    protected boolean temporary = false;
    protected FlowController flowController = null;
    protected int receiverCount = 0;
    protected long cleanUpInterval = 0L;
    protected int consumerMode = 0;
    String queueName;
    String localName;
    QueueReceiverListener queueReceiverListener = null;

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public int getCacheSize() {
        return 0;
    }

    public int getCacheSizeKB() {
        return 0;
    }

    public int getCurrentCacheSizeMessages() {
        return 0;
    }

    public int getCurrentCacheSizeKB() {
        return 0;
    }

    public boolean isAccounting() {
        return false;
    }

    public int getConsumerMode() {
        return this.consumerMode;
    }

    public void setConsumerMode(int consumerMode) {
        this.consumerMode = consumerMode;
    }

    public void startAccounting(Object accountingProfile) {
    }

    public void flushAccounting() {
    }

    public void stopAccounting() {
    }

    public void addWireTapSubscriber(String name, WireTapSubscriber subscriber) {
    }

    public void removeWireTapSubscriber(String name, WireTapSubscriber subscriber) {
    }

    public synchronized QueueReceiverListener getQueueReceiverListener() {
        return this.queueReceiverListener;
    }

    public synchronized void setQueueReceiverListener(QueueReceiverListener queueReceiverListener) {
        this.queueReceiverListener = queueReceiverListener;
    }

    public synchronized FlowController getFlowController() {
        return this.flowController;
    }

    public synchronized void setFlowController(FlowController flowController) {
        this.flowController = flowController;
        if (flowController != null) {
            flowController.setReceiverCount(this.receiverCount);
        }
    }

    public synchronized void incReceiverCount() {
        ++this.receiverCount;
        if (this.flowController != null) {
            this.flowController.setReceiverCount(this.receiverCount);
        }
        if (this.queueReceiverListener != null) {
            this.queueReceiverListener.receiverCountChanged(this, this.receiverCount);
        }
    }

    public synchronized void decReceiverCount() {
        --this.receiverCount;
        if (this.flowController != null) {
            this.flowController.setReceiverCount(this.receiverCount);
        }
        if (this.queueReceiverListener != null) {
            this.queueReceiverListener.receiverCountChanged(this, this.receiverCount);
        }
    }

    public synchronized int getReceiverCount() {
        return this.receiverCount;
    }

    public void receiverClosed(long receiverId) {
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean b) {
        this.temporary = b;
    }

    public int getPersistenceMode() {
        return this.persistenceMode;
    }

    public void setPersistenceMode(int persistenceMode) {
        this.persistenceMode = persistenceMode;
    }

    public void startQueue() throws QueueException {
    }

    public void stopQueue() throws QueueException {
    }

    public boolean isRunning() {
        return true;
    }

    public Object buildPreparedTransaction(PrepareLogRecord logRecord) throws QueueException {
        return null;
    }

    public int createView(Selector selector) {
        return -1;
    }

    public void deleteView(int viewId) {
    }

    public abstract Object createPushTransaction() throws QueueException;

    public abstract Object createPullTransaction() throws QueueException;

    public AbstractQueue selectBaseQueue() {
        return this;
    }

    public abstract void prepare(Object var1, XidImpl var2) throws QueueException;

    public abstract void commit(Object var1, XidImpl var2) throws QueueException;

    public abstract void commit(Object var1) throws QueueException;

    public abstract void commit(Object var1, AsyncCompletionCallback var2);

    public abstract void rollback(Object var1, XidImpl var2, boolean var3) throws QueueException;

    public abstract void rollback(Object var1, boolean var2) throws QueueException;

    public abstract void rollback(Object var1, boolean var2, AsyncCompletionCallback var3);

    public void cleanUpExpiredMessages() throws QueueException {
        throw new QueueException("operation is not supported");
    }

    public long getCleanUpInterval() throws QueueException {
        return this.cleanUpInterval;
    }

    public void setCleanUpInterval(long cleanUpInterval) {
        this.cleanUpInterval = cleanUpInterval;
    }

    public long getNumberQueueMessages() throws QueueException {
        return 0L;
    }

    public int getConsumingRate() {
        return 0;
    }

    public int getProducingRate() {
        return 0;
    }

    public int getConsumedTotal() {
        return 0;
    }

    public int getProducedTotal() {
        return 0;
    }

    public void resetCounters() {
    }

    public int getMonitorAlertThreshold() {
        return -1;
    }

    public MessageEntry getMessage(Object transactionId) throws QueueException {
        throw new QueueException("operation is not supported");
    }

    public MessageEntry getMessage(Object transactionId, Selector selector) throws QueueException {
        throw new QueueException("operation is not supported");
    }

    public MessageEntry getMessage(Object transactionId, Selector selector, int viewId) throws QueueException {
        throw new QueueException("operation is not supported");
    }

    public MessageEntry getMessage(Object transactionId, long timeout) throws QueueException, QueueTimeoutException {
        throw new QueueException("operation is not supported");
    }

    public MessageEntry getExpiredMessage(Object transactionId, long timeout) throws QueueException, QueueTimeoutException {
        throw new QueueException("operation is not supported");
    }

    public MessageEntry getMessage(Object transactionId, Selector selector, long timeout) throws QueueException, QueueTimeoutException {
        throw new QueueException("operation is not supported");
    }

    public MessageEntry getMessage(Object transactionId, Selector selector, int viewId, long timeout) throws QueueException, QueueTimeoutException {
        throw new QueueException("operation is not supported");
    }

    public void registerMessageProcessor(MessageProcessor messageProcessor) {
    }

    public void unregisterMessageProcessor(MessageProcessor messageProcessor) {
    }

    public void timeoutMessageProcessor(long registrationTime, int id) {
    }

    public void acknowledgeMessage(Object transactionId, MessageIndex messageIndex, AsyncCompletionCallback callback) {
    }

    public void acknowledgeMessages(Object transactionId, List messageIndexList, AsyncCompletionCallback callback) {
    }

    public void acknowledgeMessage(Object transactionId, MessageIndex messageIndex) throws QueueException {
        throw new QueueException("operation is not supported");
    }

    public long moveToTransactionReturnSize(MessageIndex messageIndex, Object sourceTxId, Object destTxId) throws QueueException {
        throw new QueueException("operation is not supported");
    }

    public void moveToTransaction(MessageIndex messageIndex, Object sourceTxId, Object destTxId) throws QueueException {
        this.moveToTransactionReturnSize(messageIndex, sourceTxId, destTxId);
    }

    public long moveToTransactionReturnSize(MessageIndex messageIndex, Object destTxId) throws QueueException {
        throw new QueueException("operation is not supported");
    }

    public void moveToTransaction(MessageIndex messageIndex, Object destTxId) throws QueueException {
        this.moveToTransactionReturnSize(messageIndex, destTxId);
    }

    public abstract boolean hasReceiver(MessageImpl var1);

    public abstract void putMessage(Object var1, MessageImpl var2) throws QueueException;

    public void removeMessages(Object transactionId, List<MessageIndex> messageIndexes) throws QueueException {
        throw new QueueException("operation is not supported");
    }

    public SortedSet getQueueIndex() throws QueueException {
        throw new QueueException("operation is not supported");
    }

    public SortedSet getQueueIndex(int viewId) throws QueueException {
        throw new QueueException("operation is not supported");
    }

    public MessageEntry getMessageByIndex(MessageIndex messageIndex) throws QueueException {
        throw new QueueException("operation is not supported");
    }

    public void removeMessageByIndex(MessageIndex messageIndex) throws QueueException {
        throw new QueueException("operation is not supported");
    }

    public MessageIndex getIndexEntry(MessageIndex messageIndex) throws QueueException {
        throw new QueueException("operation is not supported");
    }

    public void deleteContent() throws QueueException {
        throw new QueueException("operation is not supported");
    }

    public void lockQueue(Object txId) {
    }

    public void unlockQueue(Object txId, boolean markAsyncActive) {
    }

    public void unmarkAsyncActive(Object txId) {
    }

    public void setCompositeStoreTransaction(Object txId, CompositeStoreTransaction ct) {
    }

    public CompositeStoreTransaction getCompositeStoreTransaction(Object txId) {
        return null;
    }
}

