/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.queue;

public abstract class FlowController {
    protected int receiverCount = 0;
    protected int queueSize = 0;
    protected long lastDelay = 0L;
    protected long sentCount = 0L;
    protected long sentCountCalls = 0L;
    protected long receiveCount = 0L;
    protected long receiveCountCalls = 0L;
    protected long timestamp = 0L;

    public int getStartQueueSize() {
        return 0;
    }

    public synchronized void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public synchronized void setReceiverCount(int count) {
        if (count == 0) {
            this.sentCount = 0L;
            this.sentCountCalls = 0L;
            this.receiveCount = 0L;
            this.receiveCountCalls = 0L;
            this.timestamp = 0L;
        } else if (this.receiverCount == 0 && count > 0) {
            this.timestamp = System.currentTimeMillis();
            this.sentCount = this.queueSize;
            this.sentCountCalls = this.queueSize;
        }
        this.receiverCount = count;
    }

    public synchronized void setReceiveMessageCount(int count) {
        if (this.timestamp != 0L) {
            this.receiveCount += (long)count;
            ++this.receiveCountCalls;
        }
    }

    public synchronized void setSentMessageCount(int count) {
        if (this.timestamp != 0L) {
            this.sentCount += (long)count;
            ++this.sentCountCalls;
        }
    }

    public synchronized long getLastDelay() {
        return this.lastDelay;
    }

    public abstract long getNewDelay();

    public String toString() {
        StringBuffer b = new StringBuffer("[FlowController, ");
        b.append("timestamp=");
        b.append(this.timestamp);
        b.append(", receiveCount=");
        b.append(this.receiveCount);
        b.append(", receiveCountCalls=");
        b.append(this.receiveCountCalls);
        b.append(", sentCount=");
        b.append(this.sentCount);
        b.append(", sentCountCalls=");
        b.append(this.sentCountCalls);
        b.append("]");
        return b.toString();
    }
}

