/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.queue;

import com.swiftmq.mgmt.EntityList;
import com.swiftmq.swiftlet.queue.ActiveQueue;
import com.swiftmq.swiftlet.queue.MessageEntry;
import com.swiftmq.swiftlet.queue.MessageIndex;
import com.swiftmq.swiftlet.queue.QueueException;
import com.swiftmq.swiftlet.queue.QueueHandler;
import com.swiftmq.swiftlet.queue.QueueHandlerClosedException;
import com.swiftmq.swiftlet.queue.Selector;
import java.util.SortedSet;

public class QueueBrowser
extends QueueHandler {
    Selector selector = null;
    SortedSet queueIndex = null;
    MessageIndex lastMessageIndex = null;
    EntityList browserEntityList = null;
    int viewId = -1;

    public QueueBrowser(ActiveQueue activeQueue, Selector selector, EntityList browserEntityList) {
        super(activeQueue.getAbstractQueue());
        this.selector = selector;
        this.browserEntityList = browserEntityList;
    }

    public void setLastMessageIndex(MessageIndex lastMessageIndex) {
        this.lastMessageIndex = lastMessageIndex;
    }

    private MessageIndex getNextEntry(MessageIndex storeId) {
        MessageIndex rMessageIndex;
        block2: {
            block1: {
                rMessageIndex = null;
                if (storeId != null) break block1;
                if (this.queueIndex.size() <= 0) break block2;
                rMessageIndex = (MessageIndex)this.queueIndex.first();
                break block2;
            }
            for (MessageIndex s : this.queueIndex) {
                if (s.compareTo(storeId) <= 0) continue;
                rMessageIndex = s;
                break;
            }
        }
        return rMessageIndex;
    }

    public void resetBrowser() {
        this.queueIndex = null;
        this.lastMessageIndex = null;
        if (this.viewId != -1) {
            this.abstractQueue.deleteView(this.viewId);
        }
    }

    public synchronized MessageEntry getNextMessage() throws QueueException, QueueHandlerClosedException {
        this.verifyQueueHandlerState();
        MessageEntry me = null;
        if (this.queueIndex == null) {
            if (this.selector == null) {
                this.queueIndex = this.abstractQueue.getQueueIndex();
            } else {
                this.viewId = this.abstractQueue.createView(this.selector);
                this.queueIndex = this.abstractQueue.getQueueIndex(this.viewId);
            }
        }
        boolean found = false;
        while (!found) {
            MessageIndex s = this.getNextEntry(this.lastMessageIndex);
            if (s == null) {
                found = true;
                continue;
            }
            this.lastMessageIndex = s;
            MessageEntry m = this.abstractQueue.getMessageByIndex(s);
            if (m == null) continue;
            me = m;
            found = true;
        }
        return me;
    }

    @Override
    public void close() throws QueueException, QueueHandlerClosedException {
        super.close();
        if (this.browserEntityList != null) {
            this.browserEntityList.removeDynamicEntity(this);
            this.browserEntityList = null;
        }
        this.queueIndex = null;
        this.lastMessageIndex = null;
        if (this.viewId != -1) {
            this.abstractQueue.deleteView(this.viewId);
        }
    }
}

