/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.queue;

import com.swiftmq.jms.BytesMessageImpl;
import com.swiftmq.jms.QueueImpl;
import com.swiftmq.swiftlet.queue.QueuePushTransaction;
import com.swiftmq.swiftlet.queue.QueueSender;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;

public class QueueOutputStream
extends OutputStream {
    public static String SEQNO = "QIO$SEQNO";
    public static String SIZE = "QIO$SIZE";
    public static String EOF = "QIO$EOF";
    QueueSender queueSender;
    QueueImpl queue;
    QueuePushTransaction transaction = null;
    Hashtable customMsgProp;
    int deliveryMode = 1;
    BytesMessageImpl currentMsg;
    int chunkSize = 1024;
    int count = 0;
    int seqNo = 0;
    boolean respectFlowControl = true;

    public QueueOutputStream(QueueSender queueSender, QueueImpl destination) {
        this.queueSender = queueSender;
        this.queue = destination;
    }

    public QueueOutputStream(QueueSender queueSender, QueueImpl destination, int chunkSize) {
        this.queueSender = queueSender;
        this.chunkSize = chunkSize;
        this.queue = destination;
    }

    public QueueOutputStream(QueueSender queueSender, QueueImpl destination, Hashtable customMsgProp, int chunkSize) {
        this.queueSender = queueSender;
        this.customMsgProp = customMsgProp;
        this.chunkSize = chunkSize;
        this.queue = destination;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public void setRespectFlowControl(boolean respectFlowControl) {
        this.respectFlowControl = respectFlowControl;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    private void ensureMessage() {
        if (this.currentMsg == null) {
            this.currentMsg = new BytesMessageImpl();
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        try {
            this.ensureMessage();
            if (this.count >= this.chunkSize) {
                this.flush();
                this.ensureMessage();
            }
            this.currentMsg.writeByte((byte)b);
            ++this.count;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.currentMsg == null) {
            return;
        }
        try {
            long delay;
            if (this.customMsgProp != null && this.seqNo == 0) {
                for (Map.Entry entry : this.customMsgProp.entrySet()) {
                    this.currentMsg.setObjectProperty((String)entry.getKey(), entry.getValue());
                }
            }
            this.currentMsg.setJMSDeliveryMode(this.deliveryMode);
            this.currentMsg.setJMSDestination(this.queue);
            this.currentMsg.setIntProperty(SIZE, this.count);
            this.currentMsg.setIntProperty(SEQNO, this.seqNo);
            this.transaction = this.queueSender.createTransaction();
            this.transaction.putMessage(this.currentMsg);
            this.transaction.commit();
            if (this.respectFlowControl && (delay = this.queueSender.getFlowControlDelay()) > 0L) {
                try {
                    Thread.sleep(delay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.currentMsg = null;
            ++this.seqNo;
            this.count = 0;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.ensureMessage();
        try {
            this.currentMsg.setBooleanProperty(EOF, true);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        this.flush();
    }
}

