/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.queue;

import com.swiftmq.jms.XidImpl;
import com.swiftmq.swiftlet.queue.AbstractQueue;
import com.swiftmq.swiftlet.queue.MessageEntry;
import com.swiftmq.swiftlet.queue.MessageIndex;
import com.swiftmq.swiftlet.queue.MessageProcessor;
import com.swiftmq.swiftlet.queue.QueueException;
import com.swiftmq.swiftlet.queue.QueueTimeoutException;
import com.swiftmq.swiftlet.queue.QueueTransaction;
import com.swiftmq.swiftlet.queue.QueueTransactionClosedException;
import com.swiftmq.swiftlet.queue.QueueTransactionHandler;
import com.swiftmq.swiftlet.queue.Selector;
import com.swiftmq.tools.concurrent.AsyncCompletionCallback;
import java.util.List;

public class QueuePullTransaction
extends QueueTransaction {
    boolean setRedeliveredOnRollback;
    Selector selector = null;
    int viewId = -1;
    long receiverId = -1L;

    QueuePullTransaction(AbstractQueue abstractQueue, Object transactionId, QueueTransactionHandler queueTransactionHandler, boolean setRedeliveredOnRollback) {
        super(abstractQueue, transactionId, queueTransactionHandler);
        this.setRedeliveredOnRollback = setRedeliveredOnRollback;
    }

    public QueuePullTransaction() {
    }

    void restart(AbstractQueue abstractQueue, Object transactionId, QueueTransactionHandler queueTransactionHandler, boolean setRedeliveredOnRollback) {
        super.restart(abstractQueue, transactionId, queueTransactionHandler);
        this.setRedeliveredOnRollback = setRedeliveredOnRollback;
    }

    void setView(Selector selector, int viewId) {
        this.selector = selector;
        this.viewId = viewId;
    }

    void setReceiverId(long receiverId) {
        this.receiverId = receiverId;
    }

    public MessageEntry getMessage() throws QueueTransactionClosedException, QueueException {
        this.verifyTransactionState();
        return this.viewId == -1 ? this.abstractQueue.getMessage(this.transactionId) : this.abstractQueue.getMessage(this.transactionId, this.selector, this.viewId);
    }

    public MessageEntry getMessage(Selector selector) throws QueueTransactionClosedException, QueueException {
        this.verifyTransactionState();
        return this.viewId == -1 ? this.abstractQueue.getMessage(this.transactionId, selector) : this.abstractQueue.getMessage(this.transactionId, selector, this.viewId);
    }

    public MessageEntry getMessage(long timeout) throws QueueTransactionClosedException, QueueException, QueueTimeoutException {
        this.verifyTransactionState();
        return this.viewId == -1 ? this.abstractQueue.getMessage(this.transactionId, timeout) : this.abstractQueue.getMessage(this.transactionId, this.selector, this.viewId, timeout);
    }

    public MessageEntry getExpiredMessage(long timeout) throws QueueTransactionClosedException, QueueException, QueueTimeoutException {
        this.verifyTransactionState();
        return this.abstractQueue.getExpiredMessage(this.transactionId, timeout);
    }

    public MessageEntry getMessage(long timeout, Selector selector) throws QueueTransactionClosedException, QueueException, QueueTimeoutException {
        this.verifyTransactionState();
        return this.viewId == -1 ? this.abstractQueue.getMessage(this.transactionId, selector, timeout) : this.abstractQueue.getMessage(this.transactionId, selector, this.viewId, timeout);
    }

    public void removeMessages(List<MessageIndex> messageIndexes) throws QueueTransactionClosedException, QueueException {
        this.verifyTransactionState();
        this.abstractQueue.removeMessages(this.transactionId, messageIndexes);
    }

    public void registerMessageProcessor(MessageProcessor messageProcessor) throws QueueTransactionClosedException, QueueException {
        this.verifyTransactionState();
        messageProcessor.setTransactionId(this.transactionId);
        messageProcessor.setViewId(this.viewId);
        messageProcessor.setReceiverId(this.receiverId);
        this.abstractQueue.registerMessageProcessor(messageProcessor);
    }

    public void unregisterMessageProcessor(MessageProcessor messageProcessor) throws QueueTransactionClosedException, QueueException {
        this.verifyTransactionState();
        this.abstractQueue.unregisterMessageProcessor(messageProcessor);
    }

    public void acknowledgeMessage(MessageIndex messageIndex) throws QueueTransactionClosedException, QueueException {
        this.verifyTransactionState();
        this.abstractQueue.acknowledgeMessage(this.transactionId, messageIndex);
    }

    public void acknowledgeMessage(MessageIndex messageIndex, AsyncCompletionCallback callback) throws QueueTransactionClosedException {
        this.verifyTransactionState();
        this.abstractQueue.acknowledgeMessage(this.transactionId, messageIndex, callback);
    }

    public void acknowledgeMessages(List messageIndexList, AsyncCompletionCallback callback) throws QueueTransactionClosedException {
        this.verifyTransactionState();
        this.abstractQueue.acknowledgeMessages(this.transactionId, messageIndexList, callback);
    }

    public void moveToTransaction(MessageIndex messageIndex, QueuePullTransaction sourceTransaction) throws QueueTransactionClosedException, QueueException {
        this.verifyTransactionState();
        this.abstractQueue.moveToTransaction(messageIndex, sourceTransaction.transactionId, this.transactionId);
    }

    public long moveToTransactionReturnSize(MessageIndex messageIndex, QueuePullTransaction sourceTransaction) throws QueueTransactionClosedException, QueueException {
        this.verifyTransactionState();
        return this.abstractQueue.moveToTransactionReturnSize(messageIndex, sourceTransaction.transactionId, this.transactionId);
    }

    public void moveToTransaction(MessageIndex messageIndex) throws QueueTransactionClosedException, QueueException {
        this.verifyTransactionState();
        this.abstractQueue.moveToTransaction(messageIndex, this.transactionId);
    }

    public long moveToTransactionReturnSize(MessageIndex messageIndex) throws QueueTransactionClosedException, QueueException {
        this.verifyTransactionState();
        return this.abstractQueue.moveToTransactionReturnSize(messageIndex, this.transactionId);
    }

    @Override
    public void rollback(XidImpl globalTransactionId, boolean setRedelivered) throws QueueException, QueueTransactionClosedException {
        this.verifyTransactionState();
        this.setClosed(true);
        this.abstractQueue.rollback(this.transactionId, globalTransactionId, this.setRedeliveredOnRollback);
    }

    @Override
    public void rollback() throws QueueException, QueueTransactionClosedException {
        this.verifyTransactionState();
        this.setClosed(true);
        this.abstractQueue.rollback(this.transactionId, this.setRedeliveredOnRollback);
    }
}

