/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.swiftlet.queue;

import com.swiftmq.jms.XidImpl;
import com.swiftmq.swiftlet.queue.AbstractQueue;
import com.swiftmq.swiftlet.queue.QueueException;
import com.swiftmq.swiftlet.queue.QueueTransactionClosedException;
import com.swiftmq.swiftlet.queue.QueueTransactionHandler;
import com.swiftmq.swiftlet.store.CompositeStoreTransaction;
import com.swiftmq.tools.gc.Recyclable;

public abstract class QueueTransaction
implements Recyclable {
    AbstractQueue abstractQueue;
    boolean closed = false;
    boolean prepared = false;
    Object transactionId;
    QueueTransactionHandler queueTransactionHandler;
    int recycleIndex = -1;
    boolean doRollbackOnClose = true;

    QueueTransaction(AbstractQueue abstractQueue, Object transactionId, QueueTransactionHandler queueTransactionHandler) {
        this.abstractQueue = abstractQueue;
        this.transactionId = transactionId;
        this.queueTransactionHandler = queueTransactionHandler;
        this.setClosed(false);
    }

    public QueueTransaction() {
    }

    void restart(AbstractQueue abstractQueue, Object transactionId, QueueTransactionHandler queueTransactionHandler) {
        this.abstractQueue = abstractQueue;
        this.transactionId = transactionId;
        this.queueTransactionHandler = queueTransactionHandler;
        this.doRollbackOnClose = true;
        this.setClosed(false);
    }

    public AbstractQueue getAbstractQueue() {
        return this.abstractQueue;
    }

    public boolean isDoRollbackOnClose() {
        return this.doRollbackOnClose;
    }

    public void setDoRollbackOnClose(boolean doRollbackOnClose) {
        this.doRollbackOnClose = doRollbackOnClose;
    }

    @Override
    public int getRecycleIndex() {
        return this.recycleIndex;
    }

    @Override
    public void setRecycleIndex(int recycleIndex) {
        this.recycleIndex = recycleIndex;
    }

    @Override
    public void reset() {
    }

    public String getQueueName() {
        return this.abstractQueue.getQueueName();
    }

    protected AbstractQueue getQueue() {
        return this.abstractQueue;
    }

    public boolean isQueueRunning() {
        return this.abstractQueue.isRunning();
    }

    public boolean isTemporaryQueue() {
        return this.abstractQueue.isTemporary();
    }

    public void prepare(XidImpl globalTransactionId) throws QueueException, QueueTransactionClosedException {
        this.verifyTransactionState();
        this.abstractQueue.prepare(this.transactionId, globalTransactionId);
        this.prepared = true;
    }

    public void commit(XidImpl globalTransactionId) throws QueueException, QueueTransactionClosedException {
        this.verifyTransactionState();
        this.setClosed(true);
        this.abstractQueue.commit(this.transactionId, globalTransactionId);
        this.prepared = false;
    }

    public void commit() throws QueueException, QueueTransactionClosedException {
        this.verifyTransactionState();
        this.setClosed(true);
        this.abstractQueue.commit(this.transactionId);
    }

    public abstract void rollback(XidImpl var1, boolean var2) throws QueueException, QueueTransactionClosedException;

    public abstract void rollback() throws QueueException, QueueTransactionClosedException;

    public boolean isClosed() {
        return this.closed;
    }

    void setClosed(boolean closed) {
        this.closed = closed;
        if (closed) {
            this.queueTransactionHandler.recycler.checkIn(this);
        }
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    protected void verifyTransactionState() throws QueueTransactionClosedException {
        if (this.isClosed()) {
            throw new QueueTransactionClosedException("transaction is closed!");
        }
    }

    public void lockQueue() {
        this.abstractQueue.lockQueue(this.transactionId);
    }

    public void unlockQueue(boolean markAsyncActive) {
        this.abstractQueue.unlockQueue(this.transactionId, markAsyncActive);
    }

    public void unmarkAsyncActive() {
        this.abstractQueue.unmarkAsyncActive(this.transactionId);
    }

    public CompositeStoreTransaction getCompositeStoreTransaction() {
        return this.abstractQueue.getCompositeStoreTransaction(this.transactionId);
    }

    public void setCompositeStoreTransaction(CompositeStoreTransaction ct) {
        this.abstractQueue.setCompositeStoreTransaction(this.transactionId, ct);
    }
}

