/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.collection;

public class IntRingBuffer {
    int[] elements;
    int first = 0;
    int size = 0;
    int extendSize = 32;

    public IntRingBuffer(int extendSize) {
        this.extendSize = extendSize;
        this.elements = new int[extendSize];
    }

    public IntRingBuffer(IntRingBuffer base) {
        this.extendSize = base.extendSize;
        this.first = base.first;
        this.size = base.size;
        this.elements = new int[base.extendSize];
        System.arraycopy(base.elements, 0, this.elements, 0, base.elements.length);
    }

    public void add(int obj) {
        if (this.size == this.elements.length) {
            int newSize = this.elements.length + this.extendSize;
            int[] newElements = new int[newSize];
            int n = this.elements.length - this.first;
            System.arraycopy(this.elements, this.first, newElements, 0, n);
            if (this.first != 0) {
                System.arraycopy(this.elements, 0, newElements, n, this.first);
            }
            this.elements = newElements;
            this.first = 0;
        }
        this.elements[(this.first + this.size) % this.elements.length] = obj;
        ++this.size;
    }

    public int remove() {
        int obj = this.elements[this.first];
        ++this.first;
        --this.size;
        if (this.first == this.elements.length) {
            this.first = 0;
        }
        return obj;
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        this.first = 0;
        this.size = 0;
    }
}

