/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.concurrent;

import com.swiftmq.tools.concurrent.AsyncCompletionCallback;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class CallbackJoin {
    protected volatile boolean finalSuccess = true;
    protected volatile Object finalResult = null;
    protected volatile Exception finalException = null;
    AtomicInteger numberCallbacks = new AtomicInteger();
    volatile boolean blocked = true;
    AsyncCompletionCallback next;

    protected CallbackJoin(AsyncCompletionCallback next) {
        this.next = next;
    }

    protected CallbackJoin() {
    }

    private synchronized AsyncCompletionCallback getNext() {
        if (this.blocked || this.next == null) {
            return null;
        }
        AsyncCompletionCallback myNext = this.next;
        this.next = null;
        return myNext;
    }

    private void checkNext() {
        AsyncCompletionCallback theNext = this.getNext();
        if (theNext != null) {
            theNext.setException(this.finalException);
            theNext.setResult(this.finalResult);
            theNext.notifyCallbackStack(this.finalSuccess);
        }
    }

    public void incNumberCallbacks() {
        this.numberCallbacks.incrementAndGet();
    }

    public void setNumberCallbacks(int numberCallbacks) {
        this.numberCallbacks.set(numberCallbacks);
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
        if (this.numberCallbacks.get() == 0) {
            this.checkNext();
        }
    }

    public void done(AsyncCompletionCallback callback, boolean success) {
        int n = this.numberCallbacks.decrementAndGet();
        this.callbackDone(callback, success, n == 0);
        if (n == 0) {
            this.checkNext();
        }
    }

    protected abstract void callbackDone(AsyncCompletionCallback var1, boolean var2, boolean var3);
}

