/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Semaphore {
    boolean notified = false;
    boolean interruptable = true;
    Lock lock = new ReentrantLock();
    Condition waiter = null;
    TimeUnit unit = TimeUnit.MILLISECONDS;

    public Semaphore(boolean interruptable) {
        this.interruptable = interruptable;
        this.waiter = this.lock.newCondition();
    }

    public Semaphore() {
        this(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitHere() {
        this.lock.lock();
        try {
            while (!this.notified) {
                try {
                    if (this.interruptable) {
                        this.waiter.await();
                        continue;
                    }
                    this.waiter.awaitUninterruptibly();
                }
                catch (Exception exception) {}
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitHere(long ms) {
        this.lock.lock();
        try {
            long nanos = this.unit.toNanos(ms);
            while (!this.notified && nanos > 0L) {
                try {
                    nanos = this.waiter.awaitNanos(nanos);
                }
                catch (Exception exception) {}
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void notifySingleWaiter() {
        this.lock.lock();
        try {
            this.notified = true;
            this.waiter.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void notifyAllWaiters() {
        this.lock.lock();
        try {
            this.notified = true;
            this.waiter.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isNotified() {
        this.lock.lock();
        try {
            boolean bl = this.notified;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        this.lock.lock();
        try {
            this.notified = false;
        }
        finally {
            this.lock.unlock();
        }
    }
}

