/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.deploy;

import com.swiftmq.tools.deploy.Bundle;
import com.swiftmq.tools.deploy.BundleEvent;
import com.swiftmq.tools.deploy.BundleJar;
import com.swiftmq.tools.deploy.ExtendableClassLoader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DeployPath {
    static final String CONFIG = "config.xml";
    static final String JAR = ".jar";
    static final String INTERNAL_DEPLOY_DIR = "_deployed_";
    static final String DELETED = ".deleted";
    File path = null;
    ClassLoader parentCL = null;
    ExtendableClassLoader classLoader = null;
    HashMap bundles = new HashMap();
    long startTime = System.currentTimeMillis();

    public DeployPath(File path, ClassLoader parentCL) {
        this.path = path;
        this.parentCL = parentCL;
    }

    public DeployPath(File path, boolean singleLoader, ClassLoader parentCL) {
        this.path = path;
        this.parentCL = parentCL;
        if (singleLoader) {
            try {
                this.classLoader = new ExtendableClassLoader(path, new URL[]{path.toURI().toURL()}, parentCL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.collectJars();
        }
    }

    private void collectJars() {
        File[] files = this.path.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory() || !files[i].getName().endsWith(JAR)) continue;
                try {
                    this.classLoader.add(files[i].toURI().toURL());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void init() {
        this.bundles.clear();
        this.startTime = System.currentTimeMillis();
    }

    public File getPath() {
        return this.path;
    }

    private String loadConfigFile(File f) throws Exception {
        StringWriter writer = new StringWriter((int)f.length());
        BufferedReader reader = new BufferedReader(new FileReader(f));
        String line = null;
        while ((line = reader.readLine()) != null) {
            writer.write(line + "\n");
        }
        reader.close();
        writer.flush();
        return writer.toString();
    }

    private void checkConfigFile(Bundle bundle, File f) throws Exception {
        if (bundle.getChangeTimeConfig() != f.lastModified() || bundle.getBundleConfig() == null) {
            bundle.setBundleConfig(this.loadConfigFile(f), f.lastModified());
            if (bundle.getEvent() == -1) {
                bundle.setEvent(2);
            }
        }
    }

    private void checkBundleJars(Bundle bundle, List jarFiles) throws Exception {
        ArrayList<BundleJar> bundleJars = null;
        if (jarFiles != null) {
            bundleJars = new ArrayList<BundleJar>();
            ArrayList<URL> urls = new ArrayList<URL>();
            for (File f : jarFiles) {
                urls.add(f.toURI().toURL());
                BundleJar bundleJar = new BundleJar(f.getName(), f.lastModified());
                bundleJars.add(bundleJar);
            }
            if (this.classLoader != null) {
                this.classLoader.add(urls.toArray(new URL[urls.size()]));
                bundle.setBundleLoader(this.classLoader);
            }
            if (bundle.getEvent() == -1) {
                List oldBundleJars = bundle.getBundleJars();
                if (oldBundleJars == null) {
                    bundle.setEvent(0);
                } else {
                    Iterator iter2;
                    boolean found;
                    int event = -1;
                    Iterator iter = bundleJars.iterator();
                    while (iter.hasNext() && event == -1) {
                        BundleJar newBundleJar = (BundleJar)iter.next();
                        found = false;
                        iter2 = oldBundleJars.iterator();
                        while (iter2.hasNext() && event == -1 && !found) {
                            BundleJar oldBundleJar = (BundleJar)iter2.next();
                            if (!newBundleJar.getFilename().equals(oldBundleJar.getFilename())) continue;
                            found = true;
                            if (newBundleJar.getLastModified() == oldBundleJar.getLastModified()) continue;
                            event = 2;
                        }
                        if (found) continue;
                        event = 2;
                    }
                    if (event == -1) {
                        iter = oldBundleJars.iterator();
                        while (iter.hasNext() && event == -1) {
                            BundleJar oldBundleJar = (BundleJar)iter.next();
                            found = false;
                            iter2 = bundleJars.iterator();
                            while (iter2.hasNext() && event == -1 && !found) {
                                BundleJar newBundleJar = (BundleJar)iter2.next();
                                if (!newBundleJar.getFilename().equals(oldBundleJar.getFilename())) continue;
                                found = true;
                            }
                            if (found) continue;
                            event = 2;
                        }
                    }
                    bundle.setEvent(event);
                }
            }
        }
        bundle.setBundleJars(bundleJars);
    }

    private void checkDirectory(File dir) throws Exception {
        Bundle bundle = (Bundle)this.bundles.get(dir.getName());
        if (bundle == null) {
            bundle = new Bundle(dir.getName());
            bundle.setEvent(0);
            this.bundles.put(bundle.getBundleName(), bundle);
        }
        File[] flist = dir.listFiles();
        ArrayList<File> jarFiles = null;
        if (flist != null) {
            for (int i = 0; i < flist.length; ++i) {
                if (flist[i].isDirectory()) continue;
                String fn = flist[i].getName();
                if (fn.equals(CONFIG)) {
                    this.checkConfigFile(bundle, flist[i]);
                    continue;
                }
                if (!fn.endsWith(JAR)) continue;
                if (jarFiles == null) {
                    jarFiles = new ArrayList<File>();
                }
                jarFiles.add(flist[i]);
            }
        }
        this.checkBundleJars(bundle, jarFiles);
    }

    private void checkRemovedBundles() throws Exception {
        Iterator iter = this.bundles.entrySet().iterator();
        while (iter.hasNext()) {
            Bundle bundle = (Bundle)iter.next().getValue();
            if (bundle.getEvent() != -1) continue;
            String fn = this.path.getPath() + File.separatorChar + bundle.getBundleName();
            File f = new File(fn);
            if (!f.exists()) {
                bundle.setEvent(1);
                continue;
            }
            File configFile = new File(f, CONFIG);
            if (!configFile.exists()) {
                bundle.setEvent(1);
                continue;
            }
            if (bundle.getBundleJars() != null) continue;
            bundle.setEvent(1);
        }
    }

    private void removeDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.removeDirectory(files[i]);
                }
                files[i].delete();
            }
        }
        dir.delete();
    }

    private URL copyFile(File f, String dir) throws Exception {
        File dest = new File(dir + File.separatorChar + f.getName());
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(f), 16384);
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(dest), 16384);
        byte[] b = new byte[16384];
        int len = 0;
        while ((len = fis.read(b)) != -1) {
            fos.write(b, 0, len);
        }
        fos.flush();
        fis.close();
        fos.close();
        dest.setLastModified(f.lastModified());
        return dest.toURI().toURL();
    }

    private void createInternalDeployment(Bundle bundle) throws Exception {
        String bundleDirName = this.path.getPath() + File.separatorChar + bundle.getBundleName();
        String intDeployDirName = bundleDirName + File.separatorChar + INTERNAL_DEPLOY_DIR + System.currentTimeMillis();
        bundle.setBundleDir(intDeployDirName);
        File bundleDir = new File(bundleDirName);
        File intDeployDir = new File(intDeployDirName);
        intDeployDir.mkdir();
        File[] sources = bundleDir.listFiles();
        if (sources != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (int i = 0; i < sources.length; ++i) {
                if (sources[i].getName().equals(CONFIG)) {
                    this.copyFile(sources[i], intDeployDirName);
                    continue;
                }
                if (sources[i].getName().endsWith(JAR)) {
                    urls.add(this.copyFile(sources[i], intDeployDirName));
                    continue;
                }
                if (sources[i].isDirectory()) continue;
                this.copyFile(sources[i], intDeployDirName);
            }
            bundle.setBundleLoader(new ExtendableClassLoader(intDeployDir, urls.toArray(new URL[urls.size()]), this.parentCL));
        }
    }

    private boolean isDeleted(File dir) {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().equals(DeployPath.DELETED);
            }
        });
        return files != null && files.length > 0;
    }

    private void purgeBundleDir(File dir) {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith(DeployPath.INTERNAL_DEPLOY_DIR) && DeployPath.this.isDeleted(file);
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.removeDirectory(files[i]);
            }
        }
    }

    public synchronized void purge() {
        File[] files = this.path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.purgeBundleDir(files[i]);
            }
        }
    }

    private Bundle getInstalledBundle(File dir) throws Exception {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !DeployPath.this.isDeleted(file);
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        Bundle bundle = new Bundle(dir.getName());
        bundle.setBundleDir(files[0].getPath());
        File[] sources = files[0].listFiles();
        if (sources != null) {
            ArrayList<BundleJar> bundleJars = new ArrayList<BundleJar>();
            ArrayList<URL> urls = new ArrayList<URL>();
            for (int i = 0; i < sources.length; ++i) {
                if (sources[i].getName().equals(CONFIG)) {
                    bundle.setBundleConfig(this.loadConfigFile(sources[i]), sources[i].lastModified());
                    continue;
                }
                if (!sources[i].getName().endsWith(JAR)) continue;
                urls.add(sources[i].toURI().toURL());
                bundleJars.add(new BundleJar(sources[i].getName(), sources[i].lastModified()));
            }
            bundle.setBundleJars(bundleJars);
            bundle.setBundleLoader(new ExtendableClassLoader(dir, urls.toArray(new URL[urls.size()]), this.parentCL));
        }
        this.bundles.put(bundle.getBundleName(), bundle);
        return bundle;
    }

    public synchronized List getInstalledBundles() throws Exception {
        ArrayList<Bundle> list = null;
        File[] files = this.path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                Bundle b = this.getInstalledBundle(files[i]);
                if (b == null) continue;
                if (list == null) {
                    list = new ArrayList<Bundle>();
                }
                list.add(b);
            }
        }
        return list;
    }

    private void markDeleted(Bundle bundle) {
        String bundleDir = bundle.getBundleDir();
        if (bundleDir == null) {
            return;
        }
        File f = new File(bundle.getBundleDir() + File.separatorChar + DELETED);
        try {
            f.createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void removeBundle(Bundle bundle) {
        this.bundles.remove(bundle.getBundleName());
        this.markDeleted(bundle);
    }

    public synchronized BundleEvent[] getBundleEvents() throws Exception {
        BundleEvent bundleEvent;
        Bundle bundle;
        File[] flist = this.path.listFiles();
        if (flist != null) {
            for (int i = 0; i < flist.length; ++i) {
                if (!flist[i].isDirectory()) continue;
                this.checkDirectory(flist[i]);
            }
        }
        this.checkRemovedBundles();
        ArrayList<BundleEvent> al = null;
        Iterator iter = this.bundles.entrySet().iterator();
        while (iter.hasNext()) {
            bundle = (Bundle)iter.next().getValue();
            if (bundle.getEvent() != 1) continue;
            if (al == null) {
                al = new ArrayList<BundleEvent>();
            }
            bundleEvent = new BundleEvent(bundle.getEvent(), bundle);
            iter.remove();
            this.markDeleted(bundle);
            al.add(bundleEvent);
        }
        iter = this.bundles.entrySet().iterator();
        while (iter.hasNext()) {
            bundle = (Bundle)iter.next().getValue();
            if (bundle.getEvent() != 0 && bundle.getEvent() != 2 || bundle.getBundleConfig() == null || bundle.getBundleJars() == null) continue;
            if (this.classLoader == null) {
                if (bundle.getEvent() == 2) {
                    this.markDeleted(bundle);
                }
                this.createInternalDeployment(bundle);
            }
            if (al == null) {
                al = new ArrayList();
            }
            bundleEvent = new BundleEvent(bundle.getEvent(), bundle);
            al.add(bundleEvent);
            bundle.setEvent(-1);
        }
        if (al == null || al.size() == 0) {
            return null;
        }
        return al.toArray(new BundleEvent[al.size()]);
    }

    public String toString() {
        return "[DeployPath, path=" + this.path + ", bundles=" + this.bundles + "]";
    }
}

