/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.deploy;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

public class ExtendableClassLoader
extends URLClassLoader {
    File root = null;
    long created = 0L;

    public ExtendableClassLoader(File root, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.root = root;
        this.created = System.currentTimeMillis();
    }

    public void add(URL url) {
        this.addURL(url);
    }

    public void add(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            this.addURL(urls[i]);
        }
    }

    Class _findClass(String name) throws ClassNotFoundException {
        return this.findClass(name);
    }

    @Override
    protected String findLibrary(String libname) {
        String lib = System.mapLibraryName(libname);
        File[] files = this.root.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    File[] df = files[i].listFiles();
                    for (int j = 0; j < df.length; ++j) {
                        if (!df[j].getName().equals(lib)) continue;
                        return df[j].getAbsolutePath();
                    }
                    continue;
                }
                if (!files[i].getName().equals(lib)) continue;
                return files[i].getAbsolutePath();
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        URL[] urls = this.getURLs();
        b.append("[ExtendableClassLoader, created=" + this.created + ", urls=");
        for (int i = 0; i < urls.length; ++i) {
            if (i > 0) {
                b.append(",");
            }
            b.append(urls[i].toString());
        }
        b.append("]");
        return b.toString();
    }
}

