/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.file;

import com.swiftmq.tools.file.NumberGenerationProvider;
import com.swiftmq.tools.file.RolloverSizeProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Arrays;

public class GenerationalFileWriter
extends Writer {
    static DecimalFormat FMTROTATE = new DecimalFormat("'-'000'.log'");
    String directory = null;
    String filename = null;
    File file = null;
    FileWriter writer = null;
    long length = 0L;
    int generation = 0;
    RolloverSizeProvider rolloverSizeProvider = null;
    NumberGenerationProvider numberGenerationProvider = null;

    public GenerationalFileWriter(String directory, String filename, RolloverSizeProvider rolloverSizeProvider, NumberGenerationProvider numberGenerationProvider) throws IOException {
        this.directory = directory;
        this.filename = filename;
        this.rolloverSizeProvider = rolloverSizeProvider;
        this.numberGenerationProvider = numberGenerationProvider;
        this.newLogfile();
    }

    public static void main(String[] args) {
        System.setOut(new PrintStream(new OutputStream(){
            byte[] buffer = new byte[1];
            Writer writer = null;

            @Override
            public void write(byte[] bytes) throws IOException {
                this.checkWriter();
                this.writer.write(new String(bytes));
            }

            @Override
            public void write(byte[] bytes, int i, int i1) throws IOException {
                this.checkWriter();
                this.writer.write(new String(bytes, i, i1));
            }

            @Override
            public void flush() throws IOException {
                this.checkWriter();
                this.writer.flush();
            }

            @Override
            public void close() throws IOException {
                this.checkWriter();
                this.writer.close();
            }

            @Override
            public void write(int i) throws IOException {
                this.checkWriter();
                this.buffer[0] = (byte)i;
                this.writer.write(new String(this.buffer));
            }

            private void checkWriter() throws IOException {
                if (this.writer == null) {
                    this.writer = new GenerationalFileWriter(".", "test", new RolloverSizeProvider(){

                        @Override
                        public long getRollOverSize() {
                            return 100L;
                        }
                    }, new NumberGenerationProvider(){

                        @Override
                        public int getNumberGenerations() {
                            return 10;
                        }
                    });
                }
            }
        }));
        for (int i = 0; i < 100; ++i) {
            System.out.println("Dies ist Zeile " + i);
        }
    }

    private void checkGenerations() throws IOException {
        File dir = new File(this.directory);
        if (!dir.exists()) {
            dir.mkdir();
            return;
        }
        Object[] names = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.startsWith(GenerationalFileWriter.this.filename) && name.endsWith(".log");
            }
        });
        if (names != null) {
            Arrays.sort(names);
            for (int i = 0; i < names.length; ++i) {
                int logIdx = ((String)names[i]).indexOf(".log");
                if (logIdx - 3 < 0) continue;
                int g = Integer.parseInt(((String)names[i]).substring(logIdx - 3, logIdx));
                this.generation = Math.max(g, this.generation);
            }
            int todDel = names.length - this.numberGenerationProvider.getNumberGenerations();
            if (this.generation == 999) {
                this.generation = 0;
                todDel = names.length;
            }
            if (todDel > 0) {
                for (int i = 0; i < todDel; ++i) {
                    new File(dir, (String)names[i]).delete();
                }
            }
        }
    }

    private void newLogfile() throws IOException {
        this.checkGenerations();
        this.file = new File(this.directory + File.separator + this.filename + FMTROTATE.format(this.generation++));
        this.length = this.file.exists() ? this.file.length() : 0L;
        this.writer = new FileWriter(this.file, true);
    }

    private void checkRolling() throws IOException {
        long max = this.rolloverSizeProvider.getRollOverSize();
        if (max == -1L) {
            return;
        }
        if (this.length > max) {
            this.writer.flush();
            this.writer.close();
            this.newLogfile();
        }
    }

    @Override
    public synchronized void write(char[] cbuf, int off, int len) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.write(cbuf, off, len);
        this.writer.flush();
        this.length += (long)(len - off);
        this.checkRolling();
    }

    @Override
    public synchronized void write(String str) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.write(str);
        this.writer.flush();
        this.length += (long)str.length();
        this.checkRolling();
    }

    @Override
    public synchronized void write(String str, int off, int len) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.write(str, off, len);
        this.writer.flush();
        this.length += (long)(len - off);
        this.checkRolling();
    }

    @Override
    public synchronized void write(char[] cbuf) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.write(cbuf);
        this.writer.flush();
        this.length += (long)cbuf.length;
        this.checkRolling();
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.checkRolling();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
    }
}

