/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.file;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Comparator;

public class NumberBackupFileReducer {
    String directory;
    String prefix;
    int numberGenerations;

    public NumberBackupFileReducer(String directory, String prefix, int numberGenerations) {
        this.directory = directory;
        this.prefix = prefix;
        this.numberGenerations = numberGenerations;
    }

    private static long getFileCreationEpoch(File file) {
        try {
            BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return attr.creationTime().toInstant().toEpochMilli();
        }
        catch (IOException e) {
            throw new RuntimeException(file.getAbsolutePath(), e);
        }
    }

    private void sortByDateCreated(File[] files) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                long l1 = NumberBackupFileReducer.getFileCreationEpoch(f1);
                long l2 = NumberBackupFileReducer.getFileCreationEpoch(f2);
                return Long.valueOf(l1).compareTo(l2);
            }
        });
    }

    public void process() throws Exception {
        File[] files = new File(this.directory).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(NumberBackupFileReducer.this.prefix);
            }
        });
        if (files != null && files.length > this.numberGenerations) {
            this.sortByDateCreated(files);
            int toDelete = files.length - this.numberGenerations;
            for (int i = 0; i < toDelete; ++i) {
                files[i].delete();
            }
        }
    }
}

