/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.file;

import com.swiftmq.tools.file.NumberGenerationProvider;
import com.swiftmq.tools.file.RolloverSizeProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

public class RollingFileWriter
extends Writer {
    static SimpleDateFormat FMTROTATE = new SimpleDateFormat("'-'yyyyMMddHHmmss'.old'");
    String filename = null;
    File file = null;
    String directory = null;
    FileWriter writer = null;
    long length = 0L;
    int generation = 0;
    RolloverSizeProvider rolloverSizeProvider = null;
    NumberGenerationProvider numberGenerationProvider = null;

    public RollingFileWriter(String filename, RolloverSizeProvider rolloverSizeProvider, NumberGenerationProvider numberGenerationProvider) throws IOException {
        this(filename, rolloverSizeProvider);
        this.numberGenerationProvider = numberGenerationProvider;
    }

    public RollingFileWriter(String filename, RolloverSizeProvider rolloverSizeProvider) throws IOException {
        this.filename = filename;
        this.rolloverSizeProvider = rolloverSizeProvider;
        this.file = new File(filename);
        this.directory = this.file.getParent();
        if (this.file.exists()) {
            this.length = this.file.length();
        }
        this.writer = new FileWriter(filename, true);
    }

    public static void main(String[] args) {
        System.setOut(new PrintStream(new OutputStream(){
            byte[] buffer = new byte[1];
            Writer writer = null;

            @Override
            public void write(byte[] bytes) throws IOException {
                this.checkWriter();
                this.writer.write(new String(bytes));
            }

            @Override
            public void write(byte[] bytes, int i, int i1) throws IOException {
                this.checkWriter();
                this.writer.write(new String(bytes, i, i1));
            }

            @Override
            public void flush() throws IOException {
                this.checkWriter();
                this.writer.flush();
            }

            @Override
            public void close() throws IOException {
                this.checkWriter();
                this.writer.close();
            }

            @Override
            public void write(int i) throws IOException {
                this.checkWriter();
                this.buffer[0] = (byte)i;
                this.writer.write(new String(this.buffer));
            }

            private void checkWriter() throws IOException {
                if (this.writer == null) {
                    this.writer = new RollingFileWriter("/Users/am/temp/test.log", new RolloverSizeProvider(){

                        @Override
                        public long getRollOverSize() {
                            return 100L;
                        }
                    }, new NumberGenerationProvider(){

                        @Override
                        public int getNumberGenerations() {
                            return 5;
                        }
                    });
                }
            }
        }));
        for (int i = 0; i < 100; ++i) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("Dies ist Zeile " + i);
        }
    }

    private void checkGenerations() throws IOException {
        int ngen = this.numberGenerationProvider.getNumberGenerations();
        if (ngen <= 0) {
            return;
        }
        File dir = new File(this.directory);
        if (!dir.exists()) {
            dir.mkdir();
            return;
        }
        final String fn = this.file.getName();
        String[] names = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.startsWith(fn) && name.endsWith(".old");
            }
        });
        if (names != null) {
            Arrays.sort(names, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.substring(o1.indexOf(".old") - 14).compareTo(o2.substring(o2.indexOf(".old") - 14));
                }
            });
            int todDel = names.length - ngen;
            if (todDel > 0) {
                for (int i = 0; i < todDel; ++i) {
                    new File(dir, names[i]).delete();
                }
            }
        }
    }

    private void checkRolling() throws IOException {
        long max = this.rolloverSizeProvider.getRollOverSize();
        if (max == -1L) {
            return;
        }
        if (this.length > max) {
            this.writer.flush();
            this.writer.close();
            File f = new File(this.filename + "-" + this.generation++ + FMTROTATE.format(new Date()));
            this.file.renameTo(f);
            this.file = new File(this.filename);
            this.writer = new FileWriter(this.filename, true);
            this.length = 0L;
            if (this.numberGenerationProvider != null) {
                this.checkGenerations();
            }
        }
    }

    @Override
    public synchronized void write(char[] cbuf, int off, int len) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.write(cbuf, off, len);
        this.writer.flush();
        this.length += (long)(len - off);
        this.checkRolling();
    }

    @Override
    public synchronized void write(String str) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.write(str);
        this.writer.flush();
        this.length += (long)str.length();
        this.checkRolling();
    }

    @Override
    public synchronized void write(String str, int off, int len) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.write(str, off, len);
        this.writer.flush();
        this.length += (long)(len - off);
        this.checkRolling();
    }

    @Override
    public synchronized void write(char[] cbuf) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.write(cbuf);
        this.writer.flush();
        this.length += (long)cbuf.length;
        this.checkRolling();
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.checkRolling();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
    }
}

